/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmptyCollectionComparisonExpression
extends AbstractExpression {
    private String emptyIdentifier;
    private AbstractExpression expression;
    private boolean hasIs;
    private boolean hasNot;
    private boolean hasSpaceAfterIs;
    private String isIdentifier;
    private String notIdentifier;

    public EmptyCollectionComparisonExpression(AbstractExpression parent, AbstractExpression expression) {
        super(parent);
        this.updateExpression(expression);
    }

    EmptyCollectionComparisonExpression(AbstractExpression parent, String identifier, AbstractExpression expression) {
        super(parent, identifier);
        this.updateExpression(expression);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.expression != null) {
            children.add(this.expression);
        }
        if (this.hasExpression()) {
            children.add(this.buildStringExpression(' '));
        }
        children.add(this.buildStringExpression("IS"));
        if (this.hasSpaceAfterIs) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasNot) {
            children.add(this.buildStringExpression("NOT"));
        }
        children.add(this.buildStringExpression(' '));
        children.add(this.buildStringExpression("EMPTY"));
    }

    private StateFieldPathToCollectionValuedPathConverter buildConverter(AbstractExpression expression) {
        return new StateFieldPathToCollectionValuedPathConverter(this, expression);
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.expression != null && this.expression.isAncestor(expression)) {
            return this.getQueryBNF("collection_valued_path_expression");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualEmptyIdentifier() {
        return this.emptyIdentifier;
    }

    public String getActualIsIdentifier() {
        return this.isIdentifier != null ? this.isIdentifier : "";
    }

    public String getActualNotIdentifier() {
        return this.notIdentifier != null ? this.notIdentifier : "";
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    public String getIdentifier() {
        if (this.hasIs && this.hasNot) {
            return "IS NOT EMPTY";
        }
        if (!this.hasIs && this.hasNot) {
            return "NOT_EMPTY";
        }
        if (this.hasIs) {
            return "IS EMPTY";
        }
        return "EMPTY";
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("empty_collection_comparison_expression");
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasNot() {
        return this.hasNot;
    }

    public boolean hasSpaceAfterIs() {
        return this.hasSpaceAfterIs;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        String identifier = this.getText();
        if (identifier != null) {
            this.hasIs = true;
            this.isIdentifier = wordParser.moveForward("IS");
            this.hasSpaceAfterIs = true;
            wordParser.moveForward(1);
            boolean bl = this.hasNot = identifier == "IS NOT EMPTY";
            if (this.hasNot) {
                this.notIdentifier = wordParser.moveForward("NOT");
                wordParser.moveForward(1);
            }
            this.emptyIdentifier = wordParser.moveForward("EMPTY");
        } else {
            if (wordParser.startsWithIdentifier("IS")) {
                this.hasIs = true;
                this.isIdentifier = wordParser.moveForward("IS");
                this.hasSpaceAfterIs = wordParser.skipLeadingWhitespace() > 0;
            }
            this.hasNot = wordParser.startsWithIdentifier("NOT");
            if (this.hasNot) {
                this.notIdentifier = wordParser.moveForward("NOT");
                wordParser.skipLeadingWhitespace();
            }
            this.emptyIdentifier = wordParser.moveForward("EMPTY");
        }
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.expression != null) {
            this.expression.toParsedText(writer, actual);
            writer.append(' ');
        }
        if (this.hasIs) {
            writer.append(actual ? this.isIdentifier : "IS");
        }
        if (this.hasSpaceAfterIs) {
            writer.append(' ');
        }
        if (this.hasNot) {
            writer.append(actual ? this.notIdentifier : "NOT");
            writer.append(' ');
        }
        writer.append(actual ? this.emptyIdentifier : "EMPTY");
    }

    private void updateExpression(AbstractExpression expression) {
        if (expression != null) {
            StateFieldPathToCollectionValuedPathConverter converter = this.buildConverter(expression);
            expression.accept(converter);
            this.expression = converter.expression;
            this.expression.setParent(this);
            expression.setParent(this);
        }
    }

    private static class StateFieldPathToCollectionValuedPathConverter
    extends AbstractExpressionVisitor {
        private AbstractExpression expression;
        private AbstractExpression parent;

        StateFieldPathToCollectionValuedPathConverter(AbstractExpression parent, AbstractExpression expression) {
            this.parent = parent;
            this.expression = expression;
        }

        public void visit(StateFieldPathExpression expression) {
            this.expression = new CollectionValuedPathExpression(this.parent, expression.getText());
        }
    }
}

