/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RangeVariableDeclaration
extends AbstractExpression {
    private String asIdentifier;
    private boolean hasAs;
    private boolean hasSpaceAfterAs;
    private boolean hasSpaceAfterRootObject;
    private AbstractExpression identificationVariable;
    private AbstractExpression rootObject;
    private boolean virtualIdentificationVariable;

    public RangeVariableDeclaration(AbstractExpression parent) {
        super(parent);
    }

    public RangeVariableDeclaration(String entityName, String variableName) {
        super(null);
        this.rootObject = new AbstractSchemaName(this, entityName);
        this.identificationVariable = new IdentificationVariable(this, variableName);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getRootObject().accept(visitor);
        this.getIdentificationVariable().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getRootObject());
        children.add(this.getIdentificationVariable());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.rootObject != null) {
            children.add(this.rootObject);
        }
        if (this.hasSpaceAfterRootObject) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasAs) {
            children.add(this.buildStringExpression("AS"));
        }
        if (this.hasSpaceAfterAs) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.identificationVariable != null) {
            children.add(this.identificationVariable);
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.rootObject != null && this.rootObject.isAncestor(expression)) {
            return this.getQueryBNF("range_declaration");
        }
        if (this.identificationVariable != null && this.identificationVariable.isAncestor(expression)) {
            return this.getQueryBNF("identification_variable");
        }
        return super.findQueryBNF(expression);
    }

    @Deprecated
    public Expression getAbstractSchemaName() {
        return this.getRootObject();
    }

    public String getActualAsIdentifier() {
        return this.asIdentifier != null ? this.asIdentifier : "";
    }

    public Expression getIdentificationVariable() {
        if (this.identificationVariable == null) {
            this.identificationVariable = this.buildNullExpression();
        }
        return this.identificationVariable;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("range_variable_declaration");
    }

    public Expression getRootObject() {
        if (this.rootObject == null) {
            this.rootObject = this.buildNullExpression();
        }
        return this.rootObject;
    }

    @Deprecated
    public boolean hasAbstractSchemaName() {
        return this.hasRootObject();
    }

    public boolean hasAs() {
        return this.hasAs;
    }

    public boolean hasIdentificationVariable() {
        return this.identificationVariable != null && !this.identificationVariable.isNull() && !this.identificationVariable.isVirtual();
    }

    public boolean hasRootObject() {
        return this.rootObject != null && !this.rootObject.isNull();
    }

    @Deprecated
    public boolean hasSpaceAfterAbstractSchemaName() {
        return this.hasSpaceAfterRootObject;
    }

    public boolean hasSpaceAfterAs() {
        return this.hasSpaceAfterAs;
    }

    public boolean hasSpaceAfterRootObject() {
        return this.hasSpaceAfterRootObject;
    }

    public boolean hasVirtualIdentificationVariable() {
        return this.virtualIdentificationVariable;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("AS") || word.equalsIgnoreCase("SET") || word.equalsIgnoreCase("INNER") || word.equalsIgnoreCase("JOIN") || word.equalsIgnoreCase("LEFT") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.rootObject = this.parse(wordParser, "range_declaration", tolerant);
        this.hasSpaceAfterRootObject = wordParser.skipLeadingWhitespace() > 0;
        this.hasAs = wordParser.startsWithIdentifier("AS");
        if (this.hasAs) {
            this.asIdentifier = wordParser.moveForward("AS");
            this.hasSpaceAfterAs = wordParser.skipLeadingWhitespace() > 0;
        }
        this.identificationVariable = this.parseIdentificationVariable(wordParser, tolerant);
    }

    private AbstractExpression parseIdentificationVariable(WordParser wordParser, boolean tolerant) {
        if (wordParser.startsWithIdentifier("SET")) {
            return null;
        }
        if (tolerant) {
            return this.parse(wordParser, "identification_variable", tolerant);
        }
        IdentificationVariable expression = new IdentificationVariable(this, wordParser.word());
        ((AbstractExpression)expression).parse(wordParser, tolerant);
        return expression;
    }

    public void setVirtualIdentificationVariable(String variableName) {
        this.virtualIdentificationVariable = true;
        this.identificationVariable = new IdentificationVariable(this, variableName, true);
    }

    public void setVirtualIdentificationVariable(String variableName, String path) {
        CollectionValuedPathExpression expression = new CollectionValuedPathExpression((AbstractExpression)this, path);
        expression.setVirtualIdentificationVariable(variableName);
        this.rootObject = expression;
    }

    @Override
    protected boolean shouldParseWithFactoryFirst() {
        return false;
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.rootObject != null) {
            this.rootObject.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterRootObject) {
            writer.append(' ');
        }
        if (this.hasAs) {
            writer.append(actual ? this.asIdentifier : "AS");
        }
        if (this.hasSpaceAfterAs) {
            writer.append(' ');
        }
        if (this.identificationVariable != null && !this.virtualIdentificationVariable) {
            this.identificationVariable.toParsedText(writer, actual);
        }
    }
}

