/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Properties;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.ExclusiveIndexWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.SharedIndexWorkspaceImpl;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.indexes.impl.CommonPropertiesParse;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class WorkspaceFactory {
    private static final Log log = LoggerFactory.make();

    WorkspaceFactory() {
    }

    static AbstractWorkspaceImpl createWorkspace(DirectoryBasedIndexManager indexManager, ErrorHandler errorHandler, Properties cfg) {
        String indexName = indexManager.getIndexName();
        boolean exclusiveIndexUsage = CommonPropertiesParse.isExclusiveIndexUsageEnabled(indexName, cfg);
        if (exclusiveIndexUsage) {
            log.debugf("Starting workspace for index " + indexName + " using an exclusive index strategy", new Object[0]);
            return new ExclusiveIndexWorkspaceImpl(indexManager, errorHandler);
        }
        log.debugf("Starting workspace for index " + indexName + " using a shared index strategy", new Object[0]);
        return new SharedIndexWorkspaceImpl(indexManager, errorHandler);
    }
}

