/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.stream.impl.delegator.zip;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.ow2.util.stream.api.IStreamAccessor;
import org.ow2.util.stream.impl.delegator.DelegatorStreamAccessor;

public class DelegatorZipStreamAccessor
extends DelegatorStreamAccessor
implements IStreamAccessor {
    private static final int BUFFER_SIZE = 8192;
    private String fileName;

    private static InputStream getInputStream(IStreamAccessor parentFileAccessor, String fileName) throws IOException {
        InputStream parentInputStream;
        try {
            parentInputStream = parentFileAccessor.getInputStream();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        ZipInputStream zipInputStream = new ZipInputStream(parentInputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry == null) {
            return null;
        }
        while (!zipEntry.getName().equals(fileName)) {
            zipEntry = zipInputStream.getNextEntry();
            if (zipEntry != null) continue;
            return null;
        }
        return zipInputStream;
    }

    public DelegatorZipStreamAccessor(IStreamAccessor parentFileAccessor, String fileName) throws ZipException, IOException {
        super(parentFileAccessor, DelegatorZipStreamAccessor.getInputStream(parentFileAccessor, fileName));
        this.fileName = fileName;
    }

    protected void writeToParent(IStreamAccessor parentFileAccessor, InputStream localFileInputStream) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(parentFileAccessor.getTemporaryOutputStream());
        InputStream parentInputStream = null;
        try {
            parentInputStream = parentFileAccessor.getInputStream();
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        byte[] buf = new byte[8192];
        boolean fileFound = false;
        if (parentInputStream != null) {
            ZipInputStream zipInputStream = new ZipInputStream(parentInputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                InputStream inputStream;
                boolean replaceZipFile = zipEntry.getName().equals(this.fileName);
                if (!replaceZipFile) {
                    inputStream = zipInputStream;
                } else {
                    zipEntry = new ZipEntry(this.fileName);
                    inputStream = localFileInputStream;
                    fileFound = true;
                }
                zipOutputStream.putNextEntry(zipEntry);
                int read = inputStream.read(buf);
                while (read != -1) {
                    zipOutputStream.write(buf, 0, read);
                    read = inputStream.read(buf);
                }
                if (replaceZipFile) {
                    inputStream.close();
                } else {
                    zipInputStream.closeEntry();
                }
                zipOutputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
        }
        if (!fileFound) {
            ZipEntry newZipEntry = new ZipEntry(this.fileName);
            zipOutputStream.putNextEntry(newZipEntry);
            int read = localFileInputStream.read(buf);
            while (read != -1) {
                zipOutputStream.write(buf, 0, read);
                read = localFileInputStream.read(buf);
            }
            localFileInputStream.close();
            zipOutputStream.closeEntry();
        }
        zipOutputStream.close();
    }
}

