/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.joram.admin;

import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Unbind;
import org.apache.felix.ipojo.annotations.Validate;
import org.objectweb.joram.client.connector.JoramAdapterMBean;
import org.objectweb.joram.client.jms.TopicMBean;
import org.osgi.framework.ServiceReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component(name="JoramTopic", immediate=false)
public class JoramTopic
implements Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(JoramTopic.class);
    private boolean __FjndiName;
    @Property(name="jndi.name", mandatory=true)
    private String jndiName;
    private boolean __Fservice;
    @Requires
    private JoramAdapterMBean service;
    private boolean __Ftopic;
    private TopicMBean topic;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MbindTopicService$org_objectweb_joram_client_jms_TopicMBean$org_osgi_framework_ServiceReference;
    private boolean __MunbindTopicService$org_osgi_framework_ServiceReference;

    String __getjndiName() {
        if (!this.__FjndiName) {
            return this.jndiName;
        }
        return (String)this.__IM.onGet((Object)this, "jndiName");
    }

    void __setjndiName(String string) {
        if (!this.__FjndiName) {
            this.jndiName = string;
            return;
        }
        this.__IM.onSet((Object)this, "jndiName", (Object)string);
    }

    JoramAdapterMBean __getservice() {
        if (!this.__Fservice) {
            return this.service;
        }
        return (JoramAdapterMBean)this.__IM.onGet((Object)this, "service");
    }

    void __setservice(JoramAdapterMBean joramAdapterMBean) {
        if (!this.__Fservice) {
            this.service = joramAdapterMBean;
            return;
        }
        this.__IM.onSet((Object)this, "service", (Object)joramAdapterMBean);
    }

    TopicMBean __gettopic() {
        if (!this.__Ftopic) {
            return this.topic;
        }
        return (TopicMBean)this.__IM.onGet((Object)this, "topic");
    }

    void __settopic(TopicMBean topicMBean) {
        if (!this.__Ftopic) {
            this.topic = topicMBean;
            return;
        }
        this.__IM.onSet((Object)this, "topic", (Object)topicMBean);
    }

    public JoramTopic() {
        this(null);
    }

    private JoramTopic(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Validate
    private void __M_start() {
        ClassLoader old = null;
        try {
            ClassLoader ext = this.getClass().getClassLoader();
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ext);
            String res = this.__getservice().createTopic(this.__getjndiName());
            logger.info((Object)("Create the topic '" + this.__getjndiName() + "' : " + res), new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)("Error when creating the topic '" + this.__getjndiName() + "'"), new Object[]{e});
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        try {
            if (this.__gettopic() != null) {
                this.__gettopic().delete();
                logger.info((Object)("Remove the topic '" + this.__getjndiName() + "'"), new Object[0]);
            } else {
                logger.warn((Object)("Unable to remove the topic service '" + this.__getjndiName() + "'. Service unavailable"), new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error when removing the topic '" + this.__getjndiName() + "'"), new Object[]{e});
        }
    }

    public void bindTopicService(TopicMBean service, ServiceReference ref) {
        if (!this.__MbindTopicService$org_objectweb_joram_client_jms_TopicMBean$org_osgi_framework_ServiceReference) {
            this.__M_bindTopicService(service, ref);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindTopicService$org_objectweb_joram_client_jms_TopicMBean$org_osgi_framework_ServiceReference", new Object[]{service, ref});
            this.__M_bindTopicService(service, ref);
            this.__IM.onExit((Object)this, "bindTopicService$org_objectweb_joram_client_jms_TopicMBean$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindTopicService$org_objectweb_joram_client_jms_TopicMBean$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Bind(optional=true, aggregate=true)
    private void __M_bindTopicService(TopicMBean service, ServiceReference ref) {
        String serviceName = (String)ref.getProperty("name");
        if (serviceName.startsWith(this.__getjndiName() + "[#")) {
            this.__settopic(service);
            logger.debug((Object)("Bind TopicService - " + serviceName), new Object[0]);
        }
    }

    public void unbindTopicService(ServiceReference ref) {
        if (!this.__MunbindTopicService$org_osgi_framework_ServiceReference) {
            this.__M_unbindTopicService(ref);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindTopicService$org_osgi_framework_ServiceReference", new Object[]{ref});
            this.__M_unbindTopicService(ref);
            this.__IM.onExit((Object)this, "unbindTopicService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindTopicService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Unbind
    private void __M_unbindTopicService(ServiceReference ref) {
        String name = (String)ref.getProperty("name");
        if (name.startsWith(this.__getjndiName() + "[#")) {
            this.__settopic(null);
            logger.debug((Object)("Unbind Service - " + name), new Object[0]);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("jndiName")) {
                this.__FjndiName = true;
            }
            if (set.contains("service")) {
                this.__Fservice = true;
            }
            if (set.contains("topic")) {
                this.__Ftopic = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("bindTopicService$org_objectweb_joram_client_jms_TopicMBean$org_osgi_framework_ServiceReference")) {
                this.__MbindTopicService$org_objectweb_joram_client_jms_TopicMBean$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("unbindTopicService$org_osgi_framework_ServiceReference")) {
                this.__MunbindTopicService$org_osgi_framework_ServiceReference = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

