/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.ssh.server.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;

public class CommandFactoryImpl
implements CommandFactory {
    private CommandProcessor commandProcessor;

    public CommandFactoryImpl(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public Command createCommand(String command) {
        return new ShellCommand(command);
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public class ShellCommand
    implements Command,
    SessionAware {
        private String command;
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback callback;
        private ServerSession session;

        public ShellCommand(String command) {
            this.command = command;
        }

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(ExitCallback callback) {
            this.callback = callback;
        }

        public void setSession(ServerSession session) {
            this.session = session;
        }

        public void start(Environment env) throws IOException {
            int returnCode = 0;
            String message = null;
            PrintStream pout = new PrintStream(this.out);
            PrintStream perr = new PrintStream(this.err);
            try {
                CommandSession session = CommandFactoryImpl.this.commandProcessor.createSession(this.in, pout, perr);
                session.execute((CharSequence)this.command);
            }
            catch (Exception e) {
                try {
                    returnCode = 1;
                    message = e.getMessage();
                    perr.println(message);
                    throw (IOException)new IOException("Unable to execute the command").initCause(e);
                }
                catch (Throwable throwable) {
                    CommandFactoryImpl.close(new Closeable[]{this.in, pout, perr});
                    this.callback.onExit(returnCode, message);
                    throw throwable;
                }
            }
            CommandFactoryImpl.close(new Closeable[]{this.in, pout, perr});
            this.callback.onExit(returnCode, message);
        }

        public void destroy() {
        }
    }
}

