/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jaxrs.jersey.internal;

import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.UriBuilder;
import org.osgi.framework.ServiceReference;

public class PathUtils {
    public static String getContextPath(Application application, ServiceReference reference) {
        String applicationPath;
        StringBuilder sb = new StringBuilder();
        String path = (String)reference.getProperty("jonas.jaxrs.context-path");
        if (path != null) {
            path = PathUtils.cleanupPath(path);
            sb.append(path);
        } else {
            sb.append('/').append(reference.getBundle().getSymbolicName()).append('/').append(reference.getBundle().getVersion());
        }
        Class<?> appClass = application.getClass();
        if (appClass.isAnnotationPresent(ApplicationPath.class) && (applicationPath = appClass.getAnnotation(ApplicationPath.class).value()) != null) {
            applicationPath = PathUtils.cleanupPath(applicationPath);
            sb.append(applicationPath);
        }
        return UriBuilder.fromPath(sb.toString()).build(new Object[0]).toASCIIString();
    }

    private static String cleanupPath(String path) {
        String cleaned = path;
        if (path.charAt(0) != '/') {
            cleaned = "/" + path;
        }
        if (path.endsWith("/") && !"/".equals(path)) {
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        }
        return cleaned;
    }
}

