/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.List;
import javax.rmi.PortableRemoteObject;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.Xid;
import org.objectweb.jotm.Control;
import org.objectweb.jotm.Coordinator;
import org.objectweb.jotm.HeuristicCommit;
import org.objectweb.jotm.HeuristicHazard;
import org.objectweb.jotm.HeuristicMixed;
import org.objectweb.jotm.HeuristicRollback;
import org.objectweb.jotm.InactiveException;
import org.objectweb.jotm.Log;
import org.objectweb.jotm.NotPreparedException;
import org.objectweb.jotm.RecoveryCoordinator;
import org.objectweb.jotm.RemoteSynchro;
import org.objectweb.jotm.Resource;
import org.objectweb.jotm.ResourceInfo;
import org.objectweb.jotm.StatusHelper;
import org.objectweb.jotm.Terminator;
import org.objectweb.jotm.TimerEvent;
import org.objectweb.jotm.TimerEventListener;
import org.objectweb.jotm.TimerManager;
import org.objectweb.jotm.TraceTm;
import org.ow2.carol.rmi.exception.RmiUtility;
import org.ow2.carol.util.configuration.ConfigurationRepository;

public class ControlImpl
extends PortableRemoteObject
implements Control,
Resource,
Coordinator,
Terminator,
RecoveryCoordinator,
TimerEventListener {
    private List<Resource> resourceList = new ArrayList<Resource>();
    private List<RemoteSynchro> synchronizationList = new ArrayList<RemoteSynchro>();
    private int mystatus = 5;
    private boolean hasSupCoord = false;
    private TimerEvent mytimer = null;
    private Xid xid;
    private Log mylog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ControlImpl(int timeout, Xid x, Object supco) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("timeout=" + timeout + ", xid=" + x + ", supco=" + supco));
        }
        ControlImpl controlImpl = this;
        synchronized (controlImpl) {
            this.mystatus = 0;
            this.xid = x;
            this.hasSupCoord = supco != null;
            this.mytimer = TimerManager.getInstance().addTimer(this, timeout, 1, false);
        }
        if (supco != null) {
            try {
                if (!(supco instanceof Coordinator)) {
                    throw new RemoteException("Not Implemented");
                }
                ((Coordinator)supco).register_resource(this);
            }
            catch (Exception e) {
                TraceTm.jotm.error((Object)"Cannot register sub-coordinator:\n", (Throwable)e);
            }
        }
    }

    public Terminator get_terminator() throws RemoteException {
        return this;
    }

    public Coordinator get_coordinator() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.get_coordinator");
        }
        return this;
    }

    public int get_status() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.get_status()");
        }
        return this.mystatus;
    }

    public boolean is_same_transaction(Coordinator tc) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.is_same_transaction(Coordinator)");
        }
        String other = null;
        try {
            other = tc.get_transaction_name();
        }
        catch (Exception e) {
            if (TraceTm.jotm.isDebugEnabled()) {
                TraceTm.jotm.error((Object)"ControlImpl.is_same_transaction() raised exception:\n", (Throwable)e);
            }
            return false;
        }
        return other.equals(this.get_transaction_name());
    }

    public synchronized RecoveryCoordinator register_resource(Resource res) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("resource=" + res));
            TraceTm.jotm.debug((Object)("mystatus=" + StatusHelper.getStatusName(this.mystatus)));
        }
        switch (this.mystatus) {
            case 0: {
                this.resourceList.add(res);
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)("Resource registered:" + res));
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                TraceTm.jotm.error((Object)"ControlImpl.register_resource(): Transaction Rolled back");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                throw new TransactionRolledbackException();
            }
            default: {
                TraceTm.jotm.error((Object)"ControlImpl.register_resource(): Transaction Inactive");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                throw new InactiveException("Cannot register resource, status " + StatusHelper.getStatusName(this.mystatus));
            }
        }
        return this;
    }

    public synchronized void register_synchronization(RemoteSynchro sync) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("sync=" + sync));
            TraceTm.jotm.debug((Object)("mystatus=" + StatusHelper.getStatusName(this.mystatus)));
        }
        switch (this.mystatus) {
            case 0: {
                this.synchronizationList.add(sync);
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)"ControlImpl.register_synchronization(): RemoteSynchro registered");
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                TraceTm.jotm.error((Object)"ControlImpl.register_synchronization(): Transaction Rolled back");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                throw new TransactionRolledbackException();
            }
            default: {
                TraceTm.jotm.error((Object)"ControlImpl.register_synchronization(): Transaction Inactive");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                throw new InactiveException("Cannot register synchronization, status " + StatusHelper.getStatusName(this.mystatus));
            }
        }
    }

    public synchronized void rollback_only() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("mystatus=" + StatusHelper.getStatusName(this.mystatus)));
        }
        switch (this.mystatus) {
            case 1: {
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)"ControlImpl.rollback_only(): Already marked rolledback");
                break;
            }
            case 0: {
                this.mystatus = 1;
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)"ControlImpl.rollback_only(): Marked rollback");
                break;
            }
            default: {
                TraceTm.jotm.error((Object)"ControlImpl.rollback_only(): Inactive");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                throw new InactiveException("Cannot rollback transaction, status " + StatusHelper.getStatusName(this.mystatus));
            }
        }
    }

    public String get_transaction_name() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.get_transaction_name()");
        }
        return this.xid.toString();
    }

    public synchronized void commit(boolean report_heuristics) throws RemoteException {
        int errors;
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("report_heuristics=" + report_heuristics));
            TraceTm.jotm.debug((Object)("mystatus=" + StatusHelper.getStatusName(this.mystatus)));
        }
        String protocol = ConfigurationRepository.getCurrentConfiguration().getProtocol().getName();
        if (this.mytimer != null) {
            this.mytimer.stop();
        }
        switch (this.mystatus) {
            case 0: {
                break;
            }
            case 3: {
                TraceTm.jotm.error((Object)"ControlImpl.commit(boolean): already done");
                return;
            }
            case 4: {
                TraceTm.jotm.error((Object)"ControlImpl.commit(boolean): already rolled back");
                this.completed(true);
                if (protocol == null || !protocol.equals("iiop")) {
                    throw new TransactionRolledbackException();
                }
                RmiUtility.rethrowRmiException((Exception)((Object)new TransactionRolledbackException()));
            }
            case 1: {
                errors = this.do_before_completion();
                if (errors > 0) {
                    TraceTm.jotm.info((Object)"ControlImpl.commit(boolean): before completion error at rollback");
                }
                this.do_rollback(report_heuristics);
                this.completed(true);
                if (protocol == null || !protocol.equals("iiop")) {
                    throw new TransactionRolledbackException();
                }
                RmiUtility.rethrowRmiException((Exception)((Object)new TransactionRolledbackException()));
            }
            default: {
                TraceTm.jotm.error((Object)"ControlImpl.commit(boolean): bad status");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                if (protocol == null || !protocol.equals("iiop")) {
                    throw new HeuristicMixed();
                }
                RmiUtility.rethrowRmiException((Exception)new HeuristicMixed());
            }
        }
        if (this.resourceList.size() == 1) {
            TraceTm.jotm.debug((Object)"1 resource");
            errors = this.do_before_completion();
            if (errors > 0) {
                TraceTm.jotm.info((Object)"before completion error -> rollback");
                this.do_rollback(report_heuristics);
                this.completed(true);
                if (protocol == null || !protocol.equals("iiop")) {
                    throw new TransactionRolledbackException();
                }
                RmiUtility.rethrowRmiException((Exception)((Object)new TransactionRolledbackException()));
            }
            this.mystatus = 8;
            try {
                Resource res = this.resourceList.get(0);
                res.commit_one_phase();
                this.mystatus = 3;
            }
            catch (TransactionRolledbackException e) {
                TraceTm.jotm.info((Object)"commit_one_phase = TransactionRolledbackException");
                this.mystatus = 4;
            }
            catch (HeuristicHazard e) {
                TraceTm.jotm.info((Object)"commit_one_phase = HeuristicException");
                this.mystatus = 5;
            }
            catch (NoSuchObjectException e) {
                TraceTm.jotm.info((Object)"commit_one_phase = NoSuchObjectException");
                this.mystatus = 4;
            }
            catch (ServerException e) {
                TraceTm.jotm.info((Object)("commit_one_phase = ServerException: " + e));
                this.mystatus = 4;
            }
            catch (Exception e) {
                TraceTm.jotm.error((Object)"commit_one_phase = Unexpected exception: ", (Throwable)e);
                this.mystatus = 5;
            }
            this.do_after_completion();
            switch (this.mystatus) {
                case 3: {
                    this.completed(true);
                    break;
                }
                case 4: {
                    this.completed(true);
                    if (protocol == null || !protocol.equals("iiop")) {
                        throw new TransactionRolledbackException();
                    }
                    RmiUtility.rethrowRmiException((Exception)((Object)new TransactionRolledbackException()));
                }
                case 5: {
                    this.completed(false);
                    if (!report_heuristics) break;
                    if (protocol == null || !protocol.equals("iiop")) {
                        throw new HeuristicHazard();
                    }
                    RmiUtility.rethrowRmiException((Exception)new HeuristicHazard());
                }
            }
            return;
        }
        int v = this.do_prepare(report_heuristics);
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("Vote = " + v));
        }
        switch (v) {
            case 0: {
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)"ControlImpl.commit(boolean): committing Tx");
                break;
            }
            case 1: {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"ControlImpl.commit(boolean): rolling back Tx");
                }
                this.do_rollback(report_heuristics);
                this.completed(true);
                if (protocol == null || !protocol.equals("iiop")) {
                    throw new TransactionRolledbackException();
                }
                RmiUtility.rethrowRmiException((Exception)((Object)new TransactionRolledbackException()));
            }
            case 2: {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"ControlImpl.commit(boolean): readonly resources");
                }
                this.mystatus = 3;
                this.completed(true);
                return;
            }
        }
        this.mylog.flushLog(1);
        if (this.do_commit(report_heuristics) == 0) {
            this.completed(true);
        } else {
            this.completed(false);
        }
    }

    public synchronized void rollback() throws RemoteException {
        int errors;
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("mystatus=" + StatusHelper.getStatusName(this.mystatus)));
        }
        String protocol = ConfigurationRepository.getCurrentConfiguration().getProtocol().getName();
        if (this.mytimer != null) {
            this.mytimer.stop();
        }
        switch (this.mystatus) {
            case 0: 
            case 1: {
                break;
            }
            case 4: {
                TraceTm.jotm.error((Object)"ControlImpl.rollback(): already rolled back");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                return;
            }
            default: {
                TraceTm.jotm.error((Object)"ControlImpl.rollback(): rollback: bad status");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                this.completed(false);
                if (protocol == null || !protocol.equals("iiop")) {
                    throw new HeuristicMixed("rollback: bad status");
                }
                RmiUtility.rethrowRmiException((Exception)((Object)new TransactionRolledbackException()));
            }
        }
        if (!this.hasSupCoord && (errors = this.do_before_completion()) > 0) {
            TraceTm.jotm.info((Object)"ControlImpl.rollback(): before completion error at rollback");
        }
        try {
            this.do_rollback(false);
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)"ControlImpl.rollback(): rollback raised exception ", (Throwable)e);
        }
        this.completed(true);
    }

    public synchronized int prepare() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("mystatus=" + StatusHelper.getStatusName(this.mystatus)));
        }
        if (this.mytimer != null) {
            this.mytimer.stop();
        }
        switch (this.mystatus) {
            case 0: {
                break;
            }
            case 3: {
                TraceTm.jotm.error((Object)"ControlImpl.prepare(): transaction already commited");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                return 0;
            }
            case 4: {
                TraceTm.jotm.error((Object)"ControlImpl.prepare(): transaction already rolled back");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                return 1;
            }
            case 1: {
                this.do_rollback(false);
                this.completed(true);
                return 1;
            }
            default: {
                TraceTm.jotm.error((Object)"ControlImpl.prepare(): bad status");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                this.completed(false);
                return 1;
            }
        }
        int ret = this.do_prepare(false);
        switch (ret) {
            case 0: {
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)"ControlImpl.prepare(): vote commit");
                break;
            }
            case 1: {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"ControlImpl.prepare(): vote rollback");
                }
                this.do_rollback(false);
                this.completed(true);
                return ret;
            }
            case 2: {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"ControlImpl.prepare(): vote readonly");
                }
                this.mystatus = 3;
                this.completed(true);
                return ret;
            }
        }
        return ret;
    }

    public synchronized void commit() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("mystatus=" + StatusHelper.getStatusName(this.mystatus)));
        }
        switch (this.mystatus) {
            case 2: {
                break;
            }
            default: {
                TraceTm.jotm.error((Object)"ControlImpl.commit(): commit: bad status");
                TraceTm.jotm.error((Object)("mystatus= " + StatusHelper.getStatusName(this.mystatus)));
                this.completed(false);
                return;
            }
        }
        if (this.do_commit(true) == 0) {
            this.completed(true);
        } else {
            this.completed(false);
        }
    }

    public void commit_one_phase() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.commit_one_phase()");
        }
        this.commit(true);
    }

    public synchronized void forget() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.forget()");
        }
        this.completed(true);
    }

    public int replay_completion(Resource res) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("res=" + res));
        }
        return this.mystatus;
    }

    public void timeoutExpired(Object arg) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("arg=" + arg));
        }
        int argvalue = (Integer)arg;
        switch (argvalue) {
            case 1: {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"ControlImpl.timeoutExpired(Object): timeout expired");
                }
                try {
                    this.do_rollback(false);
                }
                catch (Exception e) {
                    TraceTm.jotm.error((Object)"ControlImpl.timeoutExpired(Object): rollback raised exception ", (Throwable)e);
                }
                break;
            }
            case 2: {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"ControlImpl.timeoutExpired(Object): removing ControlImpl");
                }
                this.explicit_destroy();
                break;
            }
            default: {
                TraceTm.jotm.error((Object)("ControlImpl.timeoutExpired(Object): timeoutExpired bad value=" + argvalue));
            }
        }
    }

    void ding() {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"");
        }
    }

    private int do_prepare(boolean report_heuristics) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("report_heuristics=" + report_heuristics));
        }
        int errors = 0;
        int ret = 2;
        errors = this.do_before_completion();
        if (errors > 0) {
            if (TraceTm.jotm.isDebugEnabled()) {
                TraceTm.jotm.debug((Object)"before_completion failed -> rollback");
            }
            return 1;
        }
        if (this.resourceList.size() == 0) {
            TraceTm.jotm.error((Object)"commit: no resource");
            this.mystatus = 3;
            this.do_after_completion();
            this.completed(true);
            return ret;
        }
        this.mylog = new Log();
        this.mystatus = 7;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            Resource res = this.resourceList.get(i);
            if (errors > 0) {
                if (!TraceTm.jotm.isWarnEnabled()) break;
                TraceTm.jotm.warn((Object)"Vote stopped: at least one resource has voted rollback.");
                break;
            }
            try {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)("send prepare to resource:" + res));
                }
                switch (res.prepare()) {
                    case 0: {
                        this.mylog.addResource(res);
                        TraceTm.jotm.info((Object)"Resource replied commit to prepare");
                        ret = 0;
                        break;
                    }
                    case 1: {
                        TraceTm.jotm.info((Object)"Resource replied rollback to prepare");
                        ret = 1;
                        ++errors;
                        break;
                    }
                    case 2: {
                        if (!TraceTm.jotm.isDebugEnabled()) break;
                        TraceTm.jotm.debug((Object)"Resource replied readonly to prepare");
                    }
                }
                continue;
            }
            catch (HeuristicHazard e) {
                TraceTm.jotm.error((Object)"HeuristicHazard on prepare");
                ret = 1;
                ++errors;
                continue;
            }
            catch (HeuristicMixed e) {
                TraceTm.jotm.error((Object)"HeuristicMixed on prepare");
                ret = 1;
                ++errors;
                continue;
            }
            catch (Exception e) {
                TraceTm.jotm.error((Object)"exception on prepare: ", (Throwable)e);
                ret = 1;
                ++errors;
            }
        }
        if (ret == 2) {
            if (TraceTm.jotm.isDebugEnabled()) {
                TraceTm.jotm.debug((Object)"All resources returned Readonly");
            }
            this.mystatus = 3;
            this.do_after_completion();
        }
        if (ret == 0) {
            this.mystatus = 2;
        }
        if (TraceTm.jotm.isDebugEnabled() && TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("Vote = " + ret));
        }
        return ret;
    }

    private int do_commit(boolean report_heuristics) throws TransactionRolledbackException, HeuristicMixed, HeuristicHazard, HeuristicRollback {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("report_heuristics=" + report_heuristics));
        }
        if (this.mylog == null) {
            TraceTm.jotm.error((Object)"no log");
            return -1;
        }
        this.mystatus = 8;
        int commitnb = 0;
        int heuristicnb = 0;
        int errors = 0;
        int heuristicstate = 0;
        for (int i = 0; i < this.mylog.resourceLogged.size(); ++i) {
            ResourceInfo resinfo = (ResourceInfo)this.mylog.resourceLogged.elementAt(i);
            if (resinfo.mystate != 2) {
                TraceTm.jotm.info((Object)"resource not prepared");
                continue;
            }
            try {
                TraceTm.jotm.debug((Object)("Send commit to prepared resource: " + resinfo.getResource()));
                resinfo.getResource().commit();
                resinfo.mystate = 3;
                ++commitnb;
                continue;
            }
            catch (HeuristicRollback e) {
                TraceTm.jotm.error((Object)"Heuristic Rollback");
                resinfo.mystate = 6;
                heuristicstate = 6;
                ++errors;
                if (commitnb <= 0) continue;
                ++heuristicnb;
                continue;
            }
            catch (HeuristicMixed e) {
                TraceTm.jotm.error((Object)"Heuristic Mixed");
                resinfo.mystate = 7;
                heuristicstate = 7;
                ++errors;
                ++commitnb;
                ++heuristicnb;
                continue;
            }
            catch (HeuristicHazard e) {
                TraceTm.jotm.error((Object)"Heuristic Hazard");
                resinfo.mystate = 8;
                heuristicstate = 8;
                ++errors;
                ++commitnb;
                ++heuristicnb;
                continue;
            }
            catch (NotPreparedException e) {
                TraceTm.jotm.error((Object)"Resource Not Prepared");
                resinfo.mystate = 1;
                ++errors;
                continue;
            }
            catch (NoSuchObjectException e) {
                TraceTm.jotm.error((Object)"invalid objref - assume committed");
                resinfo.mystate = 3;
                ++commitnb;
                continue;
            }
            catch (Exception e) {
                TraceTm.jotm.error((Object)"exception on commit: ", (Throwable)e);
                ++errors;
            }
        }
        if (errors == 0) {
            if (TraceTm.jotm.isDebugEnabled()) {
                TraceTm.jotm.debug((Object)"transaction committed");
            }
            this.mystatus = 3;
            this.mylog.forgetLog();
            this.do_after_completion();
            return 0;
        }
        if (heuristicnb == 0) {
            TraceTm.jotm.info((Object)"transaction rolled back");
            this.mystatus = 4;
            this.mylog.forgetLog();
            this.do_after_completion();
            throw new TransactionRolledbackException();
        }
        TraceTm.jotm.info((Object)"Heuristics must be logged");
        this.mystatus = 5;
        this.mylog.updateLog();
        this.do_after_completion();
        if (report_heuristics) {
            switch (heuristicstate) {
                case 6: {
                    throw new HeuristicRollback();
                }
                case 7: {
                    throw new HeuristicMixed();
                }
                case 8: {
                    throw new HeuristicHazard();
                }
            }
        }
        return -1;
    }

    private void do_rollback(boolean report_heuristics) throws HeuristicMixed {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("report_heuristics=" + report_heuristics));
        }
        this.mystatus = 4;
        int commitnb = 0;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            Resource res = this.resourceList.get(i);
            try {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)("Send rollback to Resource:" + res));
                }
                res.rollback();
                continue;
            }
            catch (HeuristicCommit e) {
                TraceTm.jotm.error((Object)"Rollback raised HeuristicCommit");
                ++commitnb;
                continue;
            }
            catch (Exception e) {
                TraceTm.jotm.error((Object)"Cannot rollback resource: ", (Throwable)e);
            }
        }
        this.do_after_completion();
        if (commitnb > 0 && report_heuristics) {
            throw new HeuristicMixed();
        }
    }

    private void explicit_destroy() {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"");
        }
        try {
            ControlImpl.unexportObject((Remote)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void completed(boolean removeit) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("removeit=" + removeit));
        }
        if (this.mytimer != null) {
            if (removeit) {
                this.mytimer.change(60L, 2);
            } else {
                this.mytimer.unset();
                this.mytimer = null;
            }
        }
    }

    private int do_before_completion() {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.do_before_completion()");
            TraceTm.jotm.debug((Object)("synchronizationList.size()=" + this.synchronizationList.size()));
        }
        int errors = 0;
        for (int i = 0; i < this.synchronizationList.size(); ++i) {
            RemoteSynchro sync = this.synchronizationList.get(i);
            try {
                sync.before_completion(this);
                continue;
            }
            catch (Exception e) {
                TraceTm.jotm.error((Object)"before_completion raised exception ", (Throwable)e);
                ++errors;
            }
        }
        return errors;
    }

    private void do_after_completion() {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"ControlImpl.do_after_completion()");
            TraceTm.jotm.debug((Object)("status=" + this.mystatus));
            TraceTm.jotm.debug((Object)("synchronizationList.size()=" + this.synchronizationList.size()));
        }
        for (int i = 0; i < this.synchronizationList.size(); ++i) {
            RemoteSynchro sync = this.synchronizationList.get(i);
            try {
                sync.after_completion(this, this.mystatus);
                continue;
            }
            catch (Exception e) {
                TraceTm.jotm.error((Object)"after_completion raised exception ", (Throwable)e);
            }
        }
    }
}

