/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.limited.clue;

import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.clue.ICluePool;
import org.ow2.util.pool.impl.enhanced.impl.limited.LimitedWaiterPool;
import org.ow2.util.pool.impl.enhanced.impl.limited.TooManyWaiterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitedWaiterCluePool<E, C>
extends LimitedWaiterPool<E>
implements ICluePool<E, C> {
    private Object mutex;
    private int maxClueWaiter;
    private int currentClueWaiter;
    private int maxNoClueWaiter;
    private int currentNoClueWaiter;
    private ICluePool<E, C> cluePool;

    public LimitedWaiterCluePool(ICluePool<E, C> cluePool) {
        this(cluePool, -1, -1, -1);
    }

    public LimitedWaiterCluePool(ICluePool<E, C> cluePool, int maxWaiter) {
        this(cluePool, maxWaiter, -1, -1);
    }

    public LimitedWaiterCluePool(ICluePool<E, C> cluePool, int maxWaiter, int maxClueWaiter, int maxNoClueWaiter) {
        super(cluePool, maxWaiter);
        if (maxClueWaiter < 0 && maxClueWaiter != -1 || maxNoClueWaiter < 0 && maxNoClueWaiter != -1) {
            throw new IllegalArgumentException();
        }
        this.mutex = new Object();
        this.maxClueWaiter = maxClueWaiter;
        this.maxNoClueWaiter = maxNoClueWaiter;
        this.cluePool = cluePool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(IWaitControl timeout) throws PoolException, InterruptedException {
        Object e;
        this.addWaiter();
        this.addNoClueWaiter();
        try {
            e = this.cluePool.get(timeout);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.removeNoClueWaiter();
            this.removeWaiter();
            throw throwable;
        }
        this.removeNoClueWaiter();
        this.removeWaiter();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addClueWaiter() throws TooManyWaiterException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.maxClueWaiter != -1 && this.currentClueWaiter >= this.maxClueWaiter) {
                this.removeWaiter();
                throw new TooManyWaiterException();
            }
            ++this.currentClueWaiter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeClueWaiter() throws TooManyWaiterException {
        Object object = this.mutex;
        synchronized (object) {
            --this.currentClueWaiter;
            if (this.currentClueWaiter == 0) {
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNoClueWaiter() throws TooManyWaiterException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.maxNoClueWaiter != -1 && this.currentNoClueWaiter >= this.maxNoClueWaiter) {
                this.removeWaiter();
                throw new TooManyWaiterException();
            }
            ++this.currentNoClueWaiter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNoClueWaiter() throws TooManyWaiterException {
        Object object = this.mutex;
        synchronized (object) {
            --this.currentNoClueWaiter;
            if (this.currentNoClueWaiter == 0) {
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(C clue, IWaitControl timeout) throws PoolException, InterruptedException {
        E e;
        block7: {
            block6: {
                this.addWaiter();
                if (clue == null) {
                    this.addNoClueWaiter();
                } else {
                    this.addClueWaiter();
                }
                try {
                    e = this.cluePool.get(clue, timeout);
                    Object var5_4 = null;
                    if (clue != null) break block6;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (clue == null) {
                        this.removeNoClueWaiter();
                    } else {
                        this.removeClueWaiter();
                    }
                    this.removeWaiter();
                    throw throwable;
                }
                this.removeNoClueWaiter();
                break block7;
            }
            this.removeClueWaiter();
        }
        this.removeWaiter();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitEmptyClueWaiterInPool() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.currentNoClueWaiter != 0) {
                this.mutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitEmptyNoClueWaiterInPool() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.currentClueWaiter != 0) {
                this.mutex.wait();
            }
        }
    }
}

