/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.listener.statistics.clue;

import java.util.ArrayList;
import java.util.List;
import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.listener.statistics.clue.ICluePoolStatsListener;
import org.ow2.util.pool.impl.enhanced.impl.listener.statistics.BasicPoolStats;
import org.ow2.util.pool.impl.enhanced.impl.listener.statistics.BasicPoolStatsFillerPoolListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicCluePoolStatsFillerPoolListener<E, C>
extends BasicPoolStatsFillerPoolListener<E>
implements ICluePoolStatsListener<E, C, BasicPoolStats> {
    private BasicPoolStats basicPoolStats;
    private boolean countPutAsSentBack;
    private List<String> managedInstances = new ArrayList<String>();

    public BasicCluePoolStatsFillerPoolListener() {
        this(true);
    }

    @Deprecated
    public BasicCluePoolStatsFillerPoolListener(boolean countPutAsSentBack) {
        this.countPutAsSentBack = countPutAsSentBack;
        this.basicPoolStats = this.getBasicPoolStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMethodCalled(C clue, IWaitControl timeout) {
        BasicPoolStats basicPoolStats = this.basicPoolStats;
        synchronized (basicPoolStats) {
            this.basicPoolStats.setWaiters(this.basicPoolStats.getWaiters() + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMethodFailed(PoolException poolException, C clue, IWaitControl timeout) {
        BasicPoolStats basicPoolStats = this.basicPoolStats;
        synchronized (basicPoolStats) {
            this.basicPoolStats.setWaiters(this.basicPoolStats.getWaiters() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMethodReturned(E result, C clue, IWaitControl timeout) {
        BasicPoolStats basicPoolStats = this.basicPoolStats;
        synchronized (basicPoolStats) {
            if (!this.countPutAsSentBack) {
                String hash = String.valueOf(System.identityHashCode(result));
                if (!this.managedInstances.contains(hash)) {
                    this.managedInstances.add(hash);
                    this.basicPoolStats.setNotSendedBack(this.basicPoolStats.getNotSendedBack() + 1);
                }
            } else {
                this.basicPoolStats.setNotSendedBack(this.basicPoolStats.getNotSendedBack() + 1);
            }
            this.basicPoolStats.setWaiters(this.basicPoolStats.getWaiters() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putMethodReturned(E poolItem) {
        BasicPoolStats basicPoolStats = this.basicPoolStats;
        synchronized (basicPoolStats) {
            if (this.countPutAsSentBack) {
                this.basicPoolStats.setNotSendedBack(this.basicPoolStats.getNotSendedBack() - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMethodReturned(E poolItem) {
        BasicPoolStats basicPoolStats = this.basicPoolStats;
        synchronized (basicPoolStats) {
            if (!this.countPutAsSentBack) {
                this.managedInstances.remove(String.valueOf(System.identityHashCode(poolItem)));
            }
            this.basicPoolStats.setNotSendedBack(this.basicPoolStats.getNotSendedBack() - 1);
        }
    }
}

