/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genclientstub.modifier;

import java.io.File;
import java.util.List;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.api.IEJBRefDesc;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.Client;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genclientstub.generator.Generator;
import org.ow2.jonas.generators.genclientstub.generator.GeneratorFactory;
import org.ow2.jonas.generators.genclientstub.modifier.AbsArchiveModifier;

public class ClientModifier
extends AbsArchiveModifier {
    private Client client;

    public ClientModifier(Client client) {
        super((J2EEArchive)client);
        this.client = client;
    }

    @Override
    public Archive modify() throws GenBaseException {
        ClientModifier.getLogger().log(BasicLevel.INFO, (Object)("Processing Client " + this.client.getName()));
        GeneratorFactory gf = GeneratorFactory.getInstance();
        this.generateFoundStubs(gf.getConfiguration(), (Archive)this.client);
        List ejbRefs = this.client.getEjbRefDescs();
        for (IEJBRefDesc ejbRef : ejbRefs) {
            Generator g = new Generator(gf.getConfiguration(), ejbRef, null, (Archive)this.client);
            g.generate();
            g.compile();
            g.addFiles((Archive)this.client);
        }
        return this.save(gf.getConfiguration(), "clients" + File.separator + this.client.getRootFile().getName());
    }
}

