/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.carol;

import java.io.File;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.AbstractJOnASBaseAntTask;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JTask;

public class Carol
extends AbstractJOnASBaseAntTask {
    private static final String INFO = "[Carol] ";
    public static final String SEPARATOR = "=";
    public static final String CAROL_CONF_FILE = "carol.properties";
    private static final String DEFAULT_HOST = "localhost";
    private static final String PROTOCOL_HEADER = "://";
    private static final String DEFAULT_JRMP_PORT = "1099";
    private static final String DEFAULT_IIOP_PORT = "2001";
    private static final String DEFAULT_IRMI_PORT = "1098";
    private static final String PROTOCOLS_PROPERTY = "carol.protocols";
    private static final String JRMP_PROPERTY = "carol.jrmp.url";
    private static final String IIOP_PROPERTY = "carol.iiop.url";
    private static final String IRMI_PROPERTY = "carol.irmi.url";
    private static final String OPTIMIZATION_PROPERTY = "carol.jvm.rmi.local.call";
    private static final String LOCALREGISTRY_PROPERTY = "carol.jvm.rmi.local.registry";
    public static final String START_CMI_PROPERTY = "carol.start.cmi";
    public static final String SEQ_PROTOCOLS_TO_PROVIDER_URLS = "cmi.server.provider.urls";
    private String serverproviderurls = null;
    private String jrmpconnectionurl = "rmi://localhost:1099";
    private String iiopconnectionurl = "iiop://localhost:2001";
    private String irmiconnectionurl = "rmi://localhost:1098";
    private Boolean startcmi = false;
    private Boolean rmilocalcall = false;
    private Boolean rmilocalregistry = true;
    private String carolprotocols = null;
    private String host = "localhost";

    public void setJrmpPort(String portNumber) {
        this.jrmpconnectionurl = "rmi://" + this.host + ":" + portNumber;
    }

    public void setIiopPort(String portNumber) {
        this.iiopconnectionurl = "iiop://" + this.host + ":" + portNumber;
    }

    public void setIrmiPort(String portNumber) {
        this.irmiconnectionurl = "rmi://" + this.host + ":" + portNumber;
    }

    public void setDefaultPort(String portNumber) {
        this.setJrmpPort(portNumber);
        this.setIiopPort(portNumber);
        this.setIrmiPort(portNumber);
    }

    public void setProtocols(String protocols) {
        this.carolprotocols = protocols;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setJrmpOptimization(boolean enabled) {
        this.rmilocalcall = enabled;
    }

    public void setLocalRegistry(boolean enabled) {
        this.rmilocalregistry = enabled;
    }

    public void setCmiStarted(boolean enabled) {
        this.startcmi = enabled;
    }

    public void setClusterViewProviderUrls(String seqProtocol2ProviderURLs) {
        this.serverproviderurls = seqProtocol2ProviderURLs;
    }

    @Override
    public void execute() {
        super.execute();
        String jBaseConf = this.destDir.getPath() + File.separator + "conf";
        JTask jtask = new JTask();
        jtask.setDestDir(this.destDir);
        jtask.changeValueForKey(INFO, jBaseConf, CAROL_CONF_FILE, PROTOCOLS_PROPERTY, this.carolprotocols, SEPARATOR, false);
        jtask.changeValueForKey(INFO, jBaseConf, CAROL_CONF_FILE, OPTIMIZATION_PROPERTY, this.rmilocalcall.toString(), SEPARATOR, false);
        jtask.changeValueForKey(INFO, jBaseConf, CAROL_CONF_FILE, LOCALREGISTRY_PROPERTY, this.rmilocalregistry.toString(), SEPARATOR, false);
        jtask.changeValueForKey(INFO, jBaseConf, CAROL_CONF_FILE, START_CMI_PROPERTY, this.startcmi.toString(), SEPARATOR, false);
        jtask.changeValueForKey(INFO, jBaseConf, CAROL_CONF_FILE, JRMP_PROPERTY, this.jrmpconnectionurl, SEPARATOR, false);
        jtask.changeValueForKey(INFO, jBaseConf, CAROL_CONF_FILE, IIOP_PROPERTY, this.iiopconnectionurl, SEPARATOR, false);
        jtask.changeValueForKey(INFO, jBaseConf, CAROL_CONF_FILE, IRMI_PROPERTY, this.irmiconnectionurl, SEPARATOR, false);
        this.tasks.add(jtask);
        this.executeAllTask();
    }
}

