/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.datasource.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jonas.Version;
import org.ow2.jonas.datasource.DataSourceService;
import org.ow2.jonas.datasource.internal.DSDefinitionExtensionListener;
import org.ow2.jonas.generators.raconfig.RAConfig;
import org.ow2.jonas.generators.raconfig.RAConfigException;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.loader.OSGiClassLoader;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.ee.deploy.api.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.api.IEventService;
import org.ow2.util.execution.ExecutionResult;
import org.ow2.util.execution.IExecution;
import org.ow2.util.execution.helper.RunnableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentPlanFragment;
import org.ow2.util.plan.bindings.deploymentplan.maven2.Maven2Deployment;
import org.ow2.util.plan.bindings.exceptions.InvalidDeploymentException;
import org.ow2.util.plan.fetcher.api.IResourceFetcher;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactoryManager;
import org.ow2.util.plan.fetcher.api.exceptions.FetcherException;
import org.ow2.util.plan.fetcher.api.exceptions.FetcherFactoryException;
import org.ow2.util.plan.fetcher.api.exceptions.ResourceFetcherNotResolvedException;
import org.ow2.util.plan.fetcher.api.exceptions.ResourceNotFoundException;
import org.ow2.util.plan.repository.api.IRepositoryManager;

@Component(immediate=false, architecture=true, propagation=true)
@Provides(specifications={DataSourceService.class})
public class DataSourceServiceImpl
extends AbsServiceImpl
implements DataSourceService,
Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private boolean __FresourceFetcherFactoryManager;
    @Requires
    protected IResourceFetcherFactoryManager resourceFetcherFactoryManager;
    private static final String DEFAULT_ARCHIVE_PATH = "datasources-service" + File.separator + "datasources";
    private boolean __FrepositoryManager;
    @Requires
    protected IRepositoryManager repositoryManager;
    private boolean __FdeployerManager;
    @Requires
    private IDeployerManager deployerManager;
    private boolean __FregistryService;
    @Requires
    private RegistryService registryService;
    private boolean __FinitialContext;
    private InitialContext initialContext;
    private boolean __FarchiveFile;
    protected File archiveFile;
    private boolean __FeventService;
    @Requires
    private IEventService eventService;
    private boolean __FeventListener;
    private IEventListener eventListener;
    private boolean __FdeployedDSJNDINames;
    private List<String> deployedDSJNDINames;
    private boolean __FjmxService;
    @Requires
    private JmxService jmxService;
    private boolean __FserverrarProperties;
    @Requires
    protected ServerProperties serverrarProperties;
    private boolean __FjdbcDMRarPath;
    private String jdbcDMRarPath;
    private boolean __FjdbcDSRarPath;
    private String jdbcDSRarPath;
    private boolean __FjdbcXARarPath;
    private String jdbcXARarPath;
    private boolean __MresolvePath$org_ow2_util_plan_bindings_deploymentplan_maven2_Maven2Deployment;
    private boolean __MresolveJDBCRars;
    private boolean __MdeployDataSource$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$int$java_lang_String$int$boolean$int$int$int$int$int$int$java_util_Map;
    private boolean __MgenerateDataSourceName$java_util_Properties;
    private boolean __MgenerateRarProperties$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$int$java_lang_String$int$boolean$int$int$int$int$int$int$java_util_Map;
    private boolean __MdoStart;
    private boolean __MdoStop;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MsetServerProperties$org_ow2_jonas_properties_ServerProperties;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    IResourceFetcherFactoryManager __getresourceFetcherFactoryManager() {
        if (!this.__FresourceFetcherFactoryManager) {
            return this.resourceFetcherFactoryManager;
        }
        return (IResourceFetcherFactoryManager)this.__IM.onGet((Object)this, "resourceFetcherFactoryManager");
    }

    void __setresourceFetcherFactoryManager(IResourceFetcherFactoryManager iResourceFetcherFactoryManager) {
        if (!this.__FresourceFetcherFactoryManager) {
            this.resourceFetcherFactoryManager = iResourceFetcherFactoryManager;
            return;
        }
        this.__IM.onSet((Object)this, "resourceFetcherFactoryManager", (Object)iResourceFetcherFactoryManager);
    }

    IRepositoryManager __getrepositoryManager() {
        if (!this.__FrepositoryManager) {
            return this.repositoryManager;
        }
        return (IRepositoryManager)this.__IM.onGet((Object)this, "repositoryManager");
    }

    void __setrepositoryManager(IRepositoryManager iRepositoryManager) {
        if (!this.__FrepositoryManager) {
            this.repositoryManager = iRepositoryManager;
            return;
        }
        this.__IM.onSet((Object)this, "repositoryManager", (Object)iRepositoryManager);
    }

    IDeployerManager __getdeployerManager() {
        if (!this.__FdeployerManager) {
            return this.deployerManager;
        }
        return (IDeployerManager)this.__IM.onGet((Object)this, "deployerManager");
    }

    void __setdeployerManager(IDeployerManager iDeployerManager) {
        if (!this.__FdeployerManager) {
            this.deployerManager = iDeployerManager;
            return;
        }
        this.__IM.onSet((Object)this, "deployerManager", (Object)iDeployerManager);
    }

    RegistryService __getregistryService() {
        if (!this.__FregistryService) {
            return this.registryService;
        }
        return (RegistryService)this.__IM.onGet((Object)this, "registryService");
    }

    void __setregistryService(RegistryService registryService) {
        if (!this.__FregistryService) {
            this.registryService = registryService;
            return;
        }
        this.__IM.onSet((Object)this, "registryService", (Object)registryService);
    }

    InitialContext __getinitialContext() {
        if (!this.__FinitialContext) {
            return this.initialContext;
        }
        return (InitialContext)this.__IM.onGet((Object)this, "initialContext");
    }

    void __setinitialContext(InitialContext initialContext) {
        if (!this.__FinitialContext) {
            this.initialContext = initialContext;
            return;
        }
        this.__IM.onSet((Object)this, "initialContext", (Object)initialContext);
    }

    File __getarchiveFile() {
        if (!this.__FarchiveFile) {
            return this.archiveFile;
        }
        return (File)this.__IM.onGet((Object)this, "archiveFile");
    }

    void __setarchiveFile(File file) {
        if (!this.__FarchiveFile) {
            this.archiveFile = file;
            return;
        }
        this.__IM.onSet((Object)this, "archiveFile", (Object)file);
    }

    IEventService __geteventService() {
        if (!this.__FeventService) {
            return this.eventService;
        }
        return (IEventService)this.__IM.onGet((Object)this, "eventService");
    }

    void __seteventService(IEventService iEventService) {
        if (!this.__FeventService) {
            this.eventService = iEventService;
            return;
        }
        this.__IM.onSet((Object)this, "eventService", (Object)iEventService);
    }

    IEventListener __geteventListener() {
        if (!this.__FeventListener) {
            return this.eventListener;
        }
        return (IEventListener)this.__IM.onGet((Object)this, "eventListener");
    }

    void __seteventListener(IEventListener iEventListener) {
        if (!this.__FeventListener) {
            this.eventListener = iEventListener;
            return;
        }
        this.__IM.onSet((Object)this, "eventListener", (Object)iEventListener);
    }

    List __getdeployedDSJNDINames() {
        if (!this.__FdeployedDSJNDINames) {
            return this.deployedDSJNDINames;
        }
        return (List)this.__IM.onGet((Object)this, "deployedDSJNDINames");
    }

    void __setdeployedDSJNDINames(List list) {
        if (!this.__FdeployedDSJNDINames) {
            this.deployedDSJNDINames = list;
            return;
        }
        this.__IM.onSet((Object)this, "deployedDSJNDINames", (Object)list);
    }

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    ServerProperties __getserverrarProperties() {
        if (!this.__FserverrarProperties) {
            return this.serverrarProperties;
        }
        return (ServerProperties)this.__IM.onGet((Object)this, "serverrarProperties");
    }

    void __setserverrarProperties(ServerProperties serverProperties) {
        if (!this.__FserverrarProperties) {
            this.serverrarProperties = serverProperties;
            return;
        }
        this.__IM.onSet((Object)this, "serverrarProperties", (Object)serverProperties);
    }

    String __getjdbcDMRarPath() {
        if (!this.__FjdbcDMRarPath) {
            return this.jdbcDMRarPath;
        }
        return (String)this.__IM.onGet((Object)this, "jdbcDMRarPath");
    }

    void __setjdbcDMRarPath(String string) {
        if (!this.__FjdbcDMRarPath) {
            this.jdbcDMRarPath = string;
            return;
        }
        this.__IM.onSet((Object)this, "jdbcDMRarPath", (Object)string);
    }

    String __getjdbcDSRarPath() {
        if (!this.__FjdbcDSRarPath) {
            return this.jdbcDSRarPath;
        }
        return (String)this.__IM.onGet((Object)this, "jdbcDSRarPath");
    }

    void __setjdbcDSRarPath(String string) {
        if (!this.__FjdbcDSRarPath) {
            this.jdbcDSRarPath = string;
            return;
        }
        this.__IM.onSet((Object)this, "jdbcDSRarPath", (Object)string);
    }

    String __getjdbcXARarPath() {
        if (!this.__FjdbcXARarPath) {
            return this.jdbcXARarPath;
        }
        return (String)this.__IM.onGet((Object)this, "jdbcXARarPath");
    }

    void __setjdbcXARarPath(String string) {
        if (!this.__FjdbcXARarPath) {
            this.jdbcXARarPath = string;
            return;
        }
        this.__IM.onSet((Object)this, "jdbcXARarPath", (Object)string);
    }

    public DataSourceServiceImpl() {
        this(null);
    }

    private DataSourceServiceImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(DataSourceServiceImpl.class));
        this.__setdeployerManager(null);
        this.__setarchiveFile(null);
        this.__seteventService(null);
        this.__seteventListener(null);
        this.__setdeployedDSJNDINames(new ArrayList());
        this.__setjdbcDMRarPath(null);
        this.__setjdbcDSRarPath(null);
        this.__setjdbcXARarPath(null);
    }

    private String resolvePath(Maven2Deployment deployment) {
        String string;
        if (!this.__MresolvePath$org_ow2_util_plan_bindings_deploymentplan_maven2_Maven2Deployment) {
            return this.__M_resolvePath(deployment);
        }
        try {
            this.__IM.onEntry((Object)this, "resolvePath$org_ow2_util_plan_bindings_deploymentplan_maven2_Maven2Deployment", new Object[]{deployment});
            string = this.__M_resolvePath(deployment);
            this.__IM.onExit((Object)this, "resolvePath$org_ow2_util_plan_bindings_deploymentplan_maven2_Maven2Deployment", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "resolvePath$org_ow2_util_plan_bindings_deploymentplan_maven2_Maven2Deployment", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_resolvePath(Maven2Deployment deployment) {
        try {
            IResourceFetcher fetcher = this.__getresourceFetcherFactoryManager().getResourceFetcher((DeploymentPlanFragment)deployment);
            fetcher.setRepositoryManager(this.__getrepositoryManager());
            fetcher.setDeployment((DeploymentPlanFragment)deployment);
            fetcher.resolve();
            return fetcher.getResource().getPath();
        }
        catch (FetcherException e) {
            e.printStackTrace();
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvalidDeploymentException e) {
            e.printStackTrace();
        }
        catch (FetcherFactoryException e) {
            e.printStackTrace();
        }
        catch (ResourceFetcherNotResolvedException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void resolveJDBCRars() {
        if (!this.__MresolveJDBCRars) {
            this.__M_resolveJDBCRars();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "resolveJDBCRars", new Object[0]);
            this.__M_resolveJDBCRars();
            this.__IM.onExit((Object)this, "resolveJDBCRars", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "resolveJDBCRars", throwable);
            throw throwable;
        }
    }

    private void __M_resolveJDBCRars() {
        Maven2Deployment deployment;
        if (this.__getjdbcDMRarPath() == null) {
            deployment = new Maven2Deployment();
            deployment.setGroupId("org.ow2.jonas");
            deployment.setArtifactId("jonas-jca-jdbc-dm");
            deployment.setVersion(Version.getNumber());
            deployment.setType("rar");
            this.__setjdbcDMRarPath(this.resolvePath(deployment));
        }
        if (this.__getjdbcDSRarPath() == null) {
            deployment = new Maven2Deployment();
            deployment.setGroupId("org.ow2.jonas");
            deployment.setArtifactId("jonas-jca-jdbc-ds");
            deployment.setVersion(Version.getNumber());
            deployment.setType("rar");
            this.__setjdbcDSRarPath(this.resolvePath(deployment));
        }
        if (this.__getjdbcXARarPath() == null) {
            deployment = new Maven2Deployment();
            deployment.setGroupId("org.ow2.jonas");
            deployment.setArtifactId("jonas-jca-jdbc-xa");
            deployment.setVersion(Version.getNumber());
            deployment.setType("rar");
            this.__setjdbcXARarPath(this.resolvePath(deployment));
        }
    }

    @Override
    public String deployDataSource(String className, String description, String url, String user, String password, String databaseName, int portNumber, String serverName, int isolationLevel, boolean transactional, int initialPoolSize, int maxPoolSize, int minPoolSize, int maxIdleTime, int maxStatements, int loginTimeout, Map<String, String> properties) {
        String string;
        if (!this.__MdeployDataSource$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$int$java_lang_String$int$boolean$int$int$int$int$int$int$java_util_Map) {
            return this.__M_deployDataSource(className, description, url, user, password, databaseName, portNumber, serverName, isolationLevel, transactional, initialPoolSize, maxPoolSize, minPoolSize, maxIdleTime, maxStatements, loginTimeout, properties);
        }
        try {
            this.__IM.onEntry((Object)this, "deployDataSource$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$int$java_lang_String$int$boolean$int$int$int$int$int$int$java_util_Map", new Object[]{className, description, url, user, password, databaseName, new Integer(portNumber), serverName, new Integer(isolationLevel), new Boolean(transactional), new Integer(initialPoolSize), new Integer(maxPoolSize), new Integer(minPoolSize), new Integer(maxIdleTime), new Integer(maxStatements), new Integer(loginTimeout), properties});
            string = this.__M_deployDataSource(className, description, url, user, password, databaseName, portNumber, serverName, isolationLevel, transactional, initialPoolSize, maxPoolSize, minPoolSize, maxIdleTime, maxStatements, loginTimeout, properties);
            this.__IM.onExit((Object)this, "deployDataSource$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$int$java_lang_String$int$boolean$int$int$int$int$int$int$java_util_Map", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deployDataSource$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$int$java_lang_String$int$boolean$int$int$int$int$int$int$java_util_Map", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_deployDataSource(final String className, String description, String url, String user, String password, String databaseName, int portNumber, String serverName, int isolationLevel, boolean transactional, int initialPoolSize, int maxPoolSize, int minPoolSize, int maxIdleTime, int maxStatements, int loginTimeout, Map<String, String> properties) {
        Properties rarProperties = this.generateRarProperties(className, description, url, user, password, databaseName, portNumber, serverName, isolationLevel, transactional, initialPoolSize, maxPoolSize, minPoolSize, maxIdleTime, maxStatements, loginTimeout, properties);
        String jndiDataSourceName = this.generateDataSourceName(rarProperties);
        try {
            if (this.__getinitialContext().lookup(jndiDataSourceName) != null) {
                return jndiDataSourceName;
            }
        }
        catch (NamingException e) {
            this.__getlogger().debug("Unable to lookup {0} into initial context trying to deploy a RAR for this datasource", jndiDataSourceName);
        }
        rarProperties.setProperty("datasource.name", jndiDataSourceName);
        String fileOut = null;
        String fileName = "";
        try {
            fileName = "ds-" + jndiDataSourceName.replace('/', '_') + "-";
            fileName = fileName.replace(":", "-");
            fileOut = File.createTempFile(fileName, ".rar", this.__getarchiveFile()).getAbsolutePath();
        }
        catch (IOException e1) {
            String msg = "Error while creating temp file <" + fileName + ".rar> in directory <" + this.__getarchiveFile().getPath() + ">";
            throw new ServiceException(msg, (Throwable)e1);
        }
        this.resolveJDBCRars();
        try {
            String fileIn = this.__getjdbcDMRarPath();
            String rarLinkExtension = "DM";
            IExecution loadClassExecution = new IExecution<Class<?>>(){

                public Class<?> execute() throws Exception {
                    OSGiClassLoader osgiClassLoader = new OSGiClassLoader();
                    return osgiClassLoader.loadClass(className);
                }
            };
            ExecutionResult executionResult = new RunnableHelper().execute(OSGiClassLoader.class.getClassLoader(), loadClassExecution);
            if (executionResult.hasException()) {
                this.__getlogger().fatal("Can't load JDBC driver", executionResult.getException());
                throw new ServiceException("Can't load JDBC driver", (Throwable)executionResult.getException());
            }
            Class clazz = (Class)executionResult.getResult();
            if (DataSource.class.isAssignableFrom(clazz)) {
                fileIn = this.__getjdbcDSRarPath();
                rarLinkExtension = "DS";
            } else if (XADataSource.class.isAssignableFrom(clazz)) {
                fileIn = this.__getjdbcXARarPath();
                rarLinkExtension = "XA";
            } else if (ConnectionPoolDataSource.class.isAssignableFrom(clazz)) {
                fileIn = this.__getjdbcXARarPath();
                rarLinkExtension = "XA";
            }
            this.__getlogger().info("Generate RAR {0} -> {1}", fileIn, fileOut);
            RAConfig.generateRars((Properties)rarProperties, (String)("JOnASJDBC_" + rarLinkExtension), (String)fileIn, (String)fileOut);
        }
        catch (RAConfigException e) {
            this.__getlogger().error("Failure to deploy datasource {0}", jndiDataSourceName);
            throw new ServiceException("Failure to deploy datasource " + jndiDataSourceName, (Throwable)e);
        }
        File generatedFile = new File(fileOut);
        if (!generatedFile.exists()) {
            this.__getlogger().error("RAR was not generated with RAConfig- {0}", fileOut);
            throw new ServiceException("RAR was not generated with RAConfig- {0} " + fileOut);
        }
        IArchive archiveRar = ArchiveManager.getInstance().getArchive((Object)generatedFile);
        if (archiveRar == null) {
            throw new ServiceException("Null archive for file " + fileOut);
        }
        IDeployable rarDeployable = null;
        try {
            rarDeployable = DeployableHelper.getDeployable((IArchive)archiveRar);
        }
        catch (DeployableHelperException e) {
            throw new ServiceException("Unable to deploy generated RAR ", (Throwable)e);
        }
        if (rarDeployable == null) {
            throw new ServiceException("Null deployable for archive " + archiveRar);
        }
        try {
            this.__getdeployerManager().deploy(rarDeployable);
        }
        catch (DeployerException e) {
            throw new ServiceException("Exception while deploying deployable " + rarDeployable, (Throwable)e);
        }
        catch (UnsupportedDeployerException e) {
            throw new ServiceException("No deployer found for deployable " + rarDeployable, (Throwable)e);
        }
        this.__getdeployedDSJNDINames().add(jndiDataSourceName);
        return jndiDataSourceName;
    }

    private String generateDataSourceName(Properties rarProperties) {
        String string;
        if (!this.__MgenerateDataSourceName$java_util_Properties) {
            return this.__M_generateDataSourceName(rarProperties);
        }
        try {
            this.__IM.onEntry((Object)this, "generateDataSourceName$java_util_Properties", new Object[]{rarProperties});
            string = this.__M_generateDataSourceName(rarProperties);
            this.__IM.onExit((Object)this, "generateDataSourceName$java_util_Properties", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateDataSourceName$java_util_Properties", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_generateDataSourceName(Properties rarProperties) {
        StringBuilder sb = new StringBuilder("DS_");
        sb.append(rarProperties.getProperty("datasource.classname", ""));
        sb.append(rarProperties.getProperty("datasource.databaseName", ""));
        sb.append(rarProperties.getProperty("datasource.serverName", ""));
        sb.append(rarProperties.getProperty("datasource.portNumber", ""));
        sb.append(rarProperties.getProperty("datasource.username", ""));
        sb.append(rarProperties.getProperty("datasource.password", ""));
        sb.append(rarProperties.getProperty("datasource.isolationlevel", ""));
        sb.append(rarProperties.getProperty("jdbc.initconpool", ""));
        sb.append(rarProperties.getProperty("jdbc.minconpool", ""));
        sb.append(rarProperties.getProperty("jdbc.maxconpool", ""));
        sb.append(rarProperties.getProperty("jdbc.pstmtmax", ""));
        sb.append(rarProperties.getProperty("jdbc.maxopentime", ""));
        sb.append(rarProperties.getProperty("datasource.loginTimeout", ""));
        return sb.toString();
    }

    private Properties generateRarProperties(String className, String description, String url, String user, String password, String databaseName, int portNumber, String serverName, int isolationLevel, boolean transactional, int initialPoolSize, int maxPoolSize, int minPoolSize, int maxIdleTime, int maxStatements, int loginTimeout, Map<String, String> properties) {
        Properties properties2;
        if (!this.__MgenerateRarProperties$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$int$java_lang_String$int$boolean$int$int$int$int$int$int$java_util_Map) {
            return this.__M_generateRarProperties(className, description, url, user, password, databaseName, portNumber, serverName, isolationLevel, transactional, initialPoolSize, maxPoolSize, minPoolSize, maxIdleTime, maxStatements, loginTimeout, properties);
        }
        try {
            this.__IM.onEntry((Object)this, "generateRarProperties$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$int$java_lang_String$int$boolean$int$int$int$int$int$int$java_util_Map", new Object[]{className, description, url, user, password, databaseName, new Integer(portNumber), serverName, new Integer(isolationLevel), new Boolean(transactional), new Integer(initialPoolSize), new Integer(maxPoolSize), new Integer(minPoolSize), new Integer(maxIdleTime), new Integer(maxStatements), new Integer(loginTimeout), properties});
            properties2 = this.__M_generateRarProperties(className, description, url, user, password, databaseName, portNumber, serverName, isolationLevel, transactional, initialPoolSize, maxPoolSize, minPoolSize, maxIdleTime, maxStatements, loginTimeout, properties);
            this.__IM.onExit((Object)this, "generateRarProperties$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$int$java_lang_String$int$boolean$int$int$int$int$int$int$java_util_Map", (Object)properties2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateRarProperties$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$int$java_lang_String$int$boolean$int$int$int$int$int$int$java_util_Map", throwable);
            throw throwable;
        }
        return properties2;
    }

    private Properties __M_generateRarProperties(String className, String description, String url, String user, String password, String databaseName, int portNumber, String serverName, int isolationLevel, boolean transactional, int initialPoolSize, int maxPoolSize, int minPoolSize, int maxIdleTime, int maxStatements, int loginTimeout, Map<String, String> properties) {
        Properties rarProperties = new Properties();
        if (url != null && !url.equals("")) {
            rarProperties.setProperty("datasource.url", url);
            Matcher matcher = Pattern.compile(".+://([^/]+)/(.+)$").matcher(url);
            if (matcher.matches() && matcher.groupCount() == 2) {
                int colonIndex;
                String dbConnection = matcher.group(1);
                rarProperties.setProperty("datasource.databaseName", matcher.group(2));
                int atIndex = dbConnection.indexOf("@");
                if (atIndex != -1) {
                    dbConnection = dbConnection.substring(atIndex + 1);
                    if (atIndex > 0) {
                        String userAndPass = dbConnection.substring(0, atIndex - 1);
                        int colonIndex2 = userAndPass.indexOf(":");
                        if (colonIndex2 != -1) {
                            rarProperties.setProperty("datasource.password", userAndPass.substring(colonIndex2 + 1));
                            if (colonIndex2 > 0) {
                                userAndPass = userAndPass.substring(0, colonIndex2 - 1);
                            }
                        }
                        rarProperties.setProperty("datasource.username", userAndPass);
                    }
                }
                if ((colonIndex = dbConnection.indexOf(":")) != -1) {
                    rarProperties.setProperty("datasource.portNumber", dbConnection.substring(colonIndex + 1));
                    if (colonIndex > 0) {
                        dbConnection = dbConnection.substring(0, colonIndex - 1);
                    }
                }
                rarProperties.setProperty("datasource.serverName", dbConnection);
            }
        }
        if (user != null && !user.equals("")) {
            rarProperties.setProperty("datasource.username", user);
        }
        if (password != null && !password.equals("")) {
            rarProperties.setProperty("datasource.password", password);
        }
        if (databaseName != null && !databaseName.equals("")) {
            rarProperties.setProperty("datasource.databaseName", databaseName);
        }
        if (portNumber != -1) {
            rarProperties.setProperty("datasource.portNumber", String.valueOf(portNumber));
        }
        if (serverName != null && !serverName.equals("")) {
            rarProperties.setProperty("datasource.serverName", serverName);
        }
        rarProperties.setProperty("datasource.classname", className);
        if (description != null) {
            rarProperties.setProperty("datasource.description", description);
        }
        if (isolationLevel == 2) {
            rarProperties.setProperty("datasource.isolationlevel", "read_committed");
        } else if (isolationLevel == 1) {
            rarProperties.setProperty("datasource.isolationlevel", "read_uncommitted");
        } else if (isolationLevel == 8) {
            rarProperties.setProperty("datasource.isolationlevel", "serializable");
        } else if (isolationLevel == 4) {
            rarProperties.setProperty("datasource.isolationlevel", "repeatable_read");
        } else {
            rarProperties.setProperty("datasource.isolationlevel", "none");
        }
        rarProperties.setProperty("jdbc.initconpool", String.valueOf(initialPoolSize));
        rarProperties.setProperty("jdbc.minconpool", String.valueOf(minPoolSize));
        rarProperties.setProperty("jdbc.maxconpool", String.valueOf(maxPoolSize));
        rarProperties.setProperty("jdbc.pstmtmax", String.valueOf(maxStatements));
        rarProperties.setProperty("jdbc.maxopentime", String.valueOf(maxIdleTime));
        rarProperties.setProperty("datasource.loginTimeout", String.valueOf(loginTimeout));
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                rarProperties.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return rarProperties;
    }

    protected void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__M_doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__M_doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __M_doStart() throws ServiceException {
        this.__getlogger().debug("DataSource Service starting", new Object[0]);
        this.__getjmxService().loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        try {
            this.__getjmxService().registerModelMBean((Object)this, JonasObjectName.dataSourceService(this.getDomainName()));
        }
        catch (Exception e) {
            this.__getlogger().warn("Cannot register MBean for DataSource service", e);
        }
        if (this.__getarchiveFile() == null) {
            this.__setarchiveFile(new File(this.__getserverrarProperties().getWorkDirectory() + File.separator + DEFAULT_ARCHIVE_PATH + File.separator + this.__getserverrarProperties().getServerName()));
            this.__getarchiveFile().mkdirs();
        }
        IExecution<InitialContext> ictxGetter = new IExecution<InitialContext>(){

            public InitialContext execute() throws Exception {
                return DataSourceServiceImpl.this.__getregistryService().getRegistryContext();
            }
        };
        ExecutionResult ictxResult = new RunnableHelper().execute(this.getClass().getClassLoader(), (IExecution)ictxGetter);
        if (ictxResult.hasException()) {
            this.__getlogger().error("Cannot create initial context when Resource service initializing", new Object[0]);
            throw new ServiceException("Cannot create initial context when Resource service initializing", (Throwable)ictxResult.getException());
        }
        this.__setinitialContext((InitialContext)ictxResult.getResult());
        if (this.__geteventService() != null) {
            this.__seteventListener(new DSDefinitionExtensionListener(this));
            this.__geteventService().registerListener(this.__geteventListener(), "/easybeans/container/factory/context");
        }
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__M_doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__M_doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __M_doStop() throws ServiceException {
        try {
            this.__getjmxService().unregisterModelMBean(JonasObjectName.dataSourceService(this.getDomainName()));
        }
        catch (Exception e) {
            this.__getlogger().debug("Cannot unregister MBean for DataSource service", e);
        }
        if (this.__geteventService() != null && this.__geteventListener() != null) {
            this.__geteventService().unregisterListener(this.__geteventListener());
        }
        for (String deployedDSJNDIName : this.__getdeployedDSJNDINames()) {
            try {
                this.__getinitialContext().unbind(deployedDSJNDIName);
            }
            catch (NamingException e) {
                this.__getlogger().error("Unable to unbind data source " + deployedDSJNDIName + " from JNDI global context", e);
            }
        }
        this.__getdeployedDSJNDINames().clear();
    }

    public void start() throws ServiceException {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() throws ServiceException {
        super.start();
        this.__getlogger().debug("DataSource Service started", new Object[0]);
    }

    public void stop() throws ServiceException {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() throws ServiceException {
        super.stop();
        this.__getlogger().debug("DataSource Service stopped", new Object[0]);
    }

    public void setServerProperties(ServerProperties props) {
        if (!this.__MsetServerProperties$org_ow2_jonas_properties_ServerProperties) {
            this.__M_setServerProperties(props);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", new Object[]{props});
            this.__M_setServerProperties(props);
            this.__IM.onExit((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", throwable);
            throw throwable;
        }
    }

    @Bind(id="ServerProps", optional=false, specification="org.ow2.jonas.properties.ServerProperties")
    private void __M_setServerProperties(ServerProperties props) {
        super.setServerProperties(props);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("archiveFile")) {
                this.__FarchiveFile = true;
            }
            if (set.contains("deployedDSJNDINames")) {
                this.__FdeployedDSJNDINames = true;
            }
            if (set.contains("deployerManager")) {
                this.__FdeployerManager = true;
            }
            if (set.contains("eventListener")) {
                this.__FeventListener = true;
            }
            if (set.contains("eventService")) {
                this.__FeventService = true;
            }
            if (set.contains("initialContext")) {
                this.__FinitialContext = true;
            }
            if (set.contains("jdbcDMRarPath")) {
                this.__FjdbcDMRarPath = true;
            }
            if (set.contains("jdbcDSRarPath")) {
                this.__FjdbcDSRarPath = true;
            }
            if (set.contains("jdbcXARarPath")) {
                this.__FjdbcXARarPath = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("registryService")) {
                this.__FregistryService = true;
            }
            if (set.contains("repositoryManager")) {
                this.__FrepositoryManager = true;
            }
            if (set.contains("resourceFetcherFactoryManager")) {
                this.__FresourceFetcherFactoryManager = true;
            }
            if (set.contains("serverrarProperties")) {
                this.__FserverrarProperties = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("resolvePath$org_ow2_util_plan_bindings_deploymentplan_maven2_Maven2Deployment")) {
                this.__MresolvePath$org_ow2_util_plan_bindings_deploymentplan_maven2_Maven2Deployment = true;
            }
            if (set.contains("resolveJDBCRars")) {
                this.__MresolveJDBCRars = true;
            }
            if (set.contains("deployDataSource$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$int$java_lang_String$int$boolean$int$int$int$int$int$int$java_util_Map")) {
                this.__MdeployDataSource$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$int$java_lang_String$int$boolean$int$int$int$int$int$int$java_util_Map = true;
            }
            if (set.contains("generateDataSourceName$java_util_Properties")) {
                this.__MgenerateDataSourceName$java_util_Properties = true;
            }
            if (set.contains("generateRarProperties$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$int$java_lang_String$int$boolean$int$int$int$int$int$int$java_util_Map")) {
                this.__MgenerateRarProperties$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$int$java_lang_String$int$boolean$int$int$int$int$int$int$java_util_Map = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("setServerProperties$org_ow2_jonas_properties_ServerProperties")) {
                this.__MsetServerProperties$org_ow2_jonas_properties_ServerProperties = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

