/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.lang.reflect.Method;
import java.util.Iterator;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.MethodDesc;
import org.ow2.jonas.deployment.ejb.xml.AssemblyDescriptor;
import org.ow2.jonas.deployment.ejb.xml.CommonEjb;
import org.ow2.jonas.deployment.ejb.xml.Entity;
import org.ow2.jonas.deployment.ejb.xml.JonasCommonEjb;
import org.ow2.jonas.deployment.ejb.xml.JonasEntity;
import org.ow2.jonas.lib.util.BeanNaming;

public abstract class EntityDesc
extends BeanDesc {
    protected static final String METHODS_REMOTE_NO_TX = ",getEJBHome,getHandle,getPrimaryKey,isIdentical,";
    protected static final String METHODS_HOME_NO_TX = ",getEJBMetaData,getHomeHandle,";
    protected Class primaryKeyClass;
    protected boolean reentrant;
    protected int passivationTimeout = 0;
    protected int inactivityTimeout = 0;
    protected int deadlockTimeout = 20;
    protected int readTimeout = 900;
    protected int maxWaitTime = 0;
    protected boolean shared = false;
    protected boolean prefetch = false;
    protected boolean hardLimit = false;
    protected boolean jdbcAutomaticPk = false;
    protected boolean pkObjectType = false;
    public static final int CLEANUP_NONE = 0;
    public static final int CLEANUP_CREATE = 1;
    public static final int CLEANUP_REMOVEDATA = 2;
    public static final int CLEANUP_REMOVEALL = 3;
    protected int cleanup = 1;
    public static final int LOCK_CONTAINER_READ_UNCOMMITTED = 0;
    public static final int LOCK_CONTAINER_SERIALIZED = 1;
    public static final int LOCK_CONTAINER_READ_COMMITTED = 2;
    public static final int LOCK_DATABASE = 3;
    public static final int LOCK_READ_ONLY = 4;
    public static final int LOCK_CONTAINER_READ_WRITE = 5;
    public static final int LOCK_CONTAINER_SERIALIZED_TRANSACTED = 6;
    protected int lockPolicy = 1;

    public EntityDesc(ClassLoader classLoader, Entity ent, AssemblyDescriptor asd, JonasEntity jEnt, JLinkedList jMDRList, String fileName) throws DeploymentDescException {
        super(classLoader, (CommonEjb)ent, (JonasCommonEjb)jEnt, asd, jMDRList, fileName);
        Integer tval;
        String tstr;
        try {
            if (ent.getPrimKeyClass().equalsIgnoreCase("Object") || ent.getPrimKeyClass().equalsIgnoreCase("java.lang.Object")) {
                this.primaryKeyClass = classLoader.loadClass("java.lang.Integer");
                this.pkObjectType = true;
            } else {
                this.primaryKeyClass = classLoader.loadClass(ent.getPrimKeyClass());
            }
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentDescException("Primary Key class not found for bean " + this.ejbName, (Throwable)e);
        }
        if (jEnt.getPassivationTimeout() != null) {
            tstr = jEnt.getPassivationTimeout();
            tval = new Integer(tstr);
            this.passivationTimeout = tval;
        }
        if (jEnt.getInactivityTimeout() != null) {
            tstr = jEnt.getInactivityTimeout();
            tval = new Integer(tstr);
            this.inactivityTimeout = tval;
        }
        if (jEnt.getDeadlockTimeout() != null) {
            tstr = jEnt.getDeadlockTimeout();
            tval = new Integer(tstr);
            this.deadlockTimeout = tval;
        }
        if (jEnt.getReadTimeout() != null) {
            tstr = jEnt.getReadTimeout();
            tval = new Integer(tstr);
            this.readTimeout = tval;
        }
        if (jEnt.getMaxWaitTime() != null) {
            tstr = jEnt.getMaxWaitTime();
            tval = new Integer(tstr);
            this.maxWaitTime = tval;
        }
        if (ent.getReentrant().equalsIgnoreCase("True")) {
            this.reentrant = true;
        } else if (ent.getReentrant().equalsIgnoreCase("False")) {
            this.reentrant = false;
        } else {
            throw new DeploymentDescException("Invalid reentrant value for bean " + this.ejbName);
        }
        if (jEnt.getPrefetch() != null) {
            if (jEnt.getPrefetch().equalsIgnoreCase("True")) {
                this.prefetch = true;
            } else if (jEnt.getPrefetch().equalsIgnoreCase("False")) {
                this.prefetch = false;
            } else {
                throw new DeploymentDescException("Invalid prefetch value for bean " + this.ejbName);
            }
        }
        if (jEnt.getHardLimit() != null) {
            if (jEnt.getHardLimit().equalsIgnoreCase("True")) {
                this.hardLimit = true;
            } else if (jEnt.getPrefetch().equalsIgnoreCase("False")) {
                this.hardLimit = false;
            } else {
                throw new DeploymentDescException("Invalid hard-limit value for bean " + this.ejbName);
            }
        }
        if (jEnt.getMinPoolSize() != null) {
            tstr = jEnt.getMinPoolSize();
            tval = new Integer(tstr);
            this.poolMin = tval;
        }
        if (jEnt.getMaxCacheSize() != null) {
            tstr = jEnt.getMaxCacheSize();
            tval = new Integer(tstr);
            this.cacheMax = tval;
        }
        if (jEnt.getLockPolicy() != null) {
            tstr = jEnt.getLockPolicy();
            if (tstr.equals("container-serialized")) {
                this.lockPolicy = 1;
                this.shared = false;
            } else if (tstr.equals("container-serialized-transacted")) {
                this.lockPolicy = 6;
                this.shared = false;
            } else if (tstr.equals("container-read-committed")) {
                this.lockPolicy = 2;
                this.shared = true;
            } else if (tstr.equals("container-read-uncommitted")) {
                this.lockPolicy = 0;
                this.shared = false;
            } else if (tstr.equals("database")) {
                this.lockPolicy = 3;
                this.shared = true;
            } else if (tstr.equals("read-only")) {
                this.lockPolicy = 4;
                this.shared = true;
            } else if (tstr.equals("container-read-write")) {
                this.lockPolicy = 5;
                this.shared = false;
            } else {
                throw new DeploymentDescException("Invalid lock-policy value for bean " + jEnt.getEjbName());
            }
        }
        if (jEnt.getShared() != null) {
            if (jEnt.getShared().equalsIgnoreCase("True")) {
                this.shared = true;
            } else if (jEnt.getShared().equalsIgnoreCase("False")) {
                this.shared = false;
            } else {
                throw new DeploymentDescException("Invalid shared value for bean " + this.ejbName);
            }
        }
        if (jEnt.getCleanup() != null) {
            tstr = jEnt.getCleanup();
            if (tstr.equals("create")) {
                this.cleanup = 1;
            } else if (tstr.equals("none")) {
                this.cleanup = 0;
            } else if (tstr.equals("removeall")) {
                this.cleanup = 3;
            } else if (tstr.equals("removedata")) {
                this.cleanup = 2;
            } else {
                throw new DeploymentDescException("Invalid cleanup value for bean " + jEnt.getEjbName());
            }
        }
        Iterator i = this.getMethodDescIterator();
        while (i.hasNext()) {
            MethodDesc methd = (MethodDesc)i.next();
            if (!methd.getMethod().getName().equals("ejbTimeout")) continue;
            this.timerTxAttribute = methd.getTxAttribute();
            this.ejbTimeoutSignature = BeanNaming.getSignature(this.getEjbName(), methd.getMethod());
        }
    }

    public int getCleanupPolicy() {
        return this.cleanup;
    }

    public int getLockPolicy() {
        return this.lockPolicy;
    }

    @Override
    protected void checkTxAttribute(MethodDesc md) throws DeploymentDescException {
        Method m = md.getMethod();
        if (md.getTxAttribute() == 0) {
            if (EJBHome.class.isAssignableFrom(m.getDeclaringClass()) && METHODS_HOME_NO_TX.indexOf("," + m.getName() + ",") != -1) {
                return;
            }
            if (EJBObject.class.isAssignableFrom(m.getDeclaringClass()) && METHODS_REMOTE_NO_TX.indexOf("," + m.getName() + ",") != -1) {
                return;
            }
            if (md.isEjbSelect()) {
                return;
            }
            logger.log(BasicLevel.WARN, (Object)("trans-attribute missing for method " + m.toString() + " in entity bean " + this.getEjbName() + " (set to the default value " + "Supports" + ")"));
            md.setTxAttribute("Supports");
        }
    }

    public int getPassivationTimeout() {
        return this.passivationTimeout;
    }

    public int getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public int getDeadlockTimeout() {
        return this.deadlockTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public Class getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public boolean isReentrant() {
        return this.reentrant;
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean isPrefetch() {
        return this.prefetch;
    }

    public boolean isHardLimit() {
        return this.hardLimit;
    }

    public boolean isAutomaticPk() {
        return this.jdbcAutomaticPk;
    }

    public boolean isUndefinedPK() {
        return this.pkObjectType;
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(super.toString());
        ret.append("\nPrimaryKeyClass()    =" + this.getPrimaryKeyClass().toString());
        ret.append("\nReentrant()          =" + this.isReentrant());
        ret.append("\nPassivationTimeout() =" + this.getPassivationTimeout());
        ret.append("\nInactivityTimeout()  =" + this.getInactivityTimeout());
        ret.append("\nDeadlockTimeout()    =" + this.getDeadlockTimeout());
        ret.append("\nReadTimeout()        =" + this.getReadTimeout());
        ret.append("\nMaxWaitTime()        =" + this.getMaxWaitTime());
        ret.append("\nShared()             =" + this.isShared());
        ret.append("\nPoolMin()            =" + this.getPoolMin());
        ret.append("\nCacheMax()           =" + this.getCacheMax());
        return ret.toString();
    }
}

