/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.builtin.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.service.command.CommandSession;
import org.fusesource.jansi.Ansi;

@Command(name="grep", scope="shelbie", description="Prints lines matching the given pattern.")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class GrepAction
implements Action,
Pojo {
    private InstanceManager __IM;
    private boolean __Fregex;
    @Argument(index=0, name="pattern", description="Regular expression", required=true, multiValued=false)
    private String regex;
    private boolean __FlineNumber;
    @Option(name="-n", aliases={"--line-number"}, description="Prefixes each line of output with the line number within its input file.", required=false, multiValued=false)
    private boolean lineNumber;
    private boolean __FinvertMatch;
    @Option(name="-v", aliases={"--invert-match"}, description="Inverts the sense of matching, to select non-matching lines.", required=false, multiValued=false)
    private boolean invertMatch;
    private boolean __FwordRegexp;
    @Option(name="-w", aliases={"--word-regexp"}, description="Selects only those lines containing matches that form whole words.  The test is that the matching substring must either be at  the beginning of the line, or preceded by a non-word constituent character.  Similarly, it must be either at the end of the line or followed by a non-word constituent character.  Word-constituent characters are letters, digits, and the underscore.", required=false, multiValued=false)
    private boolean wordRegexp;
    private boolean __FlineRegexp;
    @Option(name="-x", aliases={"--line-regexp"}, description="Selects only those matches that exactly match the whole line.", required=false, multiValued=false)
    private boolean lineRegexp;
    private boolean __FignoreCase;
    @Option(name="-i", aliases={"--ignore-case"}, description="Ignores case distinctions in both the PATTERN and the input files.", required=false, multiValued=false)
    private boolean ignoreCase;
    private boolean __Fcount;
    @Option(name="-c", aliases={"--count"}, description="only print a count of matching lines per FILE", required=false, multiValued=false)
    private boolean count;
    private boolean __Fcolor;
    @Option(name="--color", aliases={"--colour"}, description="use markers to distinguish the matching string. WHEN may be `always', `never' or `auto'", required=false, multiValued=false)
    private ColorOption color;
    private boolean __Fbefore;
    @Option(name="-B", aliases={"--before-context"}, description="Print NUM lines of leading context before matching lines.  Places a line containing -- between contiguous groups of matches.", required=false, multiValued=false)
    private int before;
    private boolean __Fafter;
    @Option(name="-A", aliases={"--after-context"}, description="Print NUM lines of trailing context after matching lines.  Places a line containing -- between contiguous groups of matches.", required=false, multiValued=false)
    private int after;
    private boolean __Fcontext;
    @Option(name="-C", aliases={"--context"}, description="Print NUM lines of output context.  Places a line containing -- between contiguous groups of matches.", required=false, multiValued=false)
    private int context;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;
    private boolean __MlastEscapeSequence$java_lang_String;

    String __getregex() {
        if (!this.__Fregex) {
            return this.regex;
        }
        return (String)this.__IM.onGet((Object)this, "regex");
    }

    void __setregex(String string) {
        if (!this.__Fregex) {
            this.regex = string;
            return;
        }
        this.__IM.onSet((Object)this, "regex", (Object)string);
    }

    boolean __getlineNumber() {
        if (!this.__FlineNumber) {
            return this.lineNumber;
        }
        Object object = this.__IM.onGet((Object)this, "lineNumber");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setlineNumber(boolean bl) {
        if (!this.__FlineNumber) {
            this.lineNumber = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "lineNumber", (Object)bl2);
    }

    boolean __getinvertMatch() {
        if (!this.__FinvertMatch) {
            return this.invertMatch;
        }
        Object object = this.__IM.onGet((Object)this, "invertMatch");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setinvertMatch(boolean bl) {
        if (!this.__FinvertMatch) {
            this.invertMatch = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "invertMatch", (Object)bl2);
    }

    boolean __getwordRegexp() {
        if (!this.__FwordRegexp) {
            return this.wordRegexp;
        }
        Object object = this.__IM.onGet((Object)this, "wordRegexp");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setwordRegexp(boolean bl) {
        if (!this.__FwordRegexp) {
            this.wordRegexp = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "wordRegexp", (Object)bl2);
    }

    boolean __getlineRegexp() {
        if (!this.__FlineRegexp) {
            return this.lineRegexp;
        }
        Object object = this.__IM.onGet((Object)this, "lineRegexp");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setlineRegexp(boolean bl) {
        if (!this.__FlineRegexp) {
            this.lineRegexp = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "lineRegexp", (Object)bl2);
    }

    boolean __getignoreCase() {
        if (!this.__FignoreCase) {
            return this.ignoreCase;
        }
        Object object = this.__IM.onGet((Object)this, "ignoreCase");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setignoreCase(boolean bl) {
        if (!this.__FignoreCase) {
            this.ignoreCase = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "ignoreCase", (Object)bl2);
    }

    boolean __getcount() {
        if (!this.__Fcount) {
            return this.count;
        }
        Object object = this.__IM.onGet((Object)this, "count");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setcount(boolean bl) {
        if (!this.__Fcount) {
            this.count = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "count", (Object)bl2);
    }

    ColorOption __getcolor() {
        if (!this.__Fcolor) {
            return this.color;
        }
        return (ColorOption)((Object)this.__IM.onGet((Object)this, "color"));
    }

    void __setcolor(ColorOption colorOption) {
        if (!this.__Fcolor) {
            this.color = colorOption;
            return;
        }
        this.__IM.onSet((Object)this, "color", (Object)colorOption);
    }

    int __getbefore() {
        if (!this.__Fbefore) {
            return this.before;
        }
        Object object = this.__IM.onGet((Object)this, "before");
        Integer n = (Integer)object;
        return n;
    }

    void __setbefore(int n) {
        if (!this.__Fbefore) {
            this.before = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "before", (Object)n2);
    }

    int __getafter() {
        if (!this.__Fafter) {
            return this.after;
        }
        Object object = this.__IM.onGet((Object)this, "after");
        Integer n = (Integer)object;
        return n;
    }

    void __setafter(int n) {
        if (!this.__Fafter) {
            this.after = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "after", (Object)n2);
    }

    int __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        Object object = this.__IM.onGet((Object)this, "context");
        Integer n = (Integer)object;
        return n;
    }

    void __setcontext(int n) {
        if (!this.__Fcontext) {
            this.context = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "context", (Object)n2);
    }

    public GrepAction() {
        this(null);
    }

    private GrepAction(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setcolor(ColorOption.auto);
        this.__setbefore(-1);
        this.__setafter(-1);
        this.__setcontext(0);
    }

    public Object execute(CommandSession commandSession) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession commandSession) throws Exception {
        Pattern p2;
        Pattern p;
        if (this.__getafter() < 0) {
            this.__setafter(this.__getcontext());
        }
        if (this.__getbefore() < 0) {
            this.__setbefore(this.__getcontext());
        }
        ArrayList<String> lines = new ArrayList<String>();
        String regexp = this.__getregex();
        if (this.__getwordRegexp()) {
            regexp = "\\b" + regexp + "\\b";
        }
        regexp = this.__getlineRegexp() ? "^" + regexp + "$" : ".*" + regexp + ".*";
        if (this.__getignoreCase()) {
            p = Pattern.compile(regexp, 2);
            p2 = Pattern.compile(this.__getregex(), 2);
        } else {
            p = Pattern.compile(regexp);
            p2 = Pattern.compile(this.__getregex());
        }
        try {
            String line;
            boolean firstPrint = true;
            int nb = 0;
            int lineno = 1;
            int lineMatch = 0;
            BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
            while ((line = r.readLine()) != null && (line.length() != 1 || line.charAt(0) != '\n')) {
                if (p.matcher(line).matches() ^ this.__getinvertMatch()) {
                    Matcher matcher2 = p2.matcher(line);
                    StringBuffer sb = new StringBuffer();
                    while (matcher2.find()) {
                        if (!this.__getinvertMatch() && this.__getcolor() != ColorOption.never) {
                            int index = matcher2.start(0);
                            String prefix = line.substring(0, index);
                            matcher2.appendReplacement(sb, Ansi.ansi().bg(Ansi.Color.YELLOW).fg(Ansi.Color.BLACK).a(matcher2.group()).reset().a(this.lastEscapeSequence(prefix)).toString());
                        } else {
                            matcher2.appendReplacement(sb, matcher2.group());
                        }
                        ++nb;
                    }
                    matcher2.appendTail(sb);
                    sb.append(Ansi.ansi().reset().toString());
                    if (!this.__getcount() && this.__getlineNumber()) {
                        lines.add(String.format("%6d  ", lineno) + sb.toString());
                    } else {
                        lines.add(sb.toString());
                    }
                    lineMatch = lines.size();
                } else {
                    if (lineMatch != 0 & lineMatch + this.__getafter() + this.__getbefore() <= lines.size()) {
                        if (!this.__getcount()) {
                            if (!firstPrint && this.__getbefore() + this.__getafter() > 0) {
                                System.out.println("--");
                            } else {
                                firstPrint = false;
                            }
                            for (int i = 0; i < lineMatch + this.__getafter(); ++i) {
                                System.out.println((String)lines.get(i));
                            }
                        }
                        while (lines.size() > this.__getbefore()) {
                            lines.remove(0);
                        }
                        lineMatch = 0;
                    }
                    lines.add(line);
                    while (lineMatch == 0 && lines.size() > this.__getbefore()) {
                        lines.remove(0);
                    }
                }
                ++lineno;
            }
            if (!this.__getcount() && lineMatch > 0) {
                if (!firstPrint && this.__getbefore() + this.__getafter() > 0) {
                    System.out.println("--");
                } else {
                    firstPrint = false;
                }
                for (int i = 0; i < lineMatch + this.__getafter() && i < lines.size(); ++i) {
                    System.out.println((String)lines.get(i));
                }
            }
            if (this.__getcount()) {
                System.out.println(nb);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    private String lastEscapeSequence(String string) {
        String string2;
        if (!this.__MlastEscapeSequence$java_lang_String) {
            return this.__M_lastEscapeSequence(string);
        }
        try {
            this.__IM.onEntry((Object)this, "lastEscapeSequence$java_lang_String", new Object[]{string});
            string2 = this.__M_lastEscapeSequence(string);
            this.__IM.onExit((Object)this, "lastEscapeSequence$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "lastEscapeSequence$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __M_lastEscapeSequence(String str) {
        String escapeSequence = Ansi.ansi().reset().toString();
        String escapePattern = "(\\\u001b\\[[0-9;]*[0-9]+m)+";
        Pattern pattern = Pattern.compile(escapePattern);
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            escapeSequence = matcher.group();
        }
        return escapeSequence;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("after")) {
                this.__Fafter = true;
            }
            if (set.contains("before")) {
                this.__Fbefore = true;
            }
            if (set.contains("color")) {
                this.__Fcolor = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("count")) {
                this.__Fcount = true;
            }
            if (set.contains("ignoreCase")) {
                this.__FignoreCase = true;
            }
            if (set.contains("invertMatch")) {
                this.__FinvertMatch = true;
            }
            if (set.contains("lineNumber")) {
                this.__FlineNumber = true;
            }
            if (set.contains("lineRegexp")) {
                this.__FlineRegexp = true;
            }
            if (set.contains("regex")) {
                this.__Fregex = true;
            }
            if (set.contains("wordRegexp")) {
                this.__FwordRegexp = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("execute$org_apache_felix_service_command_CommandSession")) {
                this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
            }
            if (set.contains("lastEscapeSequence$java_lang_String")) {
                this.__MlastEscapeSequence$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorOption {
        never,
        always,
        auto;

    }
}

