/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.audit.internal.logger.pool;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.ow2.jonas.audit.internal.logger.pool.FileLogPool;

public class DatedFileLogPool
extends FileLogPool {
    private static final String DATE_PATTERN = "[0-9]{4}-[0-1][0-9]-[0-3][0-9]";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private Calendar calendar;
    private long nextDay;

    public DatedFileLogPool(String dirPath, String className, String fixedPattern, int positionVariablePattern, String msgPattern, int maxFiles, boolean fileLogger, boolean consoleLogger) throws IOException {
        super(dirPath, className, fixedPattern, DATE_PATTERN, positionVariablePattern, msgPattern, maxFiles, fileLogger, consoleLogger);
    }

    @Override
    protected String initLogFilenamePattern() throws IOException {
        this.calendar = new GregorianCalendar();
        this.calendar.set(10, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.calendar.add(5, 1);
        this.nextDay = this.calendar.getTimeInMillis();
        return DATE_FORMAT.format(new Date());
    }

    @Override
    protected String getLogFilenamePattern() {
        if (System.currentTimeMillis() >= this.nextDay) {
            String res = DATE_FORMAT.format(this.calendar.getTime());
            this.calendar.add(5, 1);
            this.nextDay = this.calendar.getTimeInMillis();
            return res;
        }
        return null;
    }

    @Override
    protected int compareFilename(String filename1, String filename2) {
        return filename1.compareTo(filename2);
    }

    public File findFile(int year, int month, int day) {
        GregorianCalendar c = new GregorianCalendar(year, month - 1, day);
        return this.findFile(DATE_FORMAT.format(c.getTime()));
    }

    public String findFileName(int year, int month, int day) {
        GregorianCalendar c = new GregorianCalendar(year, month - 1, day);
        return this.findFileName(DATE_FORMAT.format(c.getTime()));
    }

    public void cleanLogPool(int year, int month, int day, boolean old) {
        String name = this.findFileName(year, month, day);
        this.cleanLogPool(name, old);
    }

    public void listLogFiles(int year, int month, int day, FileLogPool.LogFileAction action, boolean old, boolean inclusive) {
        String name = this.findFileName(year, month, day);
        this.listLogFiles(name, action, old, inclusive);
    }

    public void removeLogFile(int year, int month, int day) {
        String name = this.findFileName(year, month, day);
        this.removeLogFile(name);
    }

    public File[] listLogFiles(int year, int month, int day, boolean old, boolean inclusive) {
        String name = this.findFileName(year, month, day);
        return this.listLogFiles(name, old, inclusive);
    }
}

