/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxws.util;

import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;

public class JAXWSClassUtils {
    private JAXWSClassUtils() {
    }

    public static boolean isWebService(Class<?> klass) {
        return klass.getAnnotation(WebService.class) != null || klass.getAnnotation(WebServiceProvider.class) != null;
    }

    public static String getWsdlLocation(Class<?> klass) {
        WebService ws = JAXWSClassUtils.getWebService(klass);
        if (ws != null) {
            return ws.wsdlLocation();
        }
        WebServiceProvider wsp = JAXWSClassUtils.getWebServiceProvider(klass);
        if (wsp != null) {
            return wsp.wsdlLocation();
        }
        throw new IllegalStateException("Class '" + klass + "' have neither @WebService nor @WebServiceProvider annotation");
    }

    public static String getServiceName(Class<?> klass) {
        WebService ws = JAXWSClassUtils.getWebService(klass);
        if (ws != null) {
            return ws.serviceName();
        }
        WebServiceProvider wsp = JAXWSClassUtils.getWebServiceProvider(klass);
        if (wsp != null) {
            return wsp.serviceName();
        }
        throw new IllegalStateException("Class '" + klass + "' have neither @WebService nor @WebServiceProvider annotation");
    }

    private static WebService getWebService(Class<?> klass) {
        return klass.getAnnotation(WebService.class);
    }

    private static WebServiceProvider getWebServiceProvider(Class<?> klass) {
        return klass.getAnnotation(WebServiceProvider.class);
    }
}

