/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.ir.Container;
import org.jacorb.ir.IRObject;
import org.jacorb.ir.PrimitiveDef;
import org.jacorb.slf4j.Logger;
import org.omg.CORBA.AliasDef;
import org.omg.CORBA.Any;
import org.omg.CORBA.ArrayDef;
import org.omg.CORBA.ConstantDef;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainerPackage.Description;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.EnumDef;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.FixedDef;
import org.omg.CORBA.IDLType;
import org.omg.CORBA.Initializer;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.ModuleDef;
import org.omg.CORBA.NativeDef;
import org.omg.CORBA.ORB;
import org.omg.CORBA.PrimitiveDefHelper;
import org.omg.CORBA.PrimitiveDefPOATie;
import org.omg.CORBA.PrimitiveKind;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.RepositoryOperations;
import org.omg.CORBA.RepositoryPOATie;
import org.omg.CORBA.SequenceDef;
import org.omg.CORBA.StringDef;
import org.omg.CORBA.StructDef;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UnionDef;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueBoxDef;
import org.omg.CORBA.ValueDef;
import org.omg.CORBA.WstringDef;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class RepositoryImpl
extends IRObject
implements RepositoryOperations,
Configurable {
    private Container[] containers;
    private Container delegate;
    private POA poa;
    private Configuration configuration = null;
    private Logger logger = null;
    private boolean patchPragmaPrefix;

    public RepositoryImpl(String string, String string2, URLClassLoader uRLClassLoader) throws Exception {
        this.def_kind = DefinitionKind.dk_Repository;
        this.name = "Repository";
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        this.containers = new Container[stringArray.length];
        ORB oRB = ORB.init(new String[0], null);
        this.configure(((org.jacorb.orb.ORB)oRB).getConfiguration());
        this.poa = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"));
        Repository repository = RepositoryHelper.narrow(this.poa.servant_to_reference(new RepositoryPOATie(this)));
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("found path: " + stringArray[n]);
            }
            this.containers[n] = new Container(this, stringArray[n], null, uRLClassLoader, this.poa, this.logger);
            ++n;
        }
        this.delegate = this.containers[0];
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(string2), true);
        printWriter.println(oRB.object_to_string(repository));
        this.setReference(repository);
        printWriter.close();
        this.poa.the_POAManager().activate();
        if (this.logger.isInfoEnabled()) {
            URL[] uRLArray = uRLClassLoader.getURLs();
            StringBuffer stringBuffer = new StringBuffer("IR configured for class path: ");
            for (int i = 0; i < uRLArray.length; ++i) {
                stringBuffer.append(uRLArray[i].toString() + "\n");
            }
            this.logger.info(stringBuffer.toString());
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.logger = this.configuration.getLogger("jacorb.ir");
        this.patchPragmaPrefix = this.configuration.getAttributeAsBoolean("jacorb.ir.patch_pragma_prefix", false);
    }

    private String idToScopedName(String string) {
        return RepositoryImpl.idToScopedName(string, this.patchPragmaPrefix);
    }

    public static String idToScopedName(String string, boolean bl) {
        int n;
        String string2 = "";
        if (!string.startsWith("IDL:") || !string.endsWith(":1.0")) {
            return null;
        }
        String string3 = string.substring(string.indexOf(58) + 1, string.lastIndexOf(58)).replace(fileSeparator, '/');
        if (string3.startsWith("omg.org")) {
            string3 = "org/omg" + string3.substring(7);
        }
        if (bl && (n = string3.indexOf(47)) >= 0) {
            string3 = string3.substring(0, n).replace('.', '/') + "/" + string3.substring(n + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + "::" + stringTokenizer.nextToken();
            ++n2;
        }
        return string2;
    }

    public Contained lookup_id(String string) {
        String string2;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("IR lookup_id: " + string);
        }
        if ((string2 = this.idToScopedName(string)) == null) {
            return null;
        }
        return this.lookup(string2);
    }

    public org.omg.CORBA.PrimitiveDef get_primitive(PrimitiveKind primitiveKind) {
        try {
            return PrimitiveDefHelper.narrow(this.poa.servant_to_reference(new PrimitiveDefPOATie(new PrimitiveDef(primitiveKind.value()))));
        }
        catch (Exception exception) {
            this.logger.error("unexpected exception", exception);
            return null;
        }
    }

    public StringDef create_string(int n) {
        return null;
    }

    public WstringDef create_wstring(int n) {
        return null;
    }

    public FixedDef create_fixed(short s, short s2) {
        return null;
    }

    public SequenceDef create_sequence(int n, IDLType iDLType) {
        return null;
    }

    public ArrayDef create_array(int n, IDLType iDLType) {
        return null;
    }

    public TypeCode get_canonical_typecode(TypeCode typeCode) {
        return null;
    }

    public Contained lookup(String string) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("IR lookup : " + string);
        }
        Contained contained = null;
        for (int i = 0; i < this.containers.length && (contained = this.containers[i].lookup(string)) == null; ++i) {
        }
        return contained;
    }

    public Contained[] lookup_name(String string, int n, DefinitionKind definitionKind, boolean bl) {
        int n2;
        int n3;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("IR lookup_name: " + string);
        }
        Contained[] containedArray = null;
        Vector<Contained[]> vector = new Vector<Contained[]>();
        for (n3 = 0; n3 < this.containers.length; ++n3) {
            vector.addElement(this.containers[n3].lookup_name(string, n, definitionKind, bl));
        }
        n3 = 0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            n3 += ((Object[])vector.elementAt(n2)).length;
        }
        containedArray = new Contained[n3];
        n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Contained[] containedArray2 = (Contained[])vector.elementAt(i);
            System.arraycopy(containedArray2, 0, containedArray, n2, containedArray2.length);
            n2 += containedArray2.length;
        }
        return containedArray;
    }

    public Contained[] contents(DefinitionKind definitionKind, boolean bl) {
        int n;
        int n2;
        Contained[] containedArray = null;
        Vector<Contained[]> vector = new Vector<Contained[]>();
        for (n2 = 0; n2 < this.containers.length; ++n2) {
            vector.addElement(this.containers[n2].contents(definitionKind, bl));
        }
        n2 = 0;
        for (n = 0; n < vector.size(); ++n) {
            n2 += ((Object[])vector.elementAt(n)).length;
        }
        containedArray = new Contained[n2];
        n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Contained[] containedArray2 = (Contained[])vector.elementAt(i);
            System.arraycopy(containedArray2, 0, containedArray, n, containedArray2.length);
            n += containedArray2.length;
        }
        return containedArray;
    }

    public Description[] describe_contents(DefinitionKind definitionKind, boolean bl, int n) {
        Contained[] containedArray = this.contents(definitionKind, bl);
        int n2 = n > containedArray.length ? n : containedArray.length;
        Description[] descriptionArray = new Description[n2];
        for (int i = 0; i < n2; ++i) {
            descriptionArray[i] = new Description();
            org.omg.CORBA.ContainedPackage.Description description = containedArray[i].describe();
            descriptionArray[i].contained_object = containedArray[i];
            descriptionArray[i].kind = description.kind;
            descriptionArray[i].value = description.value;
        }
        return descriptionArray;
    }

    void define() {
    }

    public void loadContents() {
        int n;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Repository loads contents...");
        }
        for (n = 0; n < this.containers.length; ++n) {
            this.containers[n].loadContents();
        }
        for (n = 0; n < this.containers.length; ++n) {
            this.containers[n].define();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Repository contents loaded");
        }
    }

    public ModuleDef create_module(String string, String string2, String string3) {
        return this.delegate.create_module(string, string2, string3);
    }

    public ConstantDef create_constant(String string, String string2, String string3, IDLType iDLType, Any any) {
        return this.delegate.create_constant(string, string2, string3, iDLType, any);
    }

    public StructDef create_struct(String string, String string2, String string3, StructMember[] structMemberArray) {
        return this.delegate.create_struct(string, string2, string3, structMemberArray);
    }

    public UnionDef create_union(String string, String string2, String string3, IDLType iDLType, UnionMember[] unionMemberArray) {
        return this.delegate.create_union(string, string2, string3, iDLType, unionMemberArray);
    }

    public EnumDef create_enum(String string, String string2, String string3, String[] stringArray) {
        return this.delegate.create_enum(string, string2, string3, stringArray);
    }

    public AliasDef create_alias(String string, String string2, String string3, IDLType iDLType) {
        return this.delegate.create_alias(string, string2, string3, iDLType);
    }

    public ExceptionDef create_exception(String string, String string2, String string3, StructMember[] structMemberArray) {
        return this.delegate.create_exception(string, string2, string3, structMemberArray);
    }

    public InterfaceDef create_interface(String string, String string2, String string3, InterfaceDef[] interfaceDefArray, boolean bl) {
        return this.delegate.create_interface(string, string2, string3, interfaceDefArray, bl);
    }

    public ValueBoxDef create_value_box(String string, String string2, String string3, IDLType iDLType) {
        return this.delegate.create_value_box(string, string2, string3, iDLType);
    }

    public ValueDef create_value(String string, String string2, String string3, boolean bl, boolean bl2, ValueDef valueDef, boolean bl3, ValueDef[] valueDefArray, InterfaceDef[] interfaceDefArray, Initializer[] initializerArray) {
        return this.delegate.create_value(string, string2, string3, bl, bl2, valueDef, bl3, valueDefArray, interfaceDefArray, initializerArray);
    }

    public NativeDef create_native(String string, String string2, String string3) {
        return this.delegate.create_native(string, string2, string3);
    }

    public void destroy() {
        this.delegate.destroy();
    }
}

