/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.container;

import java.util.ArrayList;
import java.util.List;
import org.jacorb.config.Configuration;
import org.jacorb.notification.util.LogUtil;
import org.jacorb.slf4j.Logger;
import org.omg.BiDirPolicy.BidirectionalPolicyValueHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.POA;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.DecoratingComponentAdapter;

public class BiDirGiopPOAComponentAdapter
extends DecoratingComponentAdapter {
    private static final long serialVersionUID = 1L;
    private static final String BIDIR_GIOP_OPTION = "org.omg.PortableInterceptor.ORBInitializerClass.bidir_init";

    public BiDirGiopPOAComponentAdapter(ComponentAdapter componentAdapter) {
        super(componentAdapter);
    }

    private static boolean isBiDirGiopEnabled(Configuration configuration) {
        return configuration.getAttribute(BIDIR_GIOP_OPTION, null) != null;
    }

    private static Policy newBiDirGiopPolicy(ORB oRB) throws PolicyError {
        Any any = oRB.create_any();
        BidirectionalPolicyValueHelper.insert(any, (short)1);
        Policy policy = oRB.create_policy(37, any);
        return policy;
    }

    public Object getComponentInstance(PicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException {
        POA pOA = (POA)super.getComponentInstance(picoContainer);
        Configuration configuration = (Configuration)picoContainer.getComponentInstanceOfType(Configuration.class);
        Logger logger = LogUtil.getLogger(configuration, ((Object)((Object)this)).getClass().getName());
        try {
            ORB oRB = (ORB)picoContainer.getComponentInstanceOfType(ORB.class);
            ArrayList<ImplicitActivationPolicy> arrayList = new ArrayList<ImplicitActivationPolicy>();
            arrayList.add(pOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION));
            BiDirGiopPOAComponentAdapter.addBiDirGiopPolicy(arrayList, oRB, configuration);
            if (BiDirGiopPOAComponentAdapter.isBiDirGiopEnabled(configuration) && logger.isInfoEnabled()) {
                logger.info("org.omg.PortableInterceptor.ORBInitializerClass.bidir_init is set: Will enable Bidirectional GIOP.");
            }
            Policy[] policyArray = arrayList.toArray(new Policy[arrayList.size()]);
            POA pOA2 = pOA.create_POA("NotifyServicePOA", pOA.the_POAManager(), policyArray);
            for (int i = 0; i < policyArray.length; ++i) {
                policyArray[i].destroy();
            }
            return pOA2;
        }
        catch (UserException userException) {
            throw new PicoInitializationException("Error enabling BiDirectional GIOP for POA", (Throwable)userException);
        }
    }

    public static void addBiDirGiopPolicy(List list, ORB oRB, Configuration configuration) throws PolicyError {
        if (BiDirGiopPOAComponentAdapter.isBiDirGiopEnabled(configuration)) {
            Policy policy = BiDirGiopPOAComponentAdapter.newBiDirGiopPolicy(oRB);
            list.add(policy);
        }
    }
}

