/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.base.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ow2.jonas.web.base.proxy.HttpSocketHandler;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CopyingStream
extends Thread {
    private static Log logger = LogFactory.getLog(CopyingStream.class);
    private InputStream inputStream;
    private OutputStream outputStream;
    private ByteArrayOutputStream byteArrayOutputStream;
    private HttpSocketHandler socketHandler = null;

    public CopyingStream(HttpSocketHandler socketHandler, ByteArrayOutputStream byteArrayOutputStream, InputStream inputStream, OutputStream outputStream) {
        this.socketHandler = socketHandler;
        this.byteArrayOutputStream = byteArrayOutputStream;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    @Override
    public void run() {
        byte[] buf = new byte[1024];
        byte[] headerBytes = this.byteArrayOutputStream.toByteArray();
        try {
            this.outputStream.write(headerBytes, 0, headerBytes.length);
        }
        catch (IOException e) {
            logger.debug((Object)"Cannot write bytes", new Object[]{e});
        }
        try {
            int count;
            while ((count = this.inputStream.read(buf)) > 0) {
                this.outputStream.write(buf, 0, count);
            }
        }
        catch (Exception e) {
            this.socketHandler.cleanup("Unable to handle data from server to the client", e);
        }
    }
}

