/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import com.scalagent.jmx.JMXServer;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXServer;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.CommException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;
import org.objectweb.joram.client.connector.ActivationSpecImpl;
import org.objectweb.joram.client.connector.InboundConsumer;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryImpl;
import org.objectweb.joram.client.connector.ManagedConnectionImpl;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.ConnectionMetaData;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.local.LocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.joram.client.osgi.JndiHelper;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JoramResourceAdapter
implements ResourceAdapter,
ExceptionListener,
Serializable {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)JoramResourceAdapter.class.getName());
    protected JndiHelper jndiHelper = null;
    protected Status status;
    protected static String jmxRootName = "JoramAdapter";
    private Vector<String> boundNames;
    private transient WorkManager workManager;
    protected String name;
    protected String jndiName;
    private transient Hashtable<ActivationSpecImpl, InboundConsumer> consumers = new Hashtable();
    private transient Vector<ManagedConnectionImpl> producers = new Vector();
    private transient Hashtable<String, XAConnection> connections;

    public int getStatus() {
        return this.status.value;
    }

    public String getStatusInfo() {
        return Status.info[this.status.value];
    }

    public void setJmxServer(MBeanServer jmxServer) {
        MXWrapper.setMXServer((MXServer)new JMXServer(jmxServer));
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public JoramResourceAdapter() {
        ArrayList<MBeanServer> array;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)"JORAM adapter instantiated.");
        }
        if (!(array = MBeanServerFactory.findMBeanServer(null)).isEmpty()) {
            this.setJmxServer(array.get(0));
        }
        this.boundNames = new Vector();
        this.jndiHelper = new JndiHelper();
        this.status = new Status();
    }

    public JoramResourceAdapter(MBeanServer jmxServer) {
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)"JORAM adapter instantiated.");
        }
        this.setJmxServer(jmxServer);
        this.boundNames = new Vector();
        this.jndiHelper = new JndiHelper();
        this.status = new Status();
    }

    public synchronized void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        this.setWorkManager(ctx.getWorkManager());
        this.start();
    }

    public synchronized void start() throws ResourceAdapterInternalException {
        if (this.getStatus() == 2) {
            throw new ResourceAdapterInternalException("Adapter already started.");
        }
        if (this.getStatus() == 4) {
            throw new ResourceAdapterInternalException("Adapter has been stopped.");
        }
        if (this.workManager == null) {
            throw new ResourceAdapterInternalException("WorkManager has not been set.");
        }
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)"JORAM Resource adapter starting...");
        }
        this.status.value = 1;
        if (this.jndiName != null && this.jndiName.length() > 0) {
            this.bind(this.jndiName, this);
        }
        this.status.value = 2;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)("JORAM Resource adapter " + ConnectionMetaData.providerVersion + " successfully deployed."));
        }
    }

    public synchronized void stop() {
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)"JORAM Resource adapter stopping...");
        }
        if (this.getStatus() != 2 || this.getStatus() == 4) {
            return;
        }
        this.status.value = 3;
        while (!this.boundNames.isEmpty()) {
            this.unbind(this.boundNames.remove(0));
        }
        while (!this.producers.isEmpty()) {
            try {
                this.producers.remove(0).destroy();
            }
            catch (Exception exc) {}
        }
        Enumeration<Object> keys = this.consumers.keys();
        while (keys.hasMoreElements()) {
            this.consumers.get(keys.nextElement()).close();
        }
        if (this.connections != null) {
            keys = this.connections.keys();
            while (keys.hasMoreElements()) {
                try {
                    this.connections.get(keys.nextElement()).close();
                }
                catch (Exception exception) {}
            }
        }
        this.status.value = 4;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)"JORAM Resource adapter successfully stopped.");
        }
    }

    public String createUser(String userName, String password, String identityClass) throws Exception {
        throw new Exception("createUser: not yet available.");
    }

    public String createQueue(String name) throws Exception {
        throw new Exception("createQueue: not yet available.");
    }

    public String createTopic(String name) throws Exception {
        throw new Exception("createTopic: not yet available.");
    }

    private ConnectionFactory getConnectionFactory(ActivationSpecImpl specImpl) {
        ConnectionFactory cf = null;
        cf = specImpl.getCollocated() != false ? LocalConnectionFactory.create() : TcpConnectionFactory.create((String)specImpl.getHostName(), (int)specImpl.getServerPort());
        cf.getParameters().connectingTimer = specImpl.getConnectingTimer();
        cf.getParameters().cnxPendingTimer = specImpl.getCnxPendingTimer();
        cf.getParameters().txPendingTimer = specImpl.getTxPendingTimer();
        if (specImpl.getQueueMessageReadMax() > 0) {
            cf.getParameters().queueMessageReadMax = specImpl.getQueueMessageReadMax();
        }
        if (specImpl.getTopicAckBufferMax() > 0) {
            cf.getParameters().topicAckBufferMax = specImpl.getTopicAckBufferMax();
        }
        if (specImpl.getTopicPassivationThreshold() > 0) {
            cf.getParameters().topicPassivationThreshold = specImpl.getTopicPassivationThreshold();
        }
        if (specImpl.getTopicActivationThreshold() > 0) {
            cf.getParameters().topicActivationThreshold = specImpl.getTopicActivationThreshold();
        }
        cf.setIdentityClassName(specImpl.getIdentityClass());
        return cf;
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        int ackMode;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " endpointActivation(" + endpointFactory + ", " + spec + ")"));
        }
        if (this.getStatus() != 2) {
            throw new IllegalStateException("Non started resource adapter.");
        }
        if (this.getStatus() == 4) {
            throw new IllegalStateException("Stopped resource adapter.");
        }
        if (!(spec instanceof ActivationSpecImpl)) {
            throw new ResourceException("Provided ActivationSpec instance is not a JORAM activation spec.");
        }
        ActivationSpecImpl specImpl = (ActivationSpecImpl)spec;
        if (!specImpl.getResourceAdapter().equals(this)) {
            throw new ResourceException("Supplied ActivationSpec instance associated to an other ResourceAdapter.");
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Activating Endpoint on JORAM adapter.");
        }
        boolean durable = specImpl.getSubscriptionDurability() != null && specImpl.getSubscriptionDurability().equalsIgnoreCase("Durable");
        boolean transacted = false;
        try {
            Class<?> listenerClass = Class.forName("javax.jms.MessageListener");
            Class[] parameters = new Class[]{Class.forName("javax.jms.Message")};
            Method meth = listenerClass.getMethod("onMessage", parameters);
            transacted = endpointFactory.isDeliveryTransacted(meth);
        }
        catch (Exception exc) {
            throw new ResourceException("Could not determine transactional context: " + exc);
        }
        int maxWorks = 10;
        try {
            maxWorks = Integer.parseInt(specImpl.getMaxNumberOfWorks());
        }
        catch (Exception exc) {
            throw new ResourceException("Invalid max number of works instances number: " + exc);
        }
        int maxMessages = 10;
        try {
            maxMessages = Integer.parseInt(specImpl.getMaxMessages());
        }
        catch (Exception exc) {
            throw new ResourceException("Invalid max messages number: " + exc);
        }
        try {
            ackMode = "Auto-acknowledge".equals(specImpl.getAcknowledgeMode()) ? 1 : ("Dups-ok-acknowledge".equals(specImpl.getAcknowledgeMode()) ? 3 : 1);
        }
        catch (Exception exc) {
            throw new ResourceException("Invalid acknowledge mode: " + exc);
        }
        String destType = specImpl.getDestinationType();
        String destName = specImpl.getDestination();
        try {
            Destination dest;
            block33: {
                dest = null;
                try {
                    InitialContext ctx = new InitialContext();
                    dest = (Destination)ctx.lookup(destName);
                }
                catch (NamingException exc) {
                    if ("javax.jms.Queue".equals(destType)) {
                        this.createQueue(destName);
                    } else if ("javax.jms.Topic".equals(destType)) {
                        this.createTopic(destName);
                    } else {
                        throw new NotSupportedException("Invalid destination type provided as activation parameter: " + destType);
                    }
                    try {
                        InitialContext ctx = new InitialContext();
                        dest = (Destination)ctx.lookup(destName);
                    }
                    catch (NamingException e) {
                        throw new ResourceException("The destination \"" + destName + "\" not found. " + e.getMessage());
                    }
                    if (!logger.isLoggable(BasicLevel.INFO)) break block33;
                    logger.log(BasicLevel.INFO, (Object)("  - Destination [" + dest.getName() + "] has been created."));
                }
            }
            if ("javax.jms.Queue".equals(destType)) {
                if (!(dest instanceof Queue)) {
                    throw new NotSupportedException("Existing destination " + destName + " does not provide correct type.");
                }
            } else if ("javax.jms.Topic".equals(destType)) {
                if (!(dest instanceof Topic)) {
                    throw new NotSupportedException("Existing destination " + destName + " does not provide correct type.");
                }
            } else {
                throw new NotSupportedException("Invalid destination type provided as activation parameter: " + destType);
            }
            String userName = specImpl.getUserName();
            String password = specImpl.getPassword();
            String identityClass = specImpl.getIdentityClass();
            this.createUser(userName, password, identityClass);
            ConnectionFactory cf = this.getConnectionFactory(specImpl);
            cf.setCnxJMXBeanBaseName(jmxRootName + "#" + this.getName());
            XAConnection cnx = cf.createXAConnection(userName, password);
            cnx.setExceptionListener((ExceptionListener)this);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " endpointActivation cnx = " + cnx));
            }
            InboundConsumer consumer = new InboundConsumer(this.workManager, endpointFactory, cnx, (javax.jms.Destination)dest, specImpl.getMessageSelector(), durable, specImpl.getSubscriptionName(), transacted, maxWorks, maxMessages, ackMode, specImpl.getDeleteDurableSubscription());
            this.consumers.put(specImpl, consumer);
        }
        catch (JMSSecurityException exc) {
            throw new SecurityException("Invalid user identification: " + (Object)((Object)exc));
        }
        catch (JMSException exc) {
            throw new CommException("Could not connect to the JORAM server: " + (Object)((Object)exc));
        }
        catch (Exception exc) {
            throw new ResourceException("Problem when handling the JORAM destinations: " + exc);
        }
    }

    public void onException(JMSException exception) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("JoramResourceAdapter: onException " + (Object)((Object)exception)));
        }
        while (true) {
            try {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)"JoramResourceAdapter: try to reconnect...");
                }
                this.reconnect();
                if (!logger.isLoggable(BasicLevel.WARN)) break;
                logger.log(BasicLevel.WARN, (Object)"JoramResourceAdapter: reconnected.");
            }
            catch (Exception e) {
                continue;
            }
            break;
        }
    }

    public synchronized void reconnect() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"JoramResourceAdapter: reconnect()");
        }
        if (this.getStatus() != 2 || this.getStatus() == 4) {
            return;
        }
        Hashtable copyConsumers = (Hashtable)this.consumers.clone();
        Set keys = copyConsumers.entrySet();
        for (Map.Entry entry : keys) {
            MessageEndpointFactory endpointFactory = ((InboundConsumer)entry.getValue()).endpointFactory;
            ActivationSpec spec = (ActivationSpec)entry.getKey();
            try {
                this.endpointDeactivation(endpointFactory, spec);
                this.endpointActivation(endpointFactory, spec);
            }
            catch (ResourceException e) {
                if (!logger.isLoggable(BasicLevel.INFO)) continue;
                logger.log(BasicLevel.INFO, (Object)("JoramResourceAdapter: reconnect spec = " + spec), (Throwable)e);
            }
        }
        for (ManagedConnectionImpl mci : (Vector)this.producers.clone()) {
            mci.reconnect();
        }
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        InboundConsumer consumer;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " endpointDeactivation(" + endpointFactory + ", " + spec + ")"));
        }
        if (this.getStatus() != 2 || this.getStatus() == 4) {
            return;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Deactivating Endpoint on JORAM adapter.");
        }
        if ((consumer = this.consumers.remove(spec)) != null) {
            consumer.close();
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResources(" + specs + ")"));
        }
        if (this.getStatus() != 2) {
            throw new IllegalStateException("Non started resource adapter.");
        }
        if (this.getStatus() == 4) {
            throw new IllegalStateException("Stopped resource adapter.");
        }
        ConnectionFactory cf = null;
        Vector<XAResource> resources = new Vector<XAResource>();
        if (this.connections == null) {
            this.connections = new Hashtable();
        }
        try {
            for (int i = 0; i < specs.length; ++i) {
                if (!(specs[i] instanceof ActivationSpecImpl)) {
                    throw new ResourceException("Provided ActivationSpec instance is not a JORAM activation spec.");
                }
                ActivationSpecImpl specImpl = (ActivationSpecImpl)specs[i];
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResources ActivationSpecImpl = " + specImpl));
                }
                if (!specImpl.getResourceAdapter().equals(this)) {
                    throw new ResourceException("Supplied ActivationSpec instance associated to an other ResourceAdapter.");
                }
                String userName = specImpl.getUserName();
                if (!this.connections.containsKey(userName)) {
                    String password = specImpl.getPassword();
                    cf = this.getConnectionFactory(specImpl);
                    cf.setCnxJMXBeanBaseName(jmxRootName + "#" + this.getName());
                    XAConnection connection = cf.createXAConnection(userName, password);
                    this.connections.put(userName, connection);
                    resources.add(connection.createXASession().getXAResource());
                }
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResources resources = " + resources));
            }
        }
        catch (JMSSecurityException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"EXCEPTION:: getXAResources ", (Throwable)exc);
            }
            throw new SecurityException("Invalid user identification: " + (Object)((Object)exc));
        }
        catch (JMSException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"EXCEPTION:: getXAResources ", (Throwable)exc);
            }
            throw new CommException("Could not connect to the JORAM server: " + (Object)((Object)exc));
        }
        return resources.toArray(new XAResource[resources.size()]);
    }

    void addProducer(ManagedConnectionImpl managedCx) {
        this.producers.add(managedCx);
    }

    void removeProducer(ManagedConnectionImpl managedCx) {
        this.producers.remove(managedCx);
    }

    public String getJMSVersion() {
        return "1.1";
    }

    public String getJMSProviderName() {
        return "Joram";
    }

    public String getProviderVersion() {
        return ConnectionMetaData.providerVersion;
    }

    protected void bind(String name, Object obj) {
        block3: {
            try {
                this.jndiHelper.rebind(name, obj);
                if (!this.boundNames.contains(name)) {
                    this.boundNames.add(name);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.WARN)) break block3;
                logger.log(BasicLevel.WARN, (Object)("Binding failed:  bind(" + name + "," + obj + ")"), (Throwable)e);
            }
        }
    }

    protected void unbind(String name) {
        try {
            this.jndiHelper.unbind(name);
            this.boundNames.remove(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createCF(String name, ManagedConnectionFactoryImpl mcf) {
        try {
            mcf.setName(name);
            mcf.setResourceAdapter(this);
            Object factory = mcf.createConnectionFactory();
            this.bind(name, factory);
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("  - ConnectionFactory [" + name + "] has been created and bound."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createQueueCF(String name, ManagedConnectionFactoryImpl mcf) {
        try {
            mcf.setName(name);
            mcf.setResourceAdapter(this);
            Object factory = mcf.createConnectionFactory();
            this.bind(name, factory);
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("  - QueueConnectionFactory [" + name + "] has been created and bound."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createTopicCF(String name, ManagedConnectionFactoryImpl mcf) {
        try {
            mcf.setName(name);
            mcf.setResourceAdapter(this);
            Object factory = mcf.createConnectionFactory();
            this.bind(name, factory);
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("  - TopicConnectionFactory [" + name + "] has been created and bound."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Status {
        public static final int NONE = 0;
        public static final int STARTING = 1;
        public static final int STARTED = 2;
        public static final int STOPPING = 3;
        public static final int STOPPED = 4;
        int value = 0;
        public static String[] info = new String[]{"none", "starting", "started", "stopping", "stopped"};
    }
}

