/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cmi.internal.event;

import java.util.Set;
import javax.ejb.EJBObject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.info.CMIInfoExtractor;
import org.ow2.cmi.info.CMIInfoExtractorException;
import org.ow2.cmi.info.CMIInfoRepository;
import org.ow2.cmi.info.ClusteredObjectInfo;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.ServerId;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.jonas.lib.util.Log;
import org.ow2.util.ee.event.listeners.AbsBeanEventListener;
import org.ow2.util.ee.event.types.BeanRegisterEvent;
import org.ow2.util.ee.event.types.BeanUnregisterEvent;
import org.ow2.util.event.api.IEvent;

public class BeanEventListener
extends AbsBeanEventListener {
    private static final String EVENT_PROVIDER_FILTER = "/beans/lifecycle/events";
    private static final long serialVersionUID = 1L;
    private static Logger cmilogger = Log.getLogger((String)"org.ow2.jonas.cmi");
    private ServerClusterViewManager clusterViewManager = null;

    public BeanEventListener(ServerClusterViewManager clusterViewManager) {
        super(EVENT_PROVIDER_FILTER);
        this.clusterViewManager = clusterViewManager;
    }

    public void handle(IEvent event) {
        try {
            if (BeanUnregisterEvent.class.isAssignableFrom(event.getClass())) {
                this.removeClusteredObject(((BeanUnregisterEvent)event).getJndiName());
            } else if (BeanRegisterEvent.class.isAssignableFrom(event.getClass())) {
                BeanRegisterEvent beanRegisterEvent = (BeanRegisterEvent)event;
                this.addClusteredObject(beanRegisterEvent.getJndiName(), beanRegisterEvent.getClusterConfig(), beanRegisterEvent.getHomeClass(), beanRegisterEvent.getRemoteClass(), beanRegisterEvent.getClassLoader(), beanRegisterEvent.isStateful(), beanRegisterEvent.isClusterReplicated());
            } else {
                cmilogger.log(BasicLevel.DEBUG, (Object)"Unrecognized event type");
            }
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)("Unable to handle event \n" + e));
        }
    }

    public synchronized void removeClusteredObject(String jndiName) throws Exception {
        cmilogger.log(BasicLevel.DEBUG, (Object)("Removing clustered object named :" + jndiName));
        if (CMIInfoRepository.containClusteredObjectInfo((String)jndiName)) {
            ServerId serverRef = null;
            Set protocols = this.clusterViewManager.getProtocols();
            for (String proto : protocols) {
                serverRef = this.clusterViewManager.getRefOnLocalRegistry(proto);
                CMIReference cmiReference = new CMIReference((ServerRef)serverRef, jndiName);
                try {
                    this.clusterViewManager.removeCMIReference(cmiReference);
                }
                catch (Exception e) {
                    cmilogger.log(BasicLevel.DEBUG, (Object)(jndiName + "Not bound in the with protocol " + proto));
                }
            }
            CMIInfoRepository.removeClusteredObjectInfo((String)jndiName);
        }
    }

    public synchronized void addClusteredObject(String jndiName, Object clusterConfig, Class<?> homeClass, Class<? extends EJBObject> remoteClass, ClassLoader classLoader, boolean stateful, boolean clusterReplicated) throws Exception {
        if (clusterConfig != null) {
            try {
                ClusteredObjectInfo clusteredObjectInfo = CMIInfoExtractor.extractClusteringInfoFromClusteredObject((Object)clusterConfig, homeClass, remoteClass, (boolean)stateful, (boolean)clusterReplicated, null);
                CMIInfoRepository.addClusteredObjectInfo((String)jndiName, (ClusteredObjectInfo)clusteredObjectInfo);
                cmilogger.log(BasicLevel.INFO, (Object)("The object with name " + jndiName + " is clustered."));
            }
            catch (CMIInfoExtractorException e) {
                cmilogger.log(BasicLevel.ERROR, (Object)("Error when extracting infos about clustering for the object with name " + jndiName), (Throwable)e);
                throw new Exception("Error when extracting infos about clustering for the object with name " + jndiName, e);
            }
        } else {
            cmilogger.log(BasicLevel.DEBUG, (Object)("Cluster configuration not set for the object : " + clusterConfig));
        }
    }
}

