/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.security.Identity;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.Session;
import javax.jms.XASession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.ejb21.JMdbFactory;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.tm.TransactionManager;

public class JMessageDrivenBean
implements MessageListener,
ServerSession,
Work,
MessageDrivenContext {
    private static final String JAVA_COMP_ENV = "java:comp/env/";
    protected Session sess = null;
    protected JMdbFactory bf = null;
    protected MessageDrivenBean mdb = null;
    protected int txattr;
    protected int timerTxAttr;
    protected TransactionManager tm = null;
    protected WorkManager wm = null;
    private static final String DISALLOWED_MSG = " is disallowed in a message driven bean";

    public JMessageDrivenBean(JMdbFactory bf, Session sess, MessageDrivenBean mdb, WorkManager wm) {
        this.bf = bf;
        this.sess = sess;
        this.mdb = mdb;
        this.wm = wm;
        this.txattr = bf.getTransactionAttribute();
        this.timerTxAttr = bf.getTimerTxAttribute();
        this.tm = bf.getTransactionManager();
    }

    public TimerService getTimerService() throws IllegalStateException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.bf.getTimerService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onMessage(Message message) {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        RequestCtx rctx = null;
        try {
            if (this.tm.getTransaction() != null) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"Transaction already OPENED");
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)("Transaction = " + this.tm.getTransaction()));
                Thread.dumpStack();
                return;
            }
            rctx = this.bf.preInvoke(this.txattr);
            this.bf.checkSecurity(null);
            if (rctx.mustCommit) {
                if (TraceEjb.isDebugTx()) {
                    TraceEjb.tx.log(BasicLevel.DEBUG, (Object)"enlistResource");
                }
                rctx.currTx.enlistResource(((XASession)this.sess).getXAResource());
            }
        }
        catch (Exception e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"preInvoke failed: ", (Throwable)e);
            return;
        }
        try {
            if (TraceEjb.isDebugJms()) {
                TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"Call MDB");
            }
            ((MessageListener)this.mdb).onMessage(message);
            if (TraceEjb.isDebugJms()) {
                TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"Return from MDB");
            }
        }
        catch (RuntimeException e) {
            rctx.sysExc = e;
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"runtime exception thrown by an enterprise Bean", (Throwable)e);
        }
        catch (Error e) {
            rctx.sysExc = e;
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"error thrown by an enterprise Bean", (Throwable)e);
        }
        finally {
            try {
                if (rctx.mustCommit) {
                    if (TraceEjb.isDebugTx()) {
                        TraceEjb.tx.log(BasicLevel.DEBUG, (Object)"delistResource");
                    }
                    rctx.currTx.delistResource(((XASession)this.sess).getXAResource(), 0x4000000);
                }
                this.bf.postInvoke(rctx);
            }
            catch (Exception e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"exception on postInvoke: ", (Throwable)e);
            }
        }
    }

    public Session getSession() throws JMSException {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.sess;
    }

    public void start() throws JMSException {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.wm.scheduleWork((Work)this);
        }
        catch (WorkException e) {
            JMSException jmsE = new JMSException("Cannot schedule work");
            jmsE.initCause((Throwable)e);
            throw jmsE;
        }
    }

    public void run() {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        Thread.currentThread().setContextClassLoader(this.bf.myClassLoader());
        this.sess.run();
        this.bf.releaseServerSession(this);
    }

    public void release() {
        TraceEjb.mdb.log(BasicLevel.WARN, (Object)"Ignored");
    }

    public Identity getCallerIdentity() {
        TraceEjb.logger.log(BasicLevel.ERROR, (Object)DISALLOWED_MSG);
        throw new IllegalStateException("getCallerIdentity() is disallowed in a message driven bean");
    }

    public Principal getCallerPrincipal() {
        TraceEjb.logger.log(BasicLevel.ERROR, (Object)DISALLOWED_MSG);
        throw new IllegalStateException("getCallerPrincipal() is disallowed in a message driven bean");
    }

    public boolean isCallerInRole(Identity role) {
        TraceEjb.logger.log(BasicLevel.ERROR, (Object)DISALLOWED_MSG);
        throw new IllegalStateException("isCallerInRole() is disallowed in a message driven bean");
    }

    public boolean isCallerInRole(String roleLink) {
        TraceEjb.logger.log(BasicLevel.ERROR, (Object)DISALLOWED_MSG);
        throw new IllegalStateException("isCallerInRole() is disallowed in a message driven bean");
    }

    public void setRollbackOnly() {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.tm.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"current thread not associated with transaction");
            throw e;
        }
        catch (SystemException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"unexpected exception:", (Throwable)e);
        }
    }

    public boolean getRollbackOnly() {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            if (this.tm.getTransaction() != null) {
                switch (this.tm.getStatus()) {
                    case 1: 
                    case 4: 
                    case 9: {
                        return true;
                    }
                    case 6: {
                        throw new IllegalStateException("No transaction");
                    }
                }
                return false;
            }
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"the bean is not associated in a transaction");
            throw new IllegalStateException("the message driven bean is not associated in a transaction");
        }
        catch (SystemException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"cannot get status:", (Throwable)e);
            return false;
        }
    }

    public EJBHome getEJBHome() {
        TraceEjb.logger.log(BasicLevel.ERROR, (Object)DISALLOWED_MSG);
        throw new IllegalStateException("getEJBHome() is disallowed in a message driven bean");
    }

    public EJBLocalHome getEJBLocalHome() {
        TraceEjb.logger.log(BasicLevel.ERROR, (Object)DISALLOWED_MSG);
        throw new IllegalStateException("getEJBLocalHome() is disallowed in a message driven bean");
    }

    public Properties getEnvironment() {
        TraceEjb.logger.log(BasicLevel.ERROR, (Object)"deprecated use : Use the JNDI naming context java:comp/env");
        return new Properties();
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        if (TraceEjb.isDebugJms()) {
            TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
        }
        if (!this.bf.isTxBeanManaged()) {
            throw new IllegalStateException("This bean is not allowed to use UserTransaction interface");
        }
        return (UserTransaction)this.tm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverTimeout(Timer timer) {
        block23: {
            if (TraceEjb.isDebugJms()) {
                TraceEjb.mdb.log(BasicLevel.DEBUG, (Object)"");
            }
            RequestCtx rctx = null;
            try {
                rctx = this.bf.preInvoke(this.timerTxAttr);
            }
            catch (Exception e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"preInvoke failed: ", (Throwable)e);
                return;
            }
            try {
                this.bf.checkSecurity(null);
                if (this.mdb instanceof TimedObject) {
                    ((TimedObject)this.mdb).ejbTimeout(timer);
                    break block23;
                }
                throw new EJBException("The bean does not implement the `TimedObject` interface");
            }
            catch (EJBException e) {
                rctx.sysExc = e;
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"EJB exception thrown by an enterprise Bean", (Throwable)e);
            }
            catch (RuntimeException e) {
                rctx.sysExc = e;
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"runtime exception thrown by an enterprise Bean", (Throwable)e);
            }
            catch (Error e) {
                rctx.sysExc = e;
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"error thrown by an enterprise Bean", (Throwable)e);
            }
            finally {
                try {
                    this.bf.postInvoke(rctx);
                }
                catch (Exception e) {
                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)"exception on postInvoke: ", (Throwable)e);
                }
            }
        }
    }

    public Object lookup(String name) {
        try {
            return new InitialContext().lookup(JAVA_COMP_ENV + name);
        }
        catch (NamingException ne) {
            try {
                return new InitialContext().lookup(name);
            }
            catch (NamingException e) {
                throw new IllegalArgumentException("Lookup on '" + name + "' was not found");
            }
        }
    }

    public Map<String, Object> getContextData() {
        throw new UnsupportedOperationException("EJBs 2.1 do not support this operation.");
    }
}

