/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.naming;

import java.net.URL;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class URLFactory
implements ObjectFactory {
    protected static final String FACTORY_TYPE = "java.net.URL";

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String clname = ref.getClassName();
        if (!ref.getClassName().equals(FACTORY_TYPE)) {
            throw new Exception("Can not create object : required type is 'java.net.URL', but found type is '" + clname + "'.");
        }
        URL url = null;
        String urlString = (String)ref.get("url").getContent();
        if (urlString == null) {
            throw new Exception("Can not build an object as no URL was given.");
        }
        url = new URL(urlString);
        return url;
    }
}

