/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.logging.FaultListener;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

public class WebApplicationExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    private static final Logger LOG = LogUtils.getL7dLogger(WebApplicationExceptionMapper.class);
    private static final String ERROR_MESSAGE_START = "WebApplicationException has been caught, status: ";
    private boolean printStackTrace = true;
    private boolean addMessageToResponse;

    public Response toResponse(WebApplicationException ex) {
        String errorMessage;
        Response r = ex.getResponse();
        if (r == null) {
            r = Response.serverError().build();
        }
        boolean doAddMessage = r.getEntity() != null ? false : this.addMessageToResponse;
        Message msg = PhaseInterceptorChain.getCurrentMessage();
        FaultListener flogger = null;
        if (msg != null) {
            flogger = (FaultListener)PhaseInterceptorChain.getCurrentMessage().getContextualProperty(FaultListener.class.getName());
        }
        String string = errorMessage = doAddMessage || flogger != null ? this.buildErrorMessage(r, ex) : null;
        if (flogger == null || !flogger.faultOccurred((Exception)ex, errorMessage, msg)) {
            Level level = this.printStackTrace ? Level.WARNING : Level.FINE;
            LOG.log(level, WebApplicationExceptionMapper.getStackTrace((Exception)ex));
        }
        if (doAddMessage) {
            r = Response.fromResponse((Response)r).entity((Object)errorMessage).type("text/plain").build();
        }
        return r;
    }

    protected String buildErrorMessage(Response r, WebApplicationException ex) {
        String message;
        StringBuilder sb = new StringBuilder();
        sb.append(ERROR_MESSAGE_START).append(r.getStatus());
        Throwable cause = ex.getCause();
        String string = message = cause == null ? ex.getMessage() : cause.getMessage();
        if (message == null && cause != null) {
            message = "exception cause class: " + cause.getClass().getName();
        }
        if (message != null) {
            sb.append(", message: ").append(message);
        }
        return sb.toString();
    }

    private static String getStackTrace(Exception ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public void setPrintStackTrace(boolean printStackTrace) {
        this.printStackTrace = printStackTrace;
    }

    public void setAddMessageToResponse(boolean addMessageToResponse) {
        this.addMessageToResponse = addMessageToResponse;
    }
}

