/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.validator;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.validator.ServiceValidator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSParameter;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.WrapperElement;

public class WrapperStyleNameCollisionValidator
extends ServiceValidator {
    public static final Logger LOG = LogUtils.getL7dLogger(WrapperStyleNameCollisionValidator.class);

    public WrapperStyleNameCollisionValidator() {
    }

    public WrapperStyleNameCollisionValidator(ServiceInfo s) {
        this.service = s;
    }

    @Override
    public boolean isValid() {
        return this.checkNameCollision();
    }

    private boolean checkNameCollision() {
        InterfaceInfo interfaceInfo = this.service.getInterface();
        if (interfaceInfo != null) {
            for (OperationInfo operation : interfaceInfo.getOperations()) {
                if (this.isValidOperation(operation)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkArray(String[] ar, String n) {
        if (ar != null) {
            if (ar.length == 0) {
                return true;
            }
            for (String s : ar) {
                if (!s.equals(n)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkBare(ToolContext context, String opName) {
        String[] o = context.getArray("bareMethods");
        return this.checkArray(o, opName);
    }

    private boolean isValidOperation(OperationInfo operation) {
        ToolContext context = this.service.getProperty(ToolContext.class.getName(), ToolContext.class);
        boolean c = context.optionSet("autoNameResolution");
        boolean valid = false;
        if (operation.getUnwrappedOperation() == null) {
            valid = true;
        }
        String operationName = operation.getName().getLocalPart();
        operationName = ProcessorUtil.mangleNameToVariableName(operationName);
        JAXWSBinding binding = operation.getExtensor(JAXWSBinding.class);
        if (binding != null) {
            if (!binding.isEnableWrapperStyle()) {
                valid = true;
            } else if (binding.getMethodName() != null) {
                operationName = binding.getMethodName();
            }
        }
        if ((binding = operation.getInterface().getExtensor(JAXWSBinding.class)) != null) {
            if (!binding.isEnableWrapperStyle()) {
                valid = true;
            } else if (binding.getMethodName() != null) {
                operationName = binding.getMethodName();
            }
        }
        if ((binding = operation.getInterface().getService().getDescription().getExtensor(JAXWSBinding.class)) != null) {
            if (!binding.isEnableWrapperStyle()) {
                valid = true;
            } else if (binding.getMethodName() != null) {
                operationName = binding.getMethodName();
            }
        }
        if (valid |= this.checkBare(context, operationName)) {
            return true;
        }
        MessagePartInfo input = null;
        MessagePartInfo output = null;
        if (operation.getInput() != null && operation.getInput().getMessageParts().size() == 1) {
            input = operation.getInput().getMessageParts().iterator().next();
        }
        if (operation.getOutput() != null && operation.getOutput().getMessageParts().size() == 1) {
            output = operation.getOutput().getMessageParts().iterator().next();
        }
        if (!c) {
            List<WrapperElement> els;
            HashMap<String, QName> names = new HashMap<String, QName>();
            if (input != null) {
                for (WrapperElement element : ProcessorUtil.getWrappedElement(context, input.getElementQName())) {
                    String mappedName = this.mapElementName(operation, operation.getUnwrappedOperation().getInput(), element);
                    if (names.containsKey(mappedName) && (names.get(mappedName) == element.getSchemaTypeName() || ((QName)names.get(mappedName)).equals(element.getSchemaTypeName()))) {
                        this.handleErrors((QName)names.get(mappedName), element);
                        return false;
                    }
                    names.put(mappedName, element.getSchemaTypeName());
                }
            }
            if (output != null && (els = ProcessorUtil.getWrappedElement(context, output.getElementQName())).size() > 1) {
                for (WrapperElement element : els) {
                    String mappedName = this.mapElementName(operation, operation.getUnwrappedOperation().getOutput(), element);
                    if (names.containsKey(mappedName) && names.get(mappedName) != element.getSchemaTypeName() && !((QName)names.get(mappedName)).equals(element.getSchemaTypeName())) {
                        this.handleErrors((QName)names.get(mappedName), element);
                        return false;
                    }
                    names.put(mappedName, element.getSchemaTypeName());
                }
            }
        }
        return true;
    }

    private String mapElementName(OperationInfo op, MessageInfo mi, WrapperElement element) {
        MessagePartInfo mpi = mi.getMessagePart(element.getElementName());
        JAXWSBinding bind = op.getExtensor(JAXWSBinding.class);
        if (bind != null && bind.getJaxwsParas() != null) {
            for (JAXWSParameter par : bind.getJaxwsParas()) {
                if (!mi.getName().getLocalPart().equals(par.getMessageName()) || !mpi.getName().getLocalPart().equals(par.getElementName().getLocalPart())) continue;
                return par.getName();
            }
        }
        return mpi.getElementQName().getLocalPart();
    }

    private void handleErrors(QName e1, WrapperElement e2) {
        Message msg = new Message("WRAPPER_STYLE_NAME_COLLISION", LOG, e2.getElementName(), e1, e2.getSchemaTypeName());
        this.addErrorMessage(msg.toString());
    }
}

