/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.proxy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.proxy.SimpleInterceptionChain;
import org.jboss.weld.interceptor.reader.InterceptorMetadataUtils;
import org.jboss.weld.interceptor.spi.context.InterceptionChain;
import org.jboss.weld.interceptor.spi.context.InvocationContextFactory;
import org.jboss.weld.interceptor.spi.instance.InterceptorInstantiator;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.interceptor.util.InterceptionTypeRegistry;
import org.jboss.weld.interceptor.util.InterceptionUtils;
import org.jboss.weld.interceptor.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorMethodHandler
implements MethodHandler,
Serializable {
    private static final MethodHandler DEFAULT_METHOD_HANDLER = new MethodHandler(){

        public Object invoke(Object self, Method m, Method proceed, Object[] args) throws Exception {
            return proceed.invoke(self, args);
        }
    };
    private final Map<InterceptorMetadata<?>, Object> interceptorHandlerInstances = new HashMap();
    private InterceptorMetadata<ClassMetadata<?>> targetClassInterceptorMetadata;
    private InterceptionModel<ClassMetadata<?>, ?> interceptionModel;
    private final Object targetInstance;
    private final InvocationContextFactory invocationContextFactory;

    public InterceptorMethodHandler(Object targetInstance, ClassMetadata<?> targetClassMetadata, InterceptionModel<ClassMetadata<?>, ?> interceptionModel, InterceptorInstantiator<?, ?> interceptorInstantiator, InvocationContextFactory invocationContextFactory) {
        this.targetInstance = targetInstance;
        this.invocationContextFactory = invocationContextFactory;
        if (interceptionModel == null) {
            throw new IllegalArgumentException("Interception model must not be null");
        }
        if (interceptorInstantiator == null) {
            throw new IllegalArgumentException("Interception handler factory must not be null");
        }
        this.interceptionModel = interceptionModel;
        for (InterceptorMetadata<?> interceptorMetadata : this.interceptionModel.getAllInterceptors()) {
            this.interceptorHandlerInstances.put(interceptorMetadata, interceptorInstantiator.createFor(interceptorMetadata.getInterceptorReference()));
        }
        this.targetClassInterceptorMetadata = InterceptorMetadataUtils.readMetadataForTargetClass(targetClassMetadata);
    }

    protected boolean isProxy() {
        return this.targetInstance != null;
    }

    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        ReflectionUtils.ensureAccessible(thisMethod);
        if (proceed == null) {
            if (thisMethod.getName().equals("lifecycle_mixin_$$_postConstruct")) {
                return this.executeInterception(this.isProxy() ? null : self, null, null, null, InterceptionType.POST_CONSTRUCT);
            }
            if (thisMethod.getName().equals("lifecycle_mixin_$$_preDestroy")) {
                return this.executeInterception(this.isProxy() ? null : self, null, null, null, InterceptionType.PRE_DESTROY);
            }
        } else {
            if (!InterceptionUtils.isInterceptionCandidate(thisMethod)) {
                if (this.isProxy()) {
                    return thisMethod.invoke(this.targetInstance, args);
                }
                return proceed.invoke(self, args);
            }
            return this.executeInterception(this.isProxy() ? null : self, thisMethod, thisMethod, args, this.getInterceptionType(thisMethod));
        }
        return null;
    }

    private InterceptionType getInterceptionType(Method thisMethod) {
        if (InterceptionTypeRegistry.isSupported(InterceptionType.AROUND_TIMEOUT) && thisMethod.isAnnotationPresent(InterceptionTypeRegistry.getAnnotationClass(InterceptionType.AROUND_TIMEOUT))) {
            return InterceptionType.AROUND_TIMEOUT;
        }
        return InterceptionType.AROUND_INVOKE;
    }

    private Object executeInterception(Object self, Method proceedingMethod, Method thisMethod, Object[] args, InterceptionType interceptionType) throws Throwable {
        List<InterceptorMetadata<?>> interceptorList = this.interceptionModel.getInterceptors(interceptionType, thisMethod);
        ArrayList<InterceptorInvocation> interceptorInvocations = new ArrayList<InterceptorInvocation>();
        for (InterceptorMetadata<?> interceptorReference : interceptorList) {
            interceptorInvocations.add(interceptorReference.getInterceptorInvocation(this.interceptorHandlerInstances.get(interceptorReference), interceptorReference, interceptionType));
        }
        if (this.targetClassInterceptorMetadata != null && this.targetClassInterceptorMetadata.isEligible(interceptionType)) {
            interceptorInvocations.add(this.targetClassInterceptorMetadata.getInterceptorInvocation(this.isProxy() ? this.targetInstance : self, this.targetClassInterceptorMetadata, interceptionType));
        }
        SimpleInterceptionChain chain = new SimpleInterceptionChain(interceptorInvocations, this.isProxy() ? this.targetInstance : self, this.isProxy() ? thisMethod : proceedingMethod);
        return chain.invokeNextInterceptor(this.invocationContextFactory.newInvocationContext((InterceptionChain)chain, this.isProxy() ? this.targetInstance : self, this.isProxy() ? thisMethod : proceedingMethod, args));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            this.executeInterception(this.isProxy() ? this.targetInstance : null, null, null, null, InterceptionType.PRE_PASSIVATE);
            objectOutputStream.defaultWriteObject();
        }
        catch (Throwable throwable) {
            throw new IOException("Error while serializing class", throwable);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            if (this.isProxy() && this.targetInstance instanceof ProxyObject && ((ProxyObject)this.targetInstance).getHandler() == null) {
                ((ProxyObject)this.targetInstance).setHandler(DEFAULT_METHOD_HANDLER);
            }
            this.executeInterception(this.isProxy() ? this.targetInstance : null, null, null, null, InterceptionType.POST_ACTIVATE);
        }
        catch (Throwable throwable) {
            throw new IOException("Error while deserializing class", throwable);
        }
    }
}

