/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.pool;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PoolItemStats {
    private static int objcount = 1;
    private int ident;
    private long maxAgeTimeout = 0L;
    private long maxOpenTimeout = 0L;
    private long startTime = 0L;
    private long creationTime;
    private long totalConnectionTime = 0L;
    private int uses = 0;
    private List<Map<String, Object>> openerThreadInfos = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> closerThreadInfos = new ArrayList<Map<String, Object>>();

    public PoolItemStats() {
        this.creationTime = System.currentTimeMillis();
        this.ident = objcount++;
    }

    public int getIdent() {
        return this.ident;
    }

    public long getMaxAgeTimeout() {
        return this.maxAgeTimeout;
    }

    public void setMaxAgeTimeout(long pTime) {
        this.maxAgeTimeout = pTime;
    }

    public long getMaxOpenTimeout() {
        return this.maxOpenTimeout;
    }

    public void setMaxOpenTimeout(long pTime) {
        this.maxOpenTimeout = pTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long pTime) {
        this.startTime = pTime;
    }

    public long getTotalConnectionTime() {
        return this.totalConnectionTime;
    }

    public void setTotalConnectionTime(long pTime) {
        this.totalConnectionTime += pTime;
    }

    public int getUses() {
        return this.uses;
    }

    public void incrementUses() {
        ++this.uses;
    }

    public List<Map<String, Object>> getOpenerThreadInfos() {
        return this.openerThreadInfos;
    }

    public List<Map<String, Object>> getCloserThreadInfos() {
        return this.closerThreadInfos;
    }

    public void addOpenerThreadInfos() {
        this.openerThreadInfos.add(this.getThreadInfos());
    }

    public void addCloserThreadInfos() {
        this.closerThreadInfos.add(this.getThreadInfos());
    }

    private Map<String, Object> getThreadInfos() {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("thread.name", Thread.currentThread().getName());
        infos.put("thread.time", new Long(System.currentTimeMillis()));
        StringWriter str = new StringWriter();
        PrintWriter writer = new PrintWriter(str);
        new Throwable().printStackTrace(writer);
        infos.put("thread.stack", str.getBuffer().toString());
        return infos;
    }

    public String toString() {
        String out = "MaxAgeTimeout = " + this.maxAgeTimeout + "\nMaxOpenTimeout = " + this.maxOpenTimeout + "\nStartTime = " + this.startTime + "\nTotalConnectionTime = " + this.totalConnectionTime + "\nUses = " + this.uses;
        return out;
    }
}

