/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.dbm.internal.cm;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.dbm.internal.cm.JManagedConnection;
import org.ow2.jonas.lib.util.Log;

public class JConnection
implements InvocationHandler {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.dbm.con");
    private Connection physicalConnection = null;
    private JManagedConnection xaConnection = null;
    protected boolean checkclose = true;

    public JConnection(JManagedConnection xaConnection, Connection physicalConnection) {
        this.xaConnection = xaConnection;
        this.physicalConnection = physicalConnection;
    }

    public Connection getConnection() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.physicalConnection;
    }

    public boolean isPhysicallyClosed() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        return this.physicalConnection.isClosed();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
            return this.handleObjectMethods(method, args);
        }
        if ("getConnection".equals(method.getName())) {
            return this.getConnection();
        }
        if ("isClosed".equals(method.getName())) {
            return this.isClosed();
        }
        if ("isPhysicallyClosed".equals(method.getName())) {
            return this.isPhysicallyClosed();
        }
        if ("setCheckClose".equals(method.getName())) {
            this.setCheckClose((Boolean)args[0]);
            return null;
        }
        if ("close".equals(method.getName())) {
            this.xaConnection.notifyClose();
            return null;
        }
        if ("prepareStatement".equals(method.getName()) && method.getParameterTypes().length == 1) {
            try {
                return this.xaConnection.prepareStatement((String)args[0]);
            }
            catch (SQLException e) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Exception while calling method '" + method + "' on object '" + this.xaConnection + "'."), (Throwable)e);
                }
                this.xaConnection.notifyError(e);
                throw e;
            }
        }
        if (!method.getName().startsWith("get") && !method.getName().startsWith("set") && this.checkclose && this.isClosed()) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot work with a closed Connection");
            throw new SQLException("Cannot work with a closed Connection");
        }
        try {
            Class<?> physicalConnectionClass = this.physicalConnection.getClass();
            Class<?> methodClass = method.getDeclaringClass();
            if (methodClass.isAssignableFrom(physicalConnectionClass)) {
                return method.invoke((Object)this.physicalConnection, args);
            }
            throw new IllegalArgumentException("Proxy error: the physical connection (class: " + physicalConnectionClass.getName() + ") cannot be cast to a " + methodClass.getName());
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof SQLException) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Exception while calling method '" + method + "' on object '" + this.physicalConnection + "'."));
                }
                this.xaConnection.notifyError((SQLException)targetException);
            }
            throw targetException;
        }
    }

    protected Object handleObjectMethods(Method method, Object[] args) {
        String methodName = method.getName();
        if (methodName.equals("equals")) {
            if (Proxy.isProxyClass(args[0].getClass())) {
                return this.equals(Proxy.getInvocationHandler(args[0]));
            }
            return this.equals(args[0]);
        }
        if (methodName.equals("toString")) {
            return this.toString();
        }
        if (methodName.equals("hashCode")) {
            return this.hashCode();
        }
        throw new IllegalStateException("Method '" + methodName + "' is not present on Object.class.");
    }

    public void setCheckClose(boolean cc) {
        this.checkclose = cc;
    }

    public boolean isClosed() throws SQLException {
        return this.xaConnection.isClosed();
    }
}

