/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.helper;

import java.util.Arrays;
import javax.naming.Context;
import javax.naming.NamingException;
import org.ow2.easybeans.api.EZBContainerConfig;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.helper.JavaContextHelperException;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarFieldMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.event.naming.JavaContextNamingEvent;
import org.ow2.easybeans.naming.NamingManager;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarMethodMetadata;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaContextHelper {
    private static Log logger = LogFactory.getLog(JavaContextHelper.class);
    private static final int LENGTH = "get".length();

    private JavaContextHelper() {
    }

    public static Context build(EasyBeansEjbJarClassMetadata bean, Factory<?, ?> easyBeansFactory, IEventDispatcher dispatcher, EZBContainerConfig containerConfig) throws JavaContextHelperException {
        Context javaCtx = null;
        try {
            javaCtx = NamingManager.getInstance().createEnvironmentContext(bean.getClassName(), containerConfig.getEnvContext(), containerConfig.getModuleContext(), containerConfig.getAppContext());
        }
        catch (NamingException e) {
            throw new IllegalStateException("Cannot build a new environment", e);
        }
        JavaContextNamingEvent event = new JavaContextNamingEvent("java:", javaCtx, easyBeansFactory, bean);
        dispatcher.dispatch((IEvent)event);
        if (!event.getThrowables().isEmpty()) {
            throw new JavaContextHelperException("Cannot fill java:", event.getThrowables().get(0));
        }
        return javaCtx;
    }

    public static String getJndiName(String jndiName, EasyBeansEjbJarFieldMetadata fieldAnnotationMetadata) {
        String newJndiName = jndiName;
        if (jndiName == null || "".equals(jndiName)) {
            logger.debug((Object)"Name property undefined.", new Object[0]);
            String descriptor = ((EasyBeansEjbJarClassMetadata)fieldAnnotationMetadata.getClassMetadata()).getJClass().getName();
            newJndiName = descriptor.replace("/", ".") + "/" + fieldAnnotationMetadata.getFieldName();
            logger.debug((Object)"Getting environment's entry with default JNDI name: {0}", new Object[]{newJndiName});
        }
        return newJndiName;
    }

    public static String getJndiName(String jndiName, EasyBeansEjbJarMethodMetadata methodMetaData) {
        String newJndiName = jndiName;
        if (jndiName == null || "".equals(jndiName)) {
            logger.debug((Object)"Property name not defined.", new Object[0]);
            StringBuilder propertyBuilder = new StringBuilder(methodMetaData.getMethodName());
            propertyBuilder.delete(0, LENGTH);
            propertyBuilder.setCharAt(0, Character.toLowerCase(propertyBuilder.charAt(0)));
            String descriptor = ((EasyBeansEjbJarClassMetadata)methodMetaData.getClassMetadata()).getJClass().getName();
            propertyBuilder.insert(0, descriptor.replace("/", ".") + "/");
            newJndiName = propertyBuilder.toString();
            logger.debug((Object)"Getting environment's entry with default JNDI name: {0}", new Object[]{newJndiName});
        }
        return newJndiName;
    }

    public static Type getSetterMethodType(IEjbJarMethodMetadata methodMetaData) {
        JMethod jMethod = methodMetaData.getJMethod();
        if (!jMethod.getName().startsWith("set") || jMethod.getName().equalsIgnoreCase("set")) {
            throw new IllegalStateException("Method '" + jMethod + "' is invalid. Should be in the setter form setXXX().");
        }
        Type[] args = Type.getArgumentTypes(jMethod.getDescriptor());
        if (args.length != 1) {
            throw new IllegalStateException("Method args '" + Arrays.asList(args) + "' for method '" + jMethod + "' are invalid. Length should be of 1.");
        }
        return args[0];
    }
}

