/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.server;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.ow2.easybeans.api.EZBConfigurationExtension;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerConfig;
import org.ow2.easybeans.api.EZBJ2EEManagedObject;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.EZBServerConfig;
import org.ow2.easybeans.api.EasyBeansInterceptor;
import org.ow2.easybeans.api.EmbeddedManager;
import org.ow2.easybeans.api.pool.EZBManagementPool;
import org.ow2.easybeans.component.ComponentManager;
import org.ow2.easybeans.component.Components;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.itf.EZBDepMonitorComponent;
import org.ow2.easybeans.component.itf.EZBEventComponent;
import org.ow2.easybeans.component.itf.EZBStatisticComponent;
import org.ow2.easybeans.component.itf.RegistryComponent;
import org.ow2.easybeans.container.JContainer3;
import org.ow2.easybeans.container.JContainerConfig;
import org.ow2.easybeans.deployer.EasyBeansDeployer;
import org.ow2.easybeans.deployer.IRemoteDeployer;
import org.ow2.easybeans.deployer.RemoteDeployer;
import org.ow2.easybeans.deployment.EasyBeansDeployableInfo;
import org.ow2.easybeans.deployment.api.EZBDeployableInfo;
import org.ow2.easybeans.deployment.helper.listener.EnvEntriesExtensionListener;
import org.ow2.easybeans.deployment.helper.listener.JavaCompExtensionListener;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStarted;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStarting;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStopped;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStopping;
import org.ow2.easybeans.jmx.CommonsModelerException;
import org.ow2.easybeans.jmx.CommonsModelerHelper;
import org.ow2.easybeans.jmx.JMXRemoteException;
import org.ow2.easybeans.jmx.JMXRemoteHelper;
import org.ow2.easybeans.jmx.MBeanServerException;
import org.ow2.easybeans.jmx.MBeanServerHelper;
import org.ow2.easybeans.jmx.MBeansException;
import org.ow2.easybeans.jmx.MBeansHelper;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.resolver.ServerJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBServerJNDIResolver;
import org.ow2.easybeans.rpc.api.RMIServerRPC;
import org.ow2.easybeans.rpc.rmi.server.RMIServerRPCImpl;
import org.ow2.easybeans.security.jacc.PolicyProvider;
import org.ow2.easybeans.server.EmbeddedConfigurator;
import org.ow2.easybeans.server.EmbeddedException;
import org.ow2.easybeans.server.ServerConfig;
import org.ow2.easybeans.server.Version;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.impl.deployer.DeployerManager;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.impl.EventDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Embedded
implements EZBServer {
    private static final int SLEEP_VALUE = 10000;
    public static final String CORE_XML_FILE = "org/ow2/easybeans/server/easybeans-core.xml";
    public static final String DEFAULT_DEPLOY_DIRECTORY = "easybeans-deploy";
    public static final String DEPRECATED_DEFAULT_DEPLOY_DIRECTORY = "ejb3s";
    private static Log logger = LogFactory.getLog(Embedded.class);
    private static int counter = 0;
    private Integer id = counter++;
    private EZBServerConfig serverConfig = null;
    private Map<String, EZBContainer> containers = new ConcurrentHashMap<String, EZBContainer>();
    private RemoteDeployer deployer = null;
    private Components components = null;
    private ComponentManager componentManager = null;
    private EZBManagementPool managementThreadPool;
    private boolean started = false;
    private boolean stopped = false;
    private boolean stopping = false;
    private RMIServerRPC invoker = null;
    private EZBServerJNDIResolver jndiResolver = null;
    private IDeployerManager deployerManager = null;
    private IEventDispatcher dispatcher = null;
    private String j2eeManagedObjectId = null;
    private List<IEventListener> defaultNamingExtensions;
    private boolean componentsInitialized = false;
    private boolean componentsRegistered = false;
    private List<Class<? extends EasyBeansInterceptor>> globalInterceptorsClasses = null;
    private InitialContext context = null;

    public Embedded() {
        this.serverConfig = new ServerConfig();
        this.globalInterceptorsClasses = new ArrayList<Class<? extends EasyBeansInterceptor>>();
        this.defaultNamingExtensions = new ArrayList<IEventListener>();
        this.defaultNamingExtensions.add(new JavaCompExtensionListener());
        this.defaultNamingExtensions.add(new EnvEntriesExtensionListener());
        this.jndiResolver = new ServerJNDIResolver();
        EmbeddedManager.addEmbedded((EZBServer)this);
        this.components = new Components();
        this.componentManager = new ComponentManager(this.components);
        this.j2eeManagedObjectId = J2EEManagedObjectNamingHelper.getJ2EEManagedObjectId(this);
    }

    public void start() throws EmbeddedException {
        EZBStatisticComponent statisticComponent;
        this.stopping = false;
        long tStart = System.currentTimeMillis();
        if (this.deployerManager == null) {
            this.deployerManager = new DeployerManager();
            EasyBeansDeployer easyBeansDeployer = new EasyBeansDeployer();
            easyBeansDeployer.setEmbedded(this);
            this.deployerManager.register((IDeployer)easyBeansDeployer);
        }
        if (!this.componentsInitialized) {
            if (this.serverConfig.addEmbeddedComponents()) {
                this.serverConfig.getConfigurationURLs().addFirst(Thread.currentThread().getContextClassLoader().getResource(CORE_XML_FILE));
            }
            try {
                if (!this.serverConfig.getConfigurationURLs().isEmpty()) {
                    logger.info((Object)"Configuring EasyBeans with the configuration URLs ''{0}''", new Object[]{this.serverConfig.getConfigurationURLs()});
                }
                EmbeddedConfigurator.init(this, this.serverConfig.getConfigurationURLs(), this.serverConfig.getConfigurationMap());
            }
            catch (EmbeddedException e) {
                throw new EmbeddedException("Cannot configure the embedded server", (Throwable)((Object)e));
            }
            this.componentsInitialized = true;
        }
        if (this.serverConfig.initJACC()) {
            PolicyProvider.init();
        }
        this.configureDeploy();
        if (this.serverConfig.isUsingNaming()) {
            System.setProperty("java.naming.factory.url.pkgs", "org.ow2.easybeans.naming.pkg");
        }
        try {
            this.deployer = new RemoteDeployer(this);
        }
        catch (DeployerException e) {
            throw new EmbeddedException("Cannot build a remote deployer.", e);
        }
        MBeansHelper.getInstance().activate(this.serverConfig.isUsingMBeans());
        if (this.serverConfig.isUsingMBeans()) {
            try {
                CommonsModelerHelper.initRegistry();
            }
            catch (CommonsModelerException e) {
                throw new EmbeddedException("Cannot init MBean server", e);
            }
            try {
                MBeanServerHelper.startMBeanServer();
            }
            catch (MBeanServerException e) {
                throw new EmbeddedException("Cannot start MBean server", e);
            }
        }
        if (this.serverConfig.isAutoConfigureComponents()) {
            try {
                this.componentManager.initComponents(!this.componentsRegistered);
            }
            catch (EZBComponentException e) {
                throw new EmbeddedException("Cannot init components", e);
            }
            this.componentsRegistered = true;
            try {
                this.componentManager.startComponents();
            }
            catch (EZBComponentException e) {
                throw new EmbeddedException("Cannot start components", e);
            }
        }
        this.dispatcher = new EventDispatcher();
        this.dispatcher.start();
        EZBEventComponent eventComponent = this.getComponent(EZBEventComponent.class);
        if (eventComponent != null) {
            eventComponent.registerJ2EEManagedObject((EZBJ2EEManagedObject)this, this.dispatcher);
        }
        if ((statisticComponent = this.getComponent(EZBStatisticComponent.class)) != null) {
            statisticComponent.registerJ2EEManagedObject((EZBJ2EEManagedObject)this);
        }
        if (eventComponent != null) {
            for (IEventListener extension : this.defaultNamingExtensions) {
                eventComponent.getEventService().registerListener(extension, "/easybeans/container/factory/context");
            }
        }
        this.dispatcher.dispatch((IEvent)new EventLifeCycleStarting(this.j2eeManagedObjectId));
        if (this.serverConfig.isUsingMBeans()) {
            if (this.serverConfig.isStartJMXConnector()) {
                try {
                    JMXRemoteHelper.startConnector((RegistryComponent)this.getComponent("org.ow2.easybeans.component.carol.CarolComponent"));
                }
                catch (JMXRemoteException e) {
                    throw new EmbeddedException("Cannot start JMX Remote connector", e);
                }
            }
            if (this.serverConfig.isRegisterDeployerMBean()) {
                try {
                    MBeansHelper.getInstance().registerMBean(this.deployer);
                }
                catch (MBeansException e) {
                    throw new EmbeddedException("Cannot init MBeans", e);
                }
            }
            if (this.serverConfig.isRegisterJ2EEServerMBean()) {
                try {
                    MBeansHelper.getInstance().registerMBean(this);
                }
                catch (MBeansException e) {
                    throw new EmbeddedException("Cannot init MBeans", e);
                }
            }
        }
        try {
            this.invoker = new RMIServerRPCImpl(this);
        }
        catch (RemoteException e) {
            throw new EmbeddedException("Cannot build RPC invoker", e);
        }
        try {
            this.context = new InitialContext();
        }
        catch (NamingException e) {
            throw new EmbeddedException("Cannot make initial context", e);
        }
        try {
            this.context.rebind("RMI_SERVER_RPC", (Object)this.invoker);
        }
        catch (NamingException e) {
            throw new EmbeddedException("Cannot bind the RPC invoker", e);
        }
        logger.info((Object)"Embedded.start.startup", new Object[]{Version.getVersion(), System.currentTimeMillis() - tStart});
        logger.debug((Object)"Embedded.start.created", new Object[]{this.containers.size()});
        this.dispatcher.dispatch((IEvent)new EventLifeCycleStarted(this.j2eeManagedObjectId));
        this.started = true;
        EZBDepMonitorComponent depMonitorComponent = this.getComponent(EZBDepMonitorComponent.class);
        if (depMonitorComponent != null) {
            try {
                depMonitorComponent.enable();
            }
            catch (EZBComponentException e) {
                logger.error((Object)"Cannot enable callback on depmonitor component", new Object[]{e});
            }
        }
        if (this.serverConfig.shouldWait()) {
            logger.info((Object)"Embedded.start.waiting", new Object[0]);
            while (this.started) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)"Cannot sleep in the thread", new Object[]{e});
                }
            }
        }
    }

    public synchronized void stop() throws EmbeddedException {
        EZBEventComponent eventComponent;
        if (!this.started) {
            throw new EmbeddedException("Cannot stop the server as it is not started.");
        }
        this.stopping = true;
        if (this.dispatcher != null) {
            this.dispatcher.dispatch((IEvent)new EventLifeCycleStopping(this.j2eeManagedObjectId));
        }
        ArrayList<EZBContainer> containersList = new ArrayList<EZBContainer>(this.containers.values());
        ListIterator li = containersList.listIterator();
        while (li.hasNext()) {
            EZBContainer container = (EZBContainer)li.next();
            container.stop();
            this.removeContainer(container);
        }
        if (this.serverConfig.isUsingMBeans()) {
            if (this.serverConfig.isStartJMXConnector()) {
                try {
                    JMXRemoteHelper.stopConnector();
                }
                catch (JMXRemoteException e) {
                    logger.debug((Object)"Cannot stop JMX Remote connector", new Object[]{e});
                }
            }
            if (this.serverConfig.isRegisterDeployerMBean()) {
                try {
                    MBeansHelper.getInstance().unregisterMBean(this.deployer);
                }
                catch (MBeansException e) {
                    logger.error((Object)"Cannot unregister Deployer MBean", new Object[]{e});
                }
            }
            if (this.serverConfig.isRegisterJ2EEServerMBean()) {
                try {
                    MBeansHelper.getInstance().unregisterMBean(this);
                }
                catch (MBeansException e) {
                    logger.error((Object)"Cannot unregister Embedded MBean", new Object[]{e});
                }
            }
        }
        try {
            new InitialContext().unbind("RMI_SERVER_RPC");
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot unbind the RPC invoker", new Object[]{e});
        }
        try {
            PortableRemoteObject.unexportObject((Remote)this.invoker);
        }
        catch (NoSuchObjectException e) {
            logger.error((Object)"Cannot unexport RPC invoker", new Object[]{e});
        }
        this.dispatcher.dispatch((IEvent)new EventLifeCycleStopped(this.j2eeManagedObjectId));
        EZBStatisticComponent statisticComponent = this.getComponent(EZBStatisticComponent.class);
        if (statisticComponent != null) {
            statisticComponent.unregisterJ2EEManagedObject((EZBJ2EEManagedObject)this);
        }
        if ((eventComponent = this.getComponent(EZBEventComponent.class)) != null) {
            eventComponent.unregisterJ2EEManagedObject((EZBJ2EEManagedObject)this);
            for (IEventListener extension : this.defaultNamingExtensions) {
                eventComponent.getEventService().unregisterListener(extension);
            }
        }
        this.dispatcher.stop();
        this.dispatcher = null;
        if (this.serverConfig.isStopComponentsDuringShutdown()) {
            this.componentManager.stopComponents();
        }
        if (this.serverConfig.initJACC()) {
            try {
                PolicyProvider.stop();
            }
            catch (Exception e) {
                logger.error((Object)"Unable to stop the JACC provider", new Object[]{e});
            }
        }
        logger.info((Object)"Embedded.stop.stopped", new Object[]{Version.getVersion()});
        this.started = false;
        this.stopped = true;
        this.stopping = false;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        if (this.started) {
            logger.debug((Object)"Cannot set the server configuration when server has been started.", new Object[0]);
            return;
        }
        this.serverConfig = serverConfig;
    }

    public EZBContainer getContainer(String id) {
        return this.containers.get(id);
    }

    public EZBContainer findContainer(IArchive archive) {
        if (archive == null) {
            return null;
        }
        for (EZBContainer container : this.containers.values()) {
            if (!archive.equals(container.getArchive())) continue;
            return container;
        }
        return null;
    }

    protected void configureDeploy() throws EmbeddedException {
        List depMonitorComponents;
        if (this.serverConfig.isDirectoryScanningEnabled() && ((depMonitorComponents = this.componentManager.getComponentRegistry().getComponents(EZBDepMonitorComponent.class)) == null || depMonitorComponents.size() == 0)) {
            logger.warn((Object)"Directory monitoring is now managed by a component and shouldn''t be set through a server-config property. A <depmonitor> component needs to be added.", new Object[0]);
        }
    }

    public EZBContainer createContainer(IDeployable<?> deployable) {
        EZBContainerConfig readContainerConfig;
        EZBContainerConfig jConfig = null;
        EZBDeployableInfo deployableInfo = (EZBDeployableInfo)deployable.getExtension(EasyBeansDeployableInfo.class);
        if (deployableInfo != null && (readContainerConfig = deployableInfo.getContainerConfiguration()) != null) {
            jConfig = readContainerConfig;
        }
        if (jConfig == null) {
            jConfig = new JContainerConfig(deployable);
        }
        jConfig.setEZBServer((EZBServer)this);
        JContainer3 container = new JContainer3(jConfig);
        this.addContainer(container);
        return container;
    }

    public void addContainer(EZBContainer container) {
        this.callJContainerConfigExtensions(container.getConfiguration());
        String id = container.getId();
        this.containers.put(id, container);
    }

    public void removeContainer(EZBContainer container) {
        this.containers.remove(container.getId());
        logger.info((Object)"Container ''{0}'' removed", new Object[]{container.getArchive().getName()});
    }

    private void callJContainerConfigExtensions(EZBContainerConfig jcc) {
        for (EZBConfigurationExtension extension : this.serverConfig.getExtensionFactories()) {
            try {
                extension.configure(jcc);
            }
            catch (Throwable t) {
                logger.info((Object)"Failed to configure JContainerConfig with {0}", new Object[]{extension.getClass().getName()});
            }
        }
    }

    public EZBServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public Map<String, EZBContainer> getContainers() {
        return this.containers;
    }

    public Integer getID() {
        return this.id;
    }

    public String getDescription() {
        return this.serverConfig.getDescription();
    }

    public IRemoteDeployer getDeployer() {
        return this.deployer;
    }

    public Components getComponents() {
        return this.components;
    }

    public void setComponents(Components components) {
        this.components = components;
    }

    public EZBComponent getComponent(String componentName) {
        if (this.componentManager != null) {
            return this.componentManager.getComponent(componentName);
        }
        return null;
    }

    public <T extends EZBComponent> T getComponent(Class<T> itf) {
        if (this.componentManager != null) {
            return this.componentManager.getComponent(itf);
        }
        return null;
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isStarted() {
        return this.started;
    }

    public EZBServerJNDIResolver getJNDIResolver() {
        return this.jndiResolver;
    }

    public String getJ2EEManagedObjectId() {
        return this.j2eeManagedObjectId;
    }

    public IEventDispatcher getEventDispatcher() {
        return this.dispatcher;
    }

    public IDeployerManager getDeployerManager() {
        return this.deployerManager;
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public List<Class<? extends EasyBeansInterceptor>> getGlobalInterceptorsClasses() {
        return this.globalInterceptorsClasses;
    }

    public EZBManagementPool getManagementThreadPool() {
        return this.managementThreadPool;
    }

    public void setManagementThreadPool(EZBManagementPool managementThreadPool) {
        this.managementThreadPool = managementThreadPool;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public Context getContext() {
        return this.context;
    }
}

