/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.transaction.interceptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.SessionSynchronization;
import org.ow2.easybeans.api.bean.info.IMethodInfo;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionSynchronizationWrapper
implements SessionSynchronization {
    private Log logger = LogFactory.getLog(SessionSynchronizationWrapper.class);
    private Object wrappedBean = null;
    private Method afterBeginMethod = null;
    private Method beforeCompletionMethod = null;
    private Method afterCompletionMethod = null;

    public SessionSynchronizationWrapper(Object wrappedBean, List<IMethodInfo> synchroMethodsInfoList) {
        this.wrappedBean = wrappedBean;
        for (IMethodInfo methodInfo : synchroMethodsInfoList) {
            if (methodInfo.isAfterBegin()) {
                this.afterBeginMethod = this.getMethod(wrappedBean, methodInfo);
            }
            if (methodInfo.isBeforeCompletion()) {
                this.beforeCompletionMethod = this.getMethod(wrappedBean, methodInfo);
            }
            if (!methodInfo.isAfterCompletion()) continue;
            this.afterCompletionMethod = this.getMethod(wrappedBean, methodInfo);
        }
    }

    private Method getMethod(Object wrappedBean, IMethodInfo methodInfo) {
        Class[] params = null;
        if (methodInfo.isAfterCompletion()) {
            params = new Class[]{Boolean.TYPE};
        }
        Method m = null;
        try {
            m = wrappedBean.getClass().getDeclaredMethod(methodInfo.getName(), params);
        }
        catch (SecurityException e) {
            this.logger.error((Object)("Unable to get callback method '" + methodInfo.getName() + "' in the class '" + wrappedBean.getClass() + "'."), new Object[]{e});
        }
        catch (NoSuchMethodException e) {
            try {
                m = wrappedBean.getClass().getMethod(methodInfo.getName(), params);
            }
            catch (SecurityException e1) {
                this.logger.error((Object)("Unable to get callback method '" + methodInfo.getName() + "' in the class '" + wrappedBean.getClass() + "'."), new Object[]{e});
            }
            catch (NoSuchMethodException e1) {
                this.logger.debug((Object)("Unable to get callback method '" + methodInfo.getName() + "' in the class '" + wrappedBean.getClass() + "'."), new Object[]{e});
            }
        }
        return m;
    }

    private void invoke(Method m, Object ... params) {
        if (m == null) {
            return;
        }
        boolean accessible = m.isAccessible();
        try {
            try {
                m.setAccessible(true);
                m.invoke(this.wrappedBean, params);
            }
            catch (IllegalArgumentException e) {
                throw new EJBException("Exception on a SessionSynchronization callback", (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new EJBException("Exception on a SessionSynchronization callback", (Exception)e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof Exception) {
                    throw new EJBException("Exception on a SessionSynchronization callback", (Exception)t);
                }
                throw new EJBException("Exception on a SessionSynchronization callback", new Exception(t));
            }
            Object var7_4 = null;
            m.setAccessible(accessible);
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            m.setAccessible(accessible);
            throw throwable;
        }
    }

    public void afterBegin() throws EJBException, RemoteException {
        this.invoke(this.afterBeginMethod, new Object[0]);
    }

    public void beforeCompletion() throws EJBException, RemoteException {
        this.invoke(this.beforeCompletionMethod, new Object[0]);
    }

    public void afterCompletion(boolean committed) throws EJBException, RemoteException {
        this.invoke(this.afterCompletionMethod, committed);
    }
}

