/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf.jaxws;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.EndpointImpl;
import org.ow2.jonas.ws.cxf.http.JOnASDestination;
import org.ow2.jonas.ws.cxf.jaxws.WebservicesContainer;
import org.ow2.jonas.ws.jaxws.IWSRequest;
import org.ow2.jonas.ws.jaxws.IWSResponse;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortIdentifier;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CXFWSEndpoint
implements IWebServiceEndpoint {
    private static Log logger = LogFactory.getLog(CXFWSEndpoint.class);
    private EndpointImpl endpoint = null;
    private JOnASDestination destination = null;
    private PortMetaData portMetaData;
    private IWebServiceEndpoint.EndpointType type;
    private WebservicesContainer container;
    private PortIdentifier identifier;

    public CXFWSEndpoint(EndpointImpl endpoint, IWebServiceEndpoint.EndpointType type, PortMetaData pmd, WebservicesContainer container) {
        this.endpoint = endpoint;
        this.type = type;
        this.portMetaData = pmd;
        this.destination = (JOnASDestination)endpoint.getServer(pmd.getUrlPattern()).getDestination();
        this.container = container;
        this.identifier = new PortIdentifier(endpoint.getServiceName(), endpoint.getEndpointName().getLocalPart());
    }

    public IWebServiceEndpoint.EndpointType getType() {
        return this.type;
    }

    public PortIdentifier getIdentifier() {
        return this.identifier;
    }

    public void invoke(IWSRequest request, IWSResponse response) throws WSException {
        logger.debug((Object)"Receiving request on the thread ''{0}''", new Object[]{Thread.currentThread()});
        Bus old = BusFactory.getThreadDefaultBus();
        try {
            Bus bus = this.destination.getBus();
            BusFactory.setThreadDefaultBus((Bus)bus);
            HttpServletRequest httpRequest = (HttpServletRequest)request.getAttribute(HttpServletRequest.class);
            HttpServletResponse httpResponse = (HttpServletResponse)request.getAttribute(HttpServletResponse.class);
            ServletContext servletContext = (ServletContext)request.getAttribute(ServletContext.class);
            this.destination.invoke(servletContext, httpRequest, httpResponse);
        }
        catch (IOException ioe) {
            throw new WSException((Throwable)ioe);
        }
        finally {
            BusFactory.setThreadDefaultBus((Bus)old);
        }
    }

    public void start() {
        logger.debug((Object)"Start CXFWSEndpoint[{0}]", new Object[]{this.endpoint.getEndpointName()});
        this.endpoint.publish();
    }

    public void stop() {
        logger.debug((Object)"Stop CXFWSEndpoint[{0}]", new Object[]{this.endpoint.getEndpointName()});
        this.endpoint.stop();
    }

    public PortMetaData getPortMetaData() {
        return this.portMetaData;
    }

    public JOnASDestination getDestination() {
        return this.destination;
    }

    public void displayInfos() {
        String endpointURL = "not yet available";
        String name = this.endpoint.getImplementorClass().getName();
        if (this.portMetaData != null && this.portMetaData.getEndpointURL() != null) {
            endpointURL = this.portMetaData.getEndpointURL();
        }
        logger.info((Object)"{0} endpoint ''{1}'' available at ''{2}''", new Object[]{this.type, name, endpointURL});
    }
}

