/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf.util;

import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import org.ow2.jonas.ws.cxf.jaxws.WebservicesContainer;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortIdentifier;

public class WSDLUtils {
    public static void updateEndpointAddresses(Definition definition, WebservicesContainer<? extends IWebServiceEndpoint> container) {
        for (IWebServiceEndpoint endpoint : container.getEndpoints()) {
            String url;
            Port port;
            PortIdentifier id = endpoint.getIdentifier();
            QName serviceName = id.getServiceName();
            String portName = id.getPortName();
            Service service = definition.getService(serviceName);
            if (service == null || (port = service.getPort(portName)) == null || (url = container.findUpdatedURL(id)) == null) continue;
            WSDLUtils.updateSoapAddressLocation(port, url);
        }
    }

    private static void updateSoapAddressLocation(Port port, String url) {
        List extensions = port.getExtensibilityElements();
        for (Object extension : extensions) {
            if (extension instanceof SOAP12Address) {
                ((SOAP12Address)extension).setLocationURI(url);
                continue;
            }
            if (!(extension instanceof SOAPAddress)) continue;
            ((SOAPAddress)extension).setLocationURI(url);
        }
    }
}

