/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.mejb;

import java.util.ArrayList;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.security.RolesAllowed;
import javax.ejb.RemoteHome;
import javax.ejb.Stateless;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.j2ee.ListenerRegistration;
import javax.management.j2ee.ManagementHome;
import org.ow2.jonas.ee.mejb.ListenerRegistrationImpl;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Stateless(name="MEJB", mappedName="ejb/mgmt/MEJB")
@RemoteHome(value=ManagementHome.class)
@RolesAllowed(value={"mejb-admin", "mejb-user"})
public class ManagementBean {
    private static final Log logger = LogFactory.getLog(ManagementBean.class);
    private MBeanServer mbeanServer = null;

    @PostConstruct
    public void init() {
        ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(null);
        if (mbeanServers.size() > 0) {
            this.mbeanServer = (MBeanServer)mbeanServers.get(0);
        } else {
            logger.debug((Object)"Cannot find the default MBeanServer for the platform, create a new one.", new Object[0]);
            this.mbeanServer = MBeanServerFactory.createMBeanServer();
        }
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.mbeanServer.getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbeanServer.getAttributes(name, attributes);
    }

    public String getDefaultDomain() {
        return this.mbeanServer.getDefaultDomain();
    }

    public Integer getMBeanCount() {
        return this.mbeanServer.getMBeanCount();
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws IntrospectionException, InstanceNotFoundException, ReflectionException {
        return this.mbeanServer.getMBeanInfo(name);
    }

    @RolesAllowed(value={"mejb-admin"})
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws MBeanException, InstanceNotFoundException, ReflectionException {
        return this.mbeanServer.invoke(name, operationName, params, signature);
    }

    public boolean isRegistered(ObjectName name) {
        return this.mbeanServer.isRegistered(name);
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        return this.mbeanServer.queryNames(name, query);
    }

    @RolesAllowed(value={"mejb-admin"})
    public void setAttribute(ObjectName name, Attribute attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, ReflectionException {
        this.mbeanServer.setAttribute(name, attribute);
    }

    @RolesAllowed(value={"mejb-admin"})
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbeanServer.setAttributes(name, attributes);
    }

    public ListenerRegistration getListenerRegistry() {
        return new ListenerRegistrationImpl(this.mbeanServer);
    }
}

