/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.DefaultRetransmitter;
import org.jgroups.stack.Interval;
import org.jgroups.stack.RangeBasedRetransmitter;
import org.jgroups.stack.Retransmitter;
import org.jgroups.util.RetransmitTable;
import org.jgroups.util.TimeScheduler;

public class NakReceiverWindow {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile boolean running = true;
    private long low = 0L;
    private long highest_delivered = 0L;
    private long highest_received = 0L;
    private final RetransmitTable xmit_table;
    private final AtomicBoolean processing = new AtomicBoolean(false);
    private Retransmitter retransmitter = null;
    private Listener listener = null;
    protected static final Log log = LogFactory.getLog(NakReceiverWindow.class);
    long highest_stability_seqno = 0L;
    private double smoothed_loss_rate = 0.0;

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long highest_delivered_seqno, long lowest_seqno, TimeScheduler sched) {
        this(sender, cmd, highest_delivered_seqno, lowest_seqno, sched, true);
    }

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long highest_delivered_seqno, long lowest_seqno, TimeScheduler sched, boolean use_range_based_retransmitter) {
        this(sender, cmd, highest_delivered_seqno, lowest_seqno, sched, use_range_based_retransmitter, 5, 10000, 1.2, 300000L, false);
    }

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long highest_delivered_seqno, long lowest_seqno, TimeScheduler sched, boolean use_range_based_retransmitter, int num_rows, int msgs_per_row, double resize_factor, long max_compaction_time, boolean automatic_purging) {
        this.highest_received = this.highest_delivered = highest_delivered_seqno;
        this.low = Math.min(lowest_seqno, this.highest_delivered);
        if (sched == null) {
            throw new IllegalStateException("timer has to be provided and cannot be null");
        }
        if (cmd != null) {
            this.retransmitter = use_range_based_retransmitter ? new RangeBasedRetransmitter(sender, cmd, sched) : new DefaultRetransmitter(sender, cmd, sched);
        }
        this.xmit_table = new RetransmitTable(num_rows, msgs_per_row, this.low, resize_factor, max_compaction_time, automatic_purging);
    }

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long highest_delivered_seqno, TimeScheduler sched) {
        this(sender, cmd, highest_delivered_seqno, 0L, sched);
    }

    public AtomicBoolean getProcessing() {
        return this.processing;
    }

    public void setRetransmitTimeouts(Interval timeouts) {
        this.retransmitter.setRetransmitTimeouts(timeouts);
    }

    @Deprecated
    public void setDiscardDeliveredMessages(boolean flag) {
    }

    @Deprecated
    public int getMaxXmitBufSize() {
        return 0;
    }

    @Deprecated
    public void setMaxXmitBufSize(int max_xmit_buf_size) {
    }

    public void setListener(Listener l) {
        this.listener = l;
    }

    public int getPendingXmits() {
        return this.retransmitter != null ? this.retransmitter.size() : 0;
    }

    public double getLossRate() {
        int total_msgs = this.size();
        int pending_xmits = this.getPendingXmits();
        if (pending_xmits == 0 || total_msgs == 0) {
            return 0.0;
        }
        return (double)pending_xmits / (double)total_msgs;
    }

    public double getSmoothedLossRate() {
        return this.smoothed_loss_rate;
    }

    private void setSmoothedLossRate() {
        double new_loss_rate = this.getLossRate();
        this.smoothed_loss_rate = this.smoothed_loss_rate == 0.0 ? new_loss_rate : this.smoothed_loss_rate * 0.3 + new_loss_rate * 0.7;
    }

    public int getRetransmiTableSize() {
        return this.xmit_table.size();
    }

    public int getRetransmitTableCapacity() {
        return this.xmit_table.capacity();
    }

    public double getRetransmitTableFillFactor() {
        return this.xmit_table.getFillFactor();
    }

    public void compact() {
        this.xmit_table.compact();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(long seqno, Message msg) {
        int num_xmits;
        block21: {
            num_xmits = 0;
            this.lock.writeLock().lock();
            try {
                long next_to_add;
                if (!this.running) {
                    boolean bl = false;
                    return bl;
                }
                long old_next = next_to_add = this.highest_received + 1L;
                if (seqno == next_to_add) {
                    this.xmit_table.put(seqno, msg);
                    boolean bl = true;
                    return bl;
                }
                if (seqno <= this.highest_delivered) {
                    if (log.isTraceEnabled()) {
                        log.trace("seqno " + seqno + " is smaller than " + next_to_add + "); discarding message");
                    }
                    boolean bl = false;
                    return bl;
                }
                if (seqno < next_to_add) {
                    Message existing = this.xmit_table.putIfAbsent(seqno, msg);
                    if (existing != null) {
                        boolean bl = false;
                        return bl;
                    }
                    num_xmits = this.retransmitter.remove(seqno);
                    if (log.isTraceEnabled()) {
                        log.trace(new StringBuilder("added missing msg ").append(msg.getSrc()).append('#').append(seqno));
                    }
                    boolean bl = true;
                    return bl;
                }
                if (seqno <= next_to_add) break block21;
                this.xmit_table.put(seqno, msg);
                this.retransmitter.add(old_next, seqno - 1L);
                if (this.listener != null) {
                    try {
                        this.listener.messageGapDetected(next_to_add, seqno, msg.getSrc());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                boolean t = true;
                return t;
            }
            finally {
                this.highest_received = Math.max(this.highest_received, seqno);
                this.lock.writeLock().unlock();
            }
        }
        if (this.listener != null && num_xmits > 0) {
            try {
                this.listener.missingMessageReceived(seqno, msg.getSrc());
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return true;
    }

    public Message remove() {
        return this.remove(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message remove(boolean acquire_lock, boolean remove_msg) {
        if (acquire_lock) {
            this.lock.writeLock().lock();
        }
        try {
            Message retval;
            long next = this.highest_delivered + 1L;
            Message message = retval = remove_msg ? this.xmit_table.remove(next) : this.xmit_table.get(next);
            if (retval != null) {
                this.highest_delivered = next;
                Message message2 = retval;
                return message2;
            }
            Message message3 = null;
            return message3;
        }
        finally {
            if (acquire_lock) {
                this.lock.writeLock().unlock();
            }
        }
    }

    public List<Message> removeMany(AtomicBoolean processing) {
        return this.removeMany(processing, false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> removeMany(AtomicBoolean processing, boolean remove_msgs, int max_results) {
        LinkedList<Message> retval = null;
        int num_results = 0;
        this.lock.writeLock().lock();
        try {
            do {
                Message msg;
                long next = this.highest_delivered + 1L;
                Message message = msg = remove_msgs ? this.xmit_table.remove(next) : this.xmit_table.get(next);
                if (msg == null) break;
                this.highest_delivered = next;
                if (retval == null) {
                    retval = new LinkedList<Message>();
                }
                retval.add(msg);
            } while (max_results <= 0 || ++num_results < max_results);
            if ((retval == null || retval.isEmpty()) && processing != null) {
                processing.set(false);
            }
            LinkedList<Message> linkedList = retval;
            return linkedList;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stable(long seqno) {
        this.lock.writeLock().lock();
        try {
            if (seqno > this.highest_delivered) {
                if (log.isWarnEnabled()) {
                    log.warn("seqno " + seqno + " is > highest_delivered (" + this.highest_delivered + ";) ignoring stability message");
                }
                return;
            }
            this.xmit_table.purge(seqno);
            for (long i = this.low; i <= seqno; ++i) {
                this.retransmitter.remove(i);
            }
            this.highest_stability_seqno = Math.max(this.highest_stability_seqno, seqno);
            this.low = Math.max(this.low, seqno);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.lock.writeLock().lock();
        try {
            this.running = false;
            this.retransmitter.reset();
            this.xmit_table.clear();
            this.low = 0L;
            this.highest_delivered = 0L;
            this.highest_received = 0L;
            this.highest_stability_seqno = 0L;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getDigest() {
        this.lock.readLock().lock();
        try {
            long[] retval = new long[]{this.low, this.highest_delivered, this.highest_received};
            long[] lArray = retval;
            return lArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLowestSeen() {
        this.lock.readLock().lock();
        try {
            long l = this.low;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestDelivered() {
        this.lock.readLock().lock();
        try {
            long l = this.highest_delivered;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setHighestDelivered(long new_val) {
        this.lock.writeLock().lock();
        try {
            long retval = this.highest_delivered;
            this.highest_delivered = new_val;
            long l = retval;
            return l;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestReceived() {
        this.lock.readLock().lock();
        try {
            long l = this.highest_received;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message get(long seqno) {
        this.lock.readLock().lock();
        try {
            Message message = this.xmit_table.get(seqno);
            return message;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> get(long from, long to) {
        this.lock.readLock().lock();
        try {
            List<Message> list = this.xmit_table.get(from, to);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.xmit_table.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = this.printMessages();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String printMessages() {
        StringBuilder sb = new StringBuilder();
        this.lock.readLock().lock();
        try {
            sb.append('[').append(this.low).append(" : ").append(this.highest_delivered).append(" (").append(this.highest_received).append(")");
            if (this.xmit_table != null && !this.xmit_table.isEmpty()) {
                int non_received = this.xmit_table.getNullMessages(this.highest_received);
                sb.append(" (size=").append(this.xmit_table.size()).append(", missing=").append(non_received).append(", highest stability=").append(this.highest_stability_seqno).append(')');
            }
            sb.append(']');
            String string = sb.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String printLossRate() {
        StringBuilder sb = new StringBuilder();
        int num_missing = this.getPendingXmits();
        int num_received = this.size();
        int total = num_missing + num_received;
        sb.append("total=").append(total).append(" (received=").append(num_received).append(", missing=").append(num_missing).append("), loss rate=").append(this.getLossRate()).append(", smoothed loss rate=").append(this.smoothed_loss_rate);
        return sb.toString();
    }

    public String printRetransmitStats() {
        return this.retransmitter instanceof RangeBasedRetransmitter ? ((RangeBasedRetransmitter)this.retransmitter).printStats() : "n/a";
    }

    public static interface Listener {
        public void missingMessageReceived(long var1, Address var3);

        public void messageGapDetected(long var1, long var3, Address var5);
    }
}

