/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.spi;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.ow2.jonas.versioning.VersioningService;

public class VirtualJNDILookup
implements Context {
    private Context parent;
    private static VersioningService versioningService;

    public VirtualJNDILookup(Context parent) {
        this.parent = parent;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        String prefix = this.getPrefix();
        if (prefix != null) {
            try {
                return this.parent.lookup(prefix + name);
            }
            catch (NamingException ignored) {
                try {
                    return this.parent.lookup(name);
                }
                catch (NamingException ne) {
                    if (name.startsWith(prefix)) {
                        return this.parent.lookup(name.substring(prefix.length()));
                    }
                    throw ne;
                }
            }
        }
        return this.parent.lookup(name);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        String prefix = this.getPrefix();
        if (prefix != null) {
            try {
                return this.parent.lookupLink(prefix + name);
            }
            catch (NamingException ignored) {
                try {
                    return this.parent.lookupLink(name);
                }
                catch (NamingException ne) {
                    if (name.startsWith(prefix)) {
                        return this.parent.lookupLink(name.substring(prefix.length()));
                    }
                    throw ne;
                }
            }
        }
        return this.parent.lookupLink(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    protected String getPrefix() {
        String prefix;
        try {
            prefix = (String)this.parent.lookup("java:comp/env/JNDILookupPrefix");
        }
        catch (NamingException e) {
            prefix = null;
        }
        if (prefix != null) {
            return prefix;
        }
        return null;
    }

    public static void setVersioningService(VersioningService versioningService) {
        VirtualJNDILookup.versioningService = versioningService;
    }

    public static void unsetVersioningService() {
        versioningService = null;
    }

    public static VersioningService getVersioningService() {
        return versioningService;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.parent.addToEnvironment(propName, propVal);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.parent.bind(name, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.parent.bind(name, obj);
    }

    @Override
    public void close() throws NamingException {
        this.parent.close();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.parent.composeName(name, prefix);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.parent.composeName(name, prefix);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.parent.createSubcontext(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.parent.createSubcontext(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.parent.destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.parent.destroySubcontext(name);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.parent.getEnvironment();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.parent.getNameInNamespace();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.parent.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.parent.getNameParser(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.parent.list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.parent.list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.parent.listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.parent.listBindings(name);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.parent.rebind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.parent.rebind(name, obj);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.parent.removeFromEnvironment(propName);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.parent.rename(oldName, newName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.parent.rename(oldName, newName);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.parent.unbind(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.parent.unbind(name);
    }
}

