/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.listener;

import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.orb.iiop.IIOPListener;
import org.jacorb.orb.listener.AcceptorExceptionEvent;
import org.jacorb.orb.listener.AcceptorExceptionListener;
import org.jacorb.slf4j.Logger;
import org.jacorb.util.ObjectUtil;

public class DefaultAcceptorExceptionListener
implements AcceptorExceptionListener,
Configurable {
    private Class sslException;
    private Logger logger;

    public void configure(Configuration configuration) {
        this.sslException = null;
        String string = configuration.getAttribute("javax.net.ssl.SSLException", null);
        if (string != null) {
            try {
                this.sslException = ObjectUtil.classForName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.logger = configuration.getLogger("jacorb.orb.iiop");
    }

    public void exceptionCaught(AcceptorExceptionEvent acceptorExceptionEvent) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Caught acceptor event: " + acceptorExceptionEvent);
        }
        if (acceptorExceptionEvent.getException() instanceof Error || !((IIOPListener.Acceptor)acceptorExceptionEvent.getSource()).getAcceptorSocketLoop() && this.sslException != null && this.sslException.isInstance(acceptorExceptionEvent.getException())) {
            this.logger.error("fatal exception. will shutdown orb", acceptorExceptionEvent.getException());
            acceptorExceptionEvent.getORB().shutdown(true);
        }
    }
}

