/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.datasource.deployer;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.ow2.jonas.Version;
import org.ow2.jonas.datasource.deployer.DatasourceDeployable;
import org.ow2.jonas.datasource.deployer.binding.DatasourceType;
import org.ow2.jonas.datasource.deployer.binding.Datasources;
import org.ow2.jonas.datasource.deployer.reader.DatasourceXmlReader;
import org.ow2.jonas.generators.raconfig.RAConfig;
import org.ow2.jonas.generators.raconfig.RAConfigException;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.ee.deploy.api.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployerList;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentPlanFragment;
import org.ow2.util.plan.bindings.deploymentplan.maven2.Maven2Deployment;
import org.ow2.util.plan.bindings.exceptions.InvalidDeploymentException;
import org.ow2.util.plan.fetcher.api.IResourceFetcher;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactoryManager;
import org.ow2.util.plan.fetcher.api.exceptions.FetcherException;
import org.ow2.util.plan.fetcher.api.exceptions.FetcherFactoryException;
import org.ow2.util.plan.fetcher.api.exceptions.ResourceFetcherNotResolvedException;
import org.ow2.util.plan.fetcher.api.exceptions.ResourceNotFoundException;
import org.ow2.util.plan.repository.api.IRepositoryManager;
import org.ow2.util.url.URLUtils;

public class DatasourceDeployer
extends AbsDeployerList<DatasourceDeployable> {
    private Log logger = LogFactory.getLog(DatasourceDeployer.class);
    private IDeployerManager deployerManager = null;
    private DatasourceXmlReader datasourceReader;
    private static final String DEFAULT_ARCHIVE_PATH = "deployer" + File.separator + "datasources";
    protected File archiveFile = null;
    private Map<URI, List<IDeployable<?>>> datasourceDeployables = new HashMap();
    protected ServerProperties serverProps;
    protected DeployerLog deployerLog = null;
    private String dmRar;
    protected IResourceFetcherFactoryManager resourceFetcherFactoryManager;
    protected IRepositoryManager repositoryManager;

    protected void undeployDatasource(DatasourceDeployable datasourceDeployable) throws DeployerException {
        this.logger.info("Undeploying {0}", new Object[]{datasourceDeployable});
        URI uri = this.getUri((IDeployable<?>)datasourceDeployable);
        for (IDeployable<?> rar : this.datasourceDeployables.get(uri)) {
            try {
                this.deployerManager.undeploy(rar);
            }
            catch (DeployerException e) {
                throw new DeployerException("Exception while undeploying deployable " + rar, (Throwable)e);
            }
            catch (UnsupportedDeployerException e) {
                throw new DeployerException("No deployer found for deployable " + rar, (Throwable)e);
            }
        }
        this.datasourceDeployables.remove(uri);
    }

    protected void deployDatasource(IDeployable<DatasourceDeployable> deployable) throws DeployerException {
        this.logger.debug("Request to deploy {0} received", deployable);
        if (deployable == null) {
            throw new DeployerException("Null deployable");
        }
        if (!DatasourceDeployable.class.isAssignableFrom(deployable.getClass())) {
            throw new DeployerException("Bad deployable type " + deployable.getClass());
        }
        this.logger.info("Deploying datasource {0}", deployable);
        DatasourceDeployable datasourceDeployable = (DatasourceDeployable)((Object)DatasourceDeployable.class.cast(deployable));
        this.datasourceReader = new DatasourceXmlReader();
        if (this.datasourceReader == null) {
            throw new DeployerException("Deployment aborted - The DatasourceReader is null");
        }
        File xmlfile = this.getFile(datasourceDeployable);
        Datasources datasources = null;
        try {
            datasources = this.datasourceReader.extractDataSources(xmlfile);
        }
        catch (Exception e) {
            throw new DeployerException("Error while parsing file " + xmlfile + " - Deployment aborted", (Throwable)e);
        }
        if (datasources == null) {
            throw new DeployerException("The deployable " + deployable + " resolved in null datasource - Deployment aborted");
        }
        datasourceDeployable.setAttachedData(datasources);
        ArrayList<IDeployable> generatedResourceAdapters = new ArrayList<IDeployable>();
        for (DatasourceType ds : datasources.getDatasources()) {
            DatasourceType dsInitialized = this.datasourceReader.initDataSource(ds);
            Properties properties = this.datasourceReader.getProperties(dsInitialized);
            String fileIn = null;
            String fileOut = null;
            String fileName = "";
            try {
                fileName = "ds-" + dsInitialized.getDatasourceConfiguration().getName().replace('/', '_') + "-";
                fileOut = File.createTempFile(fileName, ".rar", this.archiveFile).getAbsolutePath();
            }
            catch (IOException e1) {
                String msg = "Error while creating temp file <" + fileName + ".rar> in directory <" + this.archiveFile.getPath() + ">";
                throw new DeployerException(msg, (Throwable)e1);
            }
            if (this.dmRar == null) {
                if (this.resourceFetcherFactoryManager != null) {
                    Maven2Deployment deployment = new Maven2Deployment();
                    deployment.setGroupId("org.ow2.jonas");
                    deployment.setArtifactId("jonas-jca-jdbc-dm");
                    deployment.setVersion(Version.getNumber());
                    deployment.setType("rar");
                    try {
                        IResourceFetcher fetcher = this.resourceFetcherFactoryManager.getResourceFetcher((DeploymentPlanFragment)deployment);
                        fetcher.setRepositoryManager(this.repositoryManager);
                        fetcher.setDeployment((DeploymentPlanFragment)deployment);
                        fetcher.resolve();
                        this.setDmRar(fetcher.getResource().getPath());
                    }
                    catch (FetcherException e) {
                        e.printStackTrace();
                    }
                    catch (ResourceNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidDeploymentException e) {
                        e.printStackTrace();
                    }
                    catch (FetcherFactoryException e) {
                        e.printStackTrace();
                    }
                    catch (ResourceFetcherNotResolvedException e) {
                        e.printStackTrace();
                    }
                } else {
                    throw new DeployerException("Resource fetcher factory service was not found. Cannot resolve the artifact org.ow2.jonas:jonas-jca-jdbc-dm:" + Version.getNumber() + ":rar");
                }
            }
            fileIn = this.dmRar;
            this.logger.info("Generate RAR {0} -> {1}", fileIn, fileOut);
            try {
                RAConfig.generateRars((Properties)properties, (String)"JOnASJDBC_DM", (String)fileIn, (String)fileOut);
            }
            catch (RAConfigException e) {
                this.logger.error("Failure to deploy datasource {0}", ds);
                throw new DeployerException((Throwable)e);
            }
            File generatedFile = new File(fileOut);
            if (!generatedFile.exists()) {
                this.logger.error("RAR was not generated with RAConfig- {0}", fileOut);
                throw new DeployerException("RAR was not generated <" + fileOut + ">");
            }
            IArchive archiveRar = ArchiveManager.getInstance().getArchive((Object)generatedFile);
            if (archiveRar == null) {
                throw new DeployerException("Null archive for file " + fileOut);
            }
            IDeployable rardeployable = null;
            try {
                rardeployable = DeployableHelper.getDeployable((IArchive)archiveRar);
            }
            catch (DeployableHelperException e) {
                throw new DeployerException((Throwable)e);
            }
            if (rardeployable == null) {
                throw new DeployerException("Null deployable for archive " + archiveRar);
            }
            try {
                this.deployerManager.deploy(rardeployable);
            }
            catch (DeployerException e) {
                throw new DeployerException("Exception while deploying deployable " + rardeployable, (Throwable)e);
            }
            catch (UnsupportedDeployerException e) {
                throw new DeployerException("No deployer found for deployable " + rardeployable, (Throwable)e);
            }
            generatedResourceAdapters.add(rardeployable);
            try {
                if (this.deployerLog == null) continue;
                File unpackedFile = URLUtils.urlToFile((URL)datasourceDeployable.getArchive().getURL());
                this.deployerLog.addEntry(xmlfile, new File(fileOut));
            }
            catch (Exception e) {
                throw new DeployerException("Cannot get  the url of the initial deployable for the datasource Module '" + deployable + "'.", (Throwable)e);
            }
        }
        this.datasourceDeployables.put(xmlfile.toURI(), generatedResourceAdapters);
    }

    protected File getFile(DatasourceDeployable datasourceDeployable) throws DeployerException {
        URL datasourceURL = null;
        try {
            datasourceURL = datasourceDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get URL from Datasource deployable '" + (Object)((Object)datasourceDeployable) + "'.", (Throwable)e);
        }
        return URLUtils.urlToFile((URL)datasourceURL);
    }

    public void deploy(IDeployable<DatasourceDeployable> deployable) throws DeployerException {
        this.check(deployable);
        if (DatasourceDeployable.class.isAssignableFrom(deployable.getClass())) {
            this.deployDatasource(deployable);
        }
    }

    public boolean isDeployed(IDeployable<DatasourceDeployable> deployable) throws DeployerException {
        if (this.supports(deployable)) {
            return this.datasourceDeployables.get(this.getUri(deployable)) != null;
        }
        return false;
    }

    protected URI getUri(IDeployable<?> deployable) {
        try {
            return deployable.getArchive().getURL().toURI();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get URI from Datasource deployable '" + deployable + "'.", e);
        }
    }

    public boolean isDeployed(String rarFileName) {
        return this.datasourceDeployables.containsValue(rarFileName);
    }

    public boolean supports(IDeployable<?> deployable) {
        return DatasourceDeployable.class.isAssignableFrom(deployable.getClass());
    }

    public void undeploy(IDeployable<DatasourceDeployable> deployable) throws DeployerException {
        if (!this.supports(deployable)) {
            throw new DeployerException("Cannot undeploy non-datasource deployable " + deployable + ".");
        }
        if (!this.isDeployed(deployable)) {
            throw new DeployerException("Cannot undeploy datasource deployable " + deployable + " - it is not deployed.");
        }
        this.undeployDatasource((DatasourceDeployable)((Object)DatasourceDeployable.class.cast(deployable)));
    }

    private void check(IDeployable<?> deployable) throws DeployerException {
        if (!this.supports(deployable)) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not supported by this deployer.");
        }
    }

    public IDeployerManager getDeployerManager() {
        return this.deployerManager;
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public void setServerProperties(ServerProperties props) {
        this.serverProps = props;
    }

    protected void initWorkingDirectory() {
        if (this.archiveFile == null) {
            this.archiveFile = new File(this.serverProps.getWorkDirectory() + File.separator + DEFAULT_ARCHIVE_PATH + File.separator + this.serverProps.getServerName());
            this.archiveFile.mkdirs();
        }
    }

    public String getDmRar() {
        return this.dmRar;
    }

    public void setDmRar(String dmRar) {
        this.dmRar = dmRar;
    }
}

