/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.datasource.internal;

import java.util.HashMap;
import javax.naming.Context;
import javax.naming.LinkRef;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.event.naming.EZBJavaContextNamingEvent;
import org.ow2.jonas.datasource.DataSourceService;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationSqlDataSourceDefinition;
import org.ow2.util.event.api.EventPriority;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DSDefinitionExtensionListener
implements IEventListener {
    private static Log logger = LogFactory.getLog(DSDefinitionExtensionListener.class);
    private DataSourceService dataSourceService;

    public DSDefinitionExtensionListener(DataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }

    public void handle(IEvent event) {
        EZBJavaContextNamingEvent javaContextNamingEvent = (EZBJavaContextNamingEvent)event;
        IBeanInfo beanInfo = javaContextNamingEvent.getFactory().getBeanInfo();
        Context context = javaContextNamingEvent.getJavaContext();
        for (IJAnnotationSqlDataSourceDefinition dataSourceDefinition : beanInfo.getDataSourceDefinitions()) {
            String normalizedDataSourceName = dataSourceDefinition.getName();
            normalizedDataSourceName = normalizedDataSourceName.startsWith("java:") ? normalizedDataSourceName.replaceFirst("java:", "") : "comp/env/" + normalizedDataSourceName;
            try {
                HashMap<String, String> properties = new HashMap<String, String>();
                for (int i = 0; i < dataSourceDefinition.getProperties().length; ++i) {
                    String prop = dataSourceDefinition.getProperties()[i];
                    String[] property = prop.split("=");
                    if (property.length != 2) continue;
                    properties.put(property[0], property[1]);
                }
                String globalJndiName = this.dataSourceService.deployDataSource(dataSourceDefinition.getClassName(), dataSourceDefinition.getDescription(), dataSourceDefinition.getUrl(), dataSourceDefinition.getUser(), dataSourceDefinition.getPassword(), dataSourceDefinition.getDatabaseName(), dataSourceDefinition.getPortNumber(), dataSourceDefinition.getServerName(), dataSourceDefinition.getIsolationLevel(), dataSourceDefinition.isTransactional(), dataSourceDefinition.getInitialPoolSize(), dataSourceDefinition.getMaxPoolSize(), dataSourceDefinition.getMinPoolSize(), dataSourceDefinition.getMaxIdleTime(), dataSourceDefinition.getMaxStatements(), dataSourceDefinition.getLoginTimeout(), properties);
                context.rebind(normalizedDataSourceName, (Object)new LinkRef(globalJndiName));
            }
            catch (Exception e) {
                logger.error("Unable to define data source {0}", dataSourceDefinition.getName(), e);
            }
        }
    }

    public boolean accept(IEvent event) {
        EZBJavaContextNamingEvent javaContextNamingEvent;
        return event instanceof EZBJavaContextNamingEvent && "java:".equals((javaContextNamingEvent = (EZBJavaContextNamingEvent)event).getEventProviderId());
    }

    public EventPriority getPriority() {
        return EventPriority.SYNC_NORM;
    }
}

