/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import org.ow2.easybeans.api.EZBTimerService;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.IStatefulSessionFactory;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.bean.info.IMethodInfo;
import org.ow2.easybeans.component.quartz.EasyBeansJob;
import org.ow2.easybeans.component.quartz.EasyBeansJobDetailData;
import org.ow2.easybeans.component.quartz.EasyBeansScheduleBuilder;
import org.ow2.easybeans.component.quartz.EasyBeansScheduleTrigger;
import org.ow2.easybeans.component.quartz.EasyBeansTimer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.GroupMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzTimerService
implements EZBTimerService {
    private static final Log LOGGER = LogFactory.getLog(QuartzTimerService.class);
    private Factory<?, ?> factory = null;
    private Scheduler scheduler = null;
    private String triggerGroupName = null;
    private long triggerId = 0L;
    private long jobDetailId = 0L;

    public QuartzTimerService(Factory<?, ?> factory, Scheduler scheduler) {
        this.factory = factory;
        this.scheduler = scheduler;
        this.triggerGroupName = factory.getId();
    }

    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (this.factory instanceof IStatefulSessionFactory) {
            throw new IllegalStateException("The createTimer() method cannot be called from a stateful session bean.");
        }
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The createTimer(duration, info) method cannot be called within the operation state '" + operationState + "'.");
        }
        return this.createTimer(new Date(System.currentTimeMillis() + duration), info);
    }

    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (this.factory instanceof IStatefulSessionFactory) {
            throw new IllegalStateException("The createTimer() method cannot be called from a stateful session bean.");
        }
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The createTimer(duratinitialDurationion, intervalDuration, info)  method cannot be called within the operation state '" + operationState + "'.");
        }
        Date initialExpiration = new Date(System.currentTimeMillis() + initialDuration);
        return this.createTimer(initialExpiration, intervalDuration, info);
    }

    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (this.factory instanceof IStatefulSessionFactory) {
            throw new IllegalStateException("The createTimer() method cannot be called from a stateful session bean.");
        }
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The createTimer(expiration, info) method cannot be called within the operation state '" + operationState + "'.");
        }
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(this.getTriggerName(), this.getTriggerGroupName()).startAt(expiration).build();
        return this.internalTimer(trigger, info, false, null, null);
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (this.factory instanceof IStatefulSessionFactory) {
            throw new IllegalStateException("The createTimer() method cannot be called from a stateful session bean.");
        }
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The createTimer(initialExpiration, intervalDuration, info) method cannot be called within the operation state '" + operationState + "'.");
        }
        SimpleTrigger trigger = TriggerBuilder.newTrigger().withIdentity(this.getTriggerName(), this.getTriggerGroupName()).startAt(initialExpiration).withSchedule(SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(intervalDuration).repeatForever()).build();
        return this.internalTimer(trigger, info, false, null, null);
    }

    public Timer createSingleActionTimer(long duration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException("Invalid duration (negative)");
        }
        if (this.factory instanceof IStatefulSessionFactory) {
            throw new IllegalStateException("The createTimer() method cannot be called from a stateful session bean.");
        }
        return this.createSingleActionTimer(new Date(System.currentTimeMillis() + duration), timerConfig);
    }

    public Timer createSingleActionTimer(Date expiration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (expiration == null || expiration.getTime() < 0L) {
            throw new IllegalArgumentException("Invalid Expiration date");
        }
        if (this.factory instanceof IStatefulSessionFactory) {
            throw new IllegalStateException("The createTimer() method cannot be called from a stateful session bean.");
        }
        Serializable info = timerConfig.getInfo();
        boolean isPersistent = timerConfig.isPersistent();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(this.getTriggerName(), this.getTriggerGroupName()).startAt(expiration).build();
        return this.internalTimer(trigger, info, isPersistent, null, null);
    }

    public Timer createIntervalTimer(long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("Invalid initial duration (negative");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("Invalid duration is negative");
        }
        if (this.factory instanceof IStatefulSessionFactory) {
            throw new IllegalStateException("The createTimer() method cannot be called from a stateful session bean.");
        }
        Date initialExpiration = new Date(System.currentTimeMillis() + initialDuration);
        return this.createIntervalTimer(initialExpiration, intervalDuration, timerConfig);
    }

    public Timer createIntervalTimer(Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null || initialExpiration.getTime() < 0L) {
            throw new IllegalArgumentException("Invalid Expiration date");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("Invalid duration is negative");
        }
        if (this.factory instanceof IStatefulSessionFactory) {
            throw new IllegalStateException("The createTimer() method cannot be called from a stateful session bean.");
        }
        Serializable info = timerConfig.getInfo();
        boolean isPersistent = timerConfig.isPersistent();
        SimpleTrigger trigger = TriggerBuilder.newTrigger().withIdentity(this.getTriggerName(), this.getTriggerGroupName()).startAt(initialExpiration).withSchedule(SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(intervalDuration).repeatForever()).build();
        return this.internalTimer(trigger, info, isPersistent, null, null);
    }

    public Timer createCalendarTimer(ScheduleExpression schedule) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createCalendarTimer(schedule, null);
    }

    public Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createCalendarTimer(schedule, timerConfig, null);
    }

    public Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig timerConfig, IMethodInfo methodInfo) throws IllegalArgumentException, IllegalStateException, EJBException {
        TriggerBuilder<EasyBeansScheduleTrigger> triggerBuilder = TriggerBuilder.newTrigger().withIdentity(this.getTriggerName(), this.getTriggerGroupName()).withSchedule(new EasyBeansScheduleBuilder(schedule));
        if (schedule.getStart() != null) {
            triggerBuilder = triggerBuilder.startAt(schedule.getStart());
        }
        if (schedule.getEnd() != null) {
            Date end = schedule.getEnd();
            Date compare = new Date();
            if (schedule.getStart() != null) {
                compare = schedule.getStart();
            }
            if (end.after(compare)) {
                triggerBuilder = triggerBuilder.endAt(schedule.getEnd());
            }
        }
        EasyBeansScheduleTrigger trigger = triggerBuilder.build();
        Serializable info = null;
        boolean isPersistent = true;
        if (timerConfig != null) {
            info = timerConfig.getInfo();
            isPersistent = timerConfig.isPersistent();
        }
        if ("".equals(info)) {
            info = null;
        }
        EasyBeansTimer timer = (EasyBeansTimer)this.internalTimer(trigger, info, isPersistent, methodInfo, schedule);
        return timer;
    }

    private Timer internalTimer(Trigger trigger, Serializable info, boolean isPersistent, IMethodInfo methodInfo, ScheduleExpression scheduleExpression) {
        EasyBeansJobDetailData beansJobDetailData = new EasyBeansJobDetailData();
        beansJobDetailData.setInfo(info);
        Integer easyBeansServerID = this.factory.getContainer().getConfiguration().getEZBServer().getID();
        beansJobDetailData.setEasyBeansServerID(easyBeansServerID);
        beansJobDetailData.setContainerId(this.factory.getContainer().getId());
        if (scheduleExpression != null) {
            beansJobDetailData.setScheduleExpression(scheduleExpression);
        }
        beansJobDetailData.setPersistent(isPersistent);
        String factoryName = null;
        IBeanInfo beanInfo = this.factory.getBeanInfo();
        factoryName = beanInfo == null ? this.factory.getClassName() : this.factory.getBeanInfo().getName();
        beansJobDetailData.setFactoryName(factoryName);
        beansJobDetailData.setMethodInfo(methodInfo);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("data", (Object)beansJobDetailData);
        JobDetail jobDetail = JobBuilder.newJob(EasyBeansJob.class).withIdentity(this.getNewJobDetailName(), this.getJobDetailGroupName()).usingJobData(jobDataMap).build();
        EasyBeansTimer timer = new EasyBeansTimer(jobDetail, trigger, this.scheduler, this.factory);
        if (trigger instanceof EasyBeansScheduleTrigger) {
            ((EasyBeansScheduleTrigger)trigger).setEasyBeansTimer(timer);
        }
        beansJobDetailData.setTimer(timer);
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            LOGGER.error((Object)"Cannot schedule the given job ''{0}''.", new Object[]{jobDetail, e});
            timer.setInvalid();
            return timer;
        }
        return timer;
    }

    public Collection<Timer> getTimers() throws IllegalStateException, EJBException {
        if (this.factory instanceof IStatefulSessionFactory) {
            throw new IllegalStateException("The getTimers() method cannot be called from a stateful session bean.");
        }
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The getTimers() method cannot be called within the operation state '" + operationState + "'.");
        }
        ArrayList<Timer> timers = new ArrayList<Timer>();
        Set<JobKey> jobKeys = null;
        try {
            jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals(this.getJobDetailGroupName()));
        }
        catch (SchedulerException e) {
            throw new EJBException("Unable to get the job names from the scheduler for the group named '" + this.getJobDetailGroupName() + "'.", (Exception)e);
        }
        if (jobKeys != null) {
            for (JobKey jobKey : jobKeys) {
                JobDetail jobDetail = null;
                try {
                    jobDetail = this.scheduler.getJobDetail(jobKey);
                }
                catch (SchedulerException e) {
                    throw new EJBException("Cannot get the jobDetail for the jobKey '" + jobKey + "'.", (Exception)e);
                }
                List<? extends Trigger> triggers = null;
                try {
                    triggers = this.scheduler.getTriggersOfJob(jobKey);
                }
                catch (SchedulerException e) {
                    throw new EJBException("Cannot get triggers for the job named '" + jobKey + "'.", (Exception)e);
                }
                if (triggers == null || triggers.size() > 1) {
                    throw new EJBException("Invalid numbers of triggers found for the job named '" + jobKey + "'.");
                }
                timers.add(new EasyBeansTimer(jobDetail, triggers.get(0), this.scheduler, this.factory));
            }
        }
        return timers;
    }

    private synchronized String getTriggerName() {
        return "triggerTimer" + this.triggerId++;
    }

    private synchronized String getNewJobDetailName() {
        return "jobDetail" + this.jobDetailId++;
    }

    private String getTriggerGroupName() {
        return this.triggerGroupName;
    }

    private String getJobDetailGroupName() {
        return "jobDetailGroup" + this.factory.getClassName();
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

