/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.util.regex.Pattern;

public final class SchedulePatterns {
    public static final String WILDCARD_CHARACTER = "*";
    public static final String WILDCARD_PATTERN = "[*]";
    public static final String LAST = "last";
    public static final Pattern PATTERN_SECOND;
    public static final Pattern PATTERN_MINUTE;
    public static final Pattern PATTERN_HOUR;
    private static final String DAY_OF_MONTH_1_31 = "0?[1-9]|[1-2][\\d]|3[0-1]";
    private static final String DAY_OF_MONTH_MINUS1_MINUS7 = "-[1-7]";
    private static final String DAY_OF_MONTH_VALUES1 = "1st|2nd|3rd|4th|5th|last";
    private static final String DAY_OF_MONTH_VALUES2 = "sun|mon|tue|wed|thu|fri|sat";
    public static final Pattern PATTERN_DAY_OF_MONTH;
    private static final String MONTH_1_12 = "0?[1-9]|1[0-2]";
    private static final String MONTH_VALUES = "jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec";
    public static final Pattern PATTERN_MONTH_1_12;
    public static final Pattern PATTERN_MONTH_VALUES;
    public static final Pattern PATTERN_MONTH;
    private static final String DAY_OF_WEEK_0_7 = "[0-7]";
    private static final String DAY_OF_WEEK_VALUES = "sun|mon|tue|wed|thu|fri|sat";
    public static final Pattern PATTERN_DAY_OF_WEEK_0_7;
    public static final Pattern PATTERN_DAY_OF_WEEK_VALUES;
    public static final Pattern PATTERN_DAY_OF_WEEK;
    public static final Pattern PATTERN_YEAR;
    public static final Pattern PATTERN_RANGE;
    public static final Pattern PATTERN_INCREMENTS;
    private static final String NUMBERS = "1st|2nd|3rd|4th|5th";
    private static final String DAYS = "sun|mon|tue|wed|thu|fri|sat";
    public static final Pattern PATTERN_NDAYS;

    private SchedulePatterns() {
    }

    static {
        PATTERN_MINUTE = PATTERN_SECOND = Pattern.compile("[0-5]?\\d|[*]");
        PATTERN_HOUR = Pattern.compile("[0-1]?[\\d]|2[0-3]|[*]");
        PATTERN_DAY_OF_MONTH = Pattern.compile("0?[1-9]|[1-2][\\d]|3[0-1]|-[1-7]|last|(1st|2nd|3rd|4th|5th|last)(sun|mon|tue|wed|thu|fri|sat)|[*]");
        PATTERN_MONTH_1_12 = Pattern.compile(MONTH_1_12);
        PATTERN_MONTH_VALUES = Pattern.compile(MONTH_VALUES);
        PATTERN_MONTH = Pattern.compile("0?[1-9]|1[0-2]|jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec|[*]");
        PATTERN_DAY_OF_WEEK_0_7 = Pattern.compile("([0-7])");
        PATTERN_DAY_OF_WEEK_VALUES = Pattern.compile("(sun|mon|tue|wed|thu|fri|sat)");
        PATTERN_DAY_OF_WEEK = Pattern.compile("[0-7]|last|sun|mon|tue|wed|thu|fri|sat|[*]");
        PATTERN_YEAR = Pattern.compile("\\d{4}|[*]");
        PATTERN_RANGE = Pattern.compile("(-?\\p{Alnum}+)-(-?\\p{Alnum}+)");
        PATTERN_INCREMENTS = Pattern.compile("([*]|\\d+)/(\\d+)");
        PATTERN_NDAYS = Pattern.compile("(last|1st|2nd|3rd|4th|5th)(sun|mon|tue|wed|thu|fri|sat)");
    }
}

