/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.auditreport.impl;

import java.util.Arrays;
import org.ow2.util.auditreport.impl.EncodingType;
import org.ow2.util.auditreport.impl.GenericAuditReport;
import org.ow2.util.auditreport.impl.util.ObjectEncoder;

public class InvocationAuditReport
extends GenericAuditReport {
    private static final long serialVersionUID = -3332882932887333168L;
    private long requestStart = 0L;
    private long requestStop = 0L;
    private double requestDuration = 0.0;
    private String businessMethod = "";
    private String target = "";
    private String[] methodParameters = null;
    private Object methodReturn = null;
    private long paramSize = 0L;
    private long returnSize = 0L;

    public InvocationAuditReport() {
    }

    public InvocationAuditReport(long requestStartParam, long requestTimeStampParam, String businessMethodParam, String targetParam, String[] methodParametersParam, Thread currentThreadParam, int freeMemoryBeforeParam, int totalMemoryBeforeParam, String[] roles, String user, int paramSize) {
        this.setRequestTimeStamp(requestTimeStampParam);
        this.setFreeMemoryBefore(freeMemoryBeforeParam);
        this.setTotalMemoryBefore(totalMemoryBeforeParam);
        if (roles != null) {
            this.setRoles(Arrays.asList(roles).toString());
        }
        this.setUser(user);
        this.paramSize = paramSize;
        this.target = targetParam;
        this.businessMethod = businessMethodParam;
        this.methodParameters = methodParametersParam;
        this.requestStart = requestStartParam;
    }

    public String getBusinessMethod() {
        return this.businessMethod;
    }

    public String[] getMethodParameters() {
        return this.methodParameters;
    }

    public Object getMethodReturn() {
        return this.methodReturn;
    }

    public double getRequestDuration() {
        return this.requestDuration;
    }

    public long getRequestStart() {
        return this.requestStart;
    }

    public long getRequestStop() {
        return this.requestStop;
    }

    public void setRequestStart(long requestStartParam) {
        this.requestStart = requestStartParam;
    }

    public void setRequestStop(long requestStopParam) {
        this.requestStop = requestStopParam;
        this.requestDuration = requestStopParam - this.requestStart;
    }

    public void setRequestDuration(double requestDurationParam) {
        this.requestDuration = requestDurationParam;
    }

    public void setBusinessMethod(String businessMethodParam) {
        this.businessMethod = businessMethodParam;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String targetParam) {
        this.target = targetParam;
    }

    public void setMethodReturn(Object methodReturnParam) {
        this.methodReturn = methodReturnParam;
    }

    public void setMethodParameters(String[] methodParametersParam) {
        this.methodParameters = methodParametersParam;
    }

    public long getParamSize() {
        return this.paramSize;
    }

    public void setParamSize(long paramSize) {
        this.paramSize = paramSize;
    }

    public long getReturnSize() {
        return this.returnSize;
    }

    public void setReturnSize(long returnSize) {
        this.returnSize = returnSize;
    }

    static {
        ObjectEncoder.registerField(InvocationAuditReport.class, "methodParameters", EncodingType.OBJECTTABLE);
        ObjectEncoder.registerField(InvocationAuditReport.class, "methodReturn", EncodingType.OBJECT);
    }
}

