/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ejb.EntityCmpDesc;
import org.ow2.jonas.deployment.ejb.FieldDesc;
import org.ow2.jonas.deployment.ejb.FieldJdbcDesc;
import org.ow2.jonas.deployment.ejb.xml.AssemblyDescriptor;
import org.ow2.jonas.deployment.ejb.xml.Entity;
import org.ow2.jonas.deployment.ejb.xml.JonasEntity;

public class EntityCmp1Desc
extends EntityCmpDesc {
    protected Method isModifiedMethod = null;

    public EntityCmp1Desc(ClassLoader classLoader, Entity ent, AssemblyDescriptor asd, JonasEntity jEnt, JLinkedList jMDRList, String fileName) throws DeploymentDescException {
        super(classLoader, ent, asd, jEnt, jMDRList, fileName);
        for (String fn : this.fieldDesc.keySet()) {
            try {
                Field f = this.ejbClass.getField(fn);
                ((FieldDesc)this.fieldDesc.get(fn)).setFieldType(f.getType());
            }
            catch (NoSuchFieldException e) {
                throw new DeploymentDescException("Invalid field name " + fn + " in field-name in bean " + this.ejbName, e);
            }
            catch (SecurityException e) {
                throw new DeploymentDescException("Cannot use java reflexion on " + this.ejbClass.getName());
            }
        }
        if (jEnt.getIsModifiedMethodName() != null) {
            String mName = jEnt.getIsModifiedMethodName();
            try {
                this.isModifiedMethod = this.ejbClass.getMethod(mName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.isModifiedMethod = null;
                throw new DeploymentDescException(mName + " is not a method of " + this.ejbClass.getName());
            }
            catch (SecurityException e) {
                throw new DeploymentDescException("Cannot use java reflexion on " + this.ejbClass.getName());
            }
        }
        if (this.isUndefinedPK()) {
            FieldDesc fd = this.newFieldDescInstance();
            fd.setName("JONASAUTOPKFIELD");
            fd.setPrimaryKey(true);
            this.fieldDesc.put("JONASAUTOPKFIELD", fd);
            ((FieldDesc)this.fieldDesc.get("JONASAUTOPKFIELD")).setFieldType(Integer.class);
            ((FieldJdbcDesc)this.fieldDesc.get("JONASAUTOPKFIELD")).setJdbcFieldName(this.getJdbcAutomaticPkFieldName());
        }
    }

    public FieldDesc getCmpFieldDesc(Field field) {
        FieldDesc ret = (FieldDesc)this.fieldDesc.get(field.getName());
        if (ret == null) {
            throw new Error("Field " + field.getName() + " is not a cmp field of class " + this.ejbClass.getName());
        }
        return ret;
    }

    public Method getIsModifiedMethod() {
        if (this.isModifiedMethod == null) {
            throw new Error("No isModified method defined for bean " + this.ejbName);
        }
        return this.isModifiedMethod;
    }

    public boolean hasIsModifiedMethod() {
        return this.isModifiedMethod != null;
    }

    public boolean hasCmpFieldDesc(Field field) {
        return this.fieldDesc.containsKey(field.getName());
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(super.toString());
        if (this.hasIsModifiedMethod()) {
            ret.append("getIsModifiedMethod()=" + this.getIsModifiedMethod().toString());
        }
        return ret.toString();
    }
}

