/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cluster.daemon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Validate;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.jndi.ns.NameServiceException;
import org.ow2.carol.jndi.ns.NameServiceManager;
import org.ow2.jonas.cluster.daemon.ClusterDaemonMBean;
import org.ow2.jonas.cluster.daemon.ClusterDaemonTools;
import org.ow2.jonas.cluster.daemon.CmdReaderThread;
import org.ow2.jonas.cluster.daemon.MonitorThread;
import org.ow2.jonas.cluster.daemon.ShutdownHookThread;
import org.ow2.jonas.cluster.daemon.api.ClusterDaemonException;
import org.ow2.jonas.cluster.daemon.mbean.JMXRemoteException;
import org.ow2.jonas.cluster.daemon.mbean.JMXRemoteHelper;
import org.ow2.jonas.cluster.daemon.mbean.MBeanServerException;
import org.ow2.jonas.cluster.daemon.mbean.MBeanServerHelper;
import org.ow2.jonas.deployment.clusterd.xml.Server;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.discovery.jgroups.JgroupsDiscoveryServiceImpl;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.util.Env;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.windows.WinSysEnv;
import org.ow2.jonas.security.auth.spi.RoleBasedAuthorizationModule;

@Component(immediate=true)
@Provides
public class ClusterDaemon
implements ClusterDaemonMBean,
Pojo {
    private InstanceManager __IM;
    public static final int SLEEP_TIME = 2000;
    private static final String TIGHLY_COUPLED = "tighly-coupled";
    private static final String LOOSELY_COUPLED = "loosely-coupled";
    private static final int PING_SHORT_TIMEOUT = 5;
    private static final int PING_LONG_TIMEOUT = 120;
    private static final int PING_SAFETY_TIMEOUT = 2000;
    public static final int SLEEP_DELAY = 2000;
    public static final String LONG_TYPE_DYN_INFO = "long";
    public static final String JONAS_CMD_NAME_WIN_DEF = "jonas.bat";
    public static final String JONAS_CMD_NAME_UNIX_DEF = "jonas";
    public static final String CS_TRACE_FILE_PROPERTY_NAME = "cs.trace.properties.file";
    public static final String CAROL_FILE_PROPERTY_NAME = "carol.properties.file";
    public static final String CONF_FILE_PROPERTY_NAME = "clusterd.conf.file";
    public static final String USE_MONITOR_PROPERTY_NAME = "use.monitor";
    private boolean __FcsTraceFile;
    @Property(name="cs.trace.properties.file")
    private String csTraceFile;
    private boolean __FcarolFile;
    @Property(name="carol.properties.file")
    private String carolFile;
    private boolean __FconfFile;
    @Property(name="clusterd.conf.file")
    private String confFile;
    private boolean __FuseMonitor;
    @Property(name="use.monitor")
    private boolean useMonitor;
    private static String domainName = null;
    private boolean __Flogger;
    private Logger logger;
    private boolean __FobjectName;
    private String objectName;
    private boolean __Fname;
    private String name;
    private boolean __FprocessMap;
    private Map processMap;
    private boolean __FisStarted;
    private boolean isStarted;
    private boolean __FcontrolledServersNames;
    private ArrayList controlledServersNames;
    private boolean __FjmxUrl;
    private String jmxUrl;
    private static RuntimeMXBean runtimeMxbean = null;
    private static ClassLoadingMXBean classLoadingMxBean = null;
    private static OperatingSystemMXBean operatingSystemMxBean = null;
    private static ThreadMXBean threadMxBean = null;
    private static CompilationMXBean compilationMxBean = null;
    private static List<GarbageCollectorMXBean> garbageCollectorMXBean = null;
    private static List<MemoryManagerMXBean> memoryManagerMXBean = null;
    private static MemoryMXBean memoryMXBean = null;
    private static List<MemoryPoolMXBean> memoryPoolMXBean = null;
    private static MBeanServer platFormMbeanServer = null;
    private boolean __FrunTimeSpecVendor;
    private String runTimeSpecVendor;
    private boolean __FrunTimeSpecVersion;
    private String runTimeSpecVersion;
    private boolean __FrunTimeVmName;
    private String runTimeVmName;
    private boolean __FrunTimeVmVendor;
    private String runTimeVmVendor;
    private boolean __FrunTimeVmVersion;
    private String runTimeVmVersion;
    private boolean __FoperatingSystemAvailableProcessors;
    private String operatingSystemAvailableProcessors;
    private boolean __FoperatingSystemName;
    private String operatingSystemName;
    private boolean __FoperatingSystemVersion;
    private String operatingSystemVersion;
    private boolean __FoperatingSystemArch;
    private String operatingSystemArch;
    private boolean __FdynamicHostAttributes;
    private Hashtable<String, String> dynamicHostAttributes;
    private boolean __Fdiscovery;
    private JgroupsDiscoveryServiceImpl discovery;
    private boolean __MgetProcessMap;
    private boolean __MexecJOnASCmd$org_ow2_jonas_deployment_clusterd_xml_Server$java_lang_String$java_lang_String;
    private boolean __MisDefinedUserJonasCmd$org_ow2_jonas_deployment_clusterd_xml_Server;
    private boolean __MgetJOnASCmdName$org_ow2_jonas_deployment_clusterd_xml_Server;
    private boolean __MdoStartJOnAS$java_lang_String$java_lang_String$boolean;
    private boolean __MdoStopJOnAS$java_lang_String;
    private boolean __MdoHaltJOnAS$java_lang_String;
    private boolean __MdoKillJOnAS$java_lang_String;
    private boolean __MwaitEndProcess$java_lang_Process;
    private boolean __MdoPingJOnAS$java_lang_String$int;
    private boolean __MdoCheckState$java_lang_String;
    private boolean __McheckServerState$java_lang_String;
    private boolean __MisServerRunning$java_lang_String;
    private boolean __MinitLogger;
    private boolean __MstartNameService;
    private boolean __MinitMBeans;
    private boolean __MbuildRuntimeInfo;
    private boolean __MisLooselyCoupled;
    private boolean __MisTighlyCoupled;
    private boolean __MgetServer$java_lang_String;
    private boolean __MdoStartAllJOnAS$java_lang_String$java_lang_String$boolean$boolean;
    private boolean __MdoStopAllJOnAS;
    private boolean __MdoKillAllJOnAS;
    private boolean __Mstart;
    private boolean __MstartDiscovery;
    private boolean __MdisplayDynamicAttributes;
    private boolean __MgetObjectName;
    private boolean __MsetObjectName$java_lang_String;
    private boolean __MiseventProvider;
    private boolean __MisstateManageable;
    private boolean __MisstatisticsProvider;
    private boolean __MgetJavaHome4Server$java_lang_String;
    private boolean __MgetJonasBase4Server$java_lang_String;
    private boolean __MgetJonasRoot4Server$java_lang_String;
    private boolean __MgetJonasCmd4Server$java_lang_String;
    private boolean __MgetXprm4Server$java_lang_String;
    private boolean __MgetAutoBoot4Server$java_lang_String;
    private boolean __MgetJmxPort4Server$java_lang_String;
    private boolean __MgetDomain4Server$java_lang_String;
    private boolean __MgetJmxUrl4Server$java_lang_String;
    private boolean __MbuildControlledServersNames;
    private boolean __MflushConfiguration;
    private boolean __MremoveServer$java_lang_String;
    private boolean __Mdelete$java_io_File;
    private boolean __MmodifyServer$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MreloadConfiguration;
    private boolean __MstartJOnAS$java_lang_String$java_lang_String;
    private boolean __MstopJOnAS$java_lang_String;
    private boolean __MhaltJOnAS$java_lang_String;
    private boolean __MpingJOnAS$java_lang_String;
    private boolean __MstartAllJOnAS$java_lang_String$java_lang_String;
    private boolean __MstopAllJOnAS;
    private boolean __MstopClusterDaemon;
    private boolean __MgetName;
    private boolean __MgetControlledServersNames;
    private boolean __MisServerManaged$java_lang_String;
    private boolean __MserversNames;
    private boolean __MgetJmxUrl;
    private boolean __MsetJmxUrl$java_lang_String;
    private boolean __MgetOperatingSystemAvailableProcessors;
    private boolean __MsetOperatingSystemAvailableProcessors$java_lang_String;
    private boolean __MgetOperatingSystemName;
    private boolean __MsetOperatingSystemName$java_lang_String;
    private boolean __MgetOperatingSystemVersion;
    private boolean __MsetOperatingSystemVersion$java_lang_String;
    private boolean __MgetRunTimeSpecVendor;
    private boolean __MsetRunTimeSpecVendor$java_lang_String;
    private boolean __MgetRunTimeSpecVersion;
    private boolean __MsetRunTimeSpecVersion$java_lang_String;
    private boolean __MgetRunTimeVmName;
    private boolean __MsetRunTimeVmName$java_lang_String;
    private boolean __MgetRunTimeVmVendor;
    private boolean __MsetRunTimeVmVendor$java_lang_String;
    private boolean __MgetRunTimeVmVersion;
    private boolean __MsetRunTimeVmVersion$java_lang_String;
    private boolean __MgetDynamicHostAttributes;
    private boolean __MbuildOperatingSystemdynInfo;
    private boolean __MinitHostInfos;
    private boolean __MgetOperatingSystemArch;
    private boolean __MsetOperatingSystemArch$java_lang_String;
    private boolean __MgetVmCurrentUsedNonHeapMemory;
    private boolean __MgetOsCurrentUsedSpace;
    private boolean __MgetOsTotalSpace;
    private boolean __MgetJmxPort$java_lang_String;
    private boolean __MgetJmxPort$java_util_Properties$java_lang_String;
    private boolean __MgenerateReport$java_lang_String;
    private boolean __MgetVmCurrentUsedHeapMemory;
    private boolean __MgetVmCurrentUsedMemory;
    private boolean __MgetVmTotalMemory;
    private boolean __MgetOsAtributeValue$java_lang_String;
    private boolean __MaddServer$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MremoveServer$java_lang_String$java_lang_String;
    private boolean __MsaveConfiguration;

    String __getcsTraceFile() {
        if (!this.__FcsTraceFile) {
            return this.csTraceFile;
        }
        return (String)this.__IM.onGet((Object)this, "csTraceFile");
    }

    void __setcsTraceFile(String string) {
        if (!this.__FcsTraceFile) {
            this.csTraceFile = string;
            return;
        }
        this.__IM.onSet((Object)this, "csTraceFile", (Object)string);
    }

    String __getcarolFile() {
        if (!this.__FcarolFile) {
            return this.carolFile;
        }
        return (String)this.__IM.onGet((Object)this, "carolFile");
    }

    void __setcarolFile(String string) {
        if (!this.__FcarolFile) {
            this.carolFile = string;
            return;
        }
        this.__IM.onSet((Object)this, "carolFile", (Object)string);
    }

    String __getconfFile() {
        if (!this.__FconfFile) {
            return this.confFile;
        }
        return (String)this.__IM.onGet((Object)this, "confFile");
    }

    void __setconfFile(String string) {
        if (!this.__FconfFile) {
            this.confFile = string;
            return;
        }
        this.__IM.onSet((Object)this, "confFile", (Object)string);
    }

    boolean __getuseMonitor() {
        if (!this.__FuseMonitor) {
            return this.useMonitor;
        }
        Object object = this.__IM.onGet((Object)this, "useMonitor");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setuseMonitor(boolean bl) {
        if (!this.__FuseMonitor) {
            this.useMonitor = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "useMonitor", (Object)bl2);
    }

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    String __getobjectName() {
        if (!this.__FobjectName) {
            return this.objectName;
        }
        return (String)this.__IM.onGet((Object)this, "objectName");
    }

    void __setobjectName(String string) {
        if (!this.__FobjectName) {
            this.objectName = string;
            return;
        }
        this.__IM.onSet((Object)this, "objectName", (Object)string);
    }

    String __getname() {
        if (!this.__Fname) {
            return this.name;
        }
        return (String)this.__IM.onGet((Object)this, "name");
    }

    void __setname(String string) {
        if (!this.__Fname) {
            this.name = string;
            return;
        }
        this.__IM.onSet((Object)this, "name", (Object)string);
    }

    Map __getprocessMap() {
        if (!this.__FprocessMap) {
            return this.processMap;
        }
        return (Map)this.__IM.onGet((Object)this, "processMap");
    }

    void __setprocessMap(Map map) {
        if (!this.__FprocessMap) {
            this.processMap = map;
            return;
        }
        this.__IM.onSet((Object)this, "processMap", (Object)map);
    }

    boolean __getisStarted() {
        if (!this.__FisStarted) {
            return this.isStarted;
        }
        Object object = this.__IM.onGet((Object)this, "isStarted");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setisStarted(boolean bl) {
        if (!this.__FisStarted) {
            this.isStarted = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "isStarted", (Object)bl2);
    }

    ArrayList __getcontrolledServersNames() {
        if (!this.__FcontrolledServersNames) {
            return this.controlledServersNames;
        }
        return (ArrayList)this.__IM.onGet((Object)this, "controlledServersNames");
    }

    void __setcontrolledServersNames(ArrayList arrayList) {
        if (!this.__FcontrolledServersNames) {
            this.controlledServersNames = arrayList;
            return;
        }
        this.__IM.onSet((Object)this, "controlledServersNames", (Object)arrayList);
    }

    String __getjmxUrl() {
        if (!this.__FjmxUrl) {
            return this.jmxUrl;
        }
        return (String)this.__IM.onGet((Object)this, "jmxUrl");
    }

    void __setjmxUrl(String string) {
        if (!this.__FjmxUrl) {
            this.jmxUrl = string;
            return;
        }
        this.__IM.onSet((Object)this, "jmxUrl", (Object)string);
    }

    String __getrunTimeSpecVendor() {
        if (!this.__FrunTimeSpecVendor) {
            return this.runTimeSpecVendor;
        }
        return (String)this.__IM.onGet((Object)this, "runTimeSpecVendor");
    }

    void __setrunTimeSpecVendor(String string) {
        if (!this.__FrunTimeSpecVendor) {
            this.runTimeSpecVendor = string;
            return;
        }
        this.__IM.onSet((Object)this, "runTimeSpecVendor", (Object)string);
    }

    String __getrunTimeSpecVersion() {
        if (!this.__FrunTimeSpecVersion) {
            return this.runTimeSpecVersion;
        }
        return (String)this.__IM.onGet((Object)this, "runTimeSpecVersion");
    }

    void __setrunTimeSpecVersion(String string) {
        if (!this.__FrunTimeSpecVersion) {
            this.runTimeSpecVersion = string;
            return;
        }
        this.__IM.onSet((Object)this, "runTimeSpecVersion", (Object)string);
    }

    String __getrunTimeVmName() {
        if (!this.__FrunTimeVmName) {
            return this.runTimeVmName;
        }
        return (String)this.__IM.onGet((Object)this, "runTimeVmName");
    }

    void __setrunTimeVmName(String string) {
        if (!this.__FrunTimeVmName) {
            this.runTimeVmName = string;
            return;
        }
        this.__IM.onSet((Object)this, "runTimeVmName", (Object)string);
    }

    String __getrunTimeVmVendor() {
        if (!this.__FrunTimeVmVendor) {
            return this.runTimeVmVendor;
        }
        return (String)this.__IM.onGet((Object)this, "runTimeVmVendor");
    }

    void __setrunTimeVmVendor(String string) {
        if (!this.__FrunTimeVmVendor) {
            this.runTimeVmVendor = string;
            return;
        }
        this.__IM.onSet((Object)this, "runTimeVmVendor", (Object)string);
    }

    String __getrunTimeVmVersion() {
        if (!this.__FrunTimeVmVersion) {
            return this.runTimeVmVersion;
        }
        return (String)this.__IM.onGet((Object)this, "runTimeVmVersion");
    }

    void __setrunTimeVmVersion(String string) {
        if (!this.__FrunTimeVmVersion) {
            this.runTimeVmVersion = string;
            return;
        }
        this.__IM.onSet((Object)this, "runTimeVmVersion", (Object)string);
    }

    String __getoperatingSystemAvailableProcessors() {
        if (!this.__FoperatingSystemAvailableProcessors) {
            return this.operatingSystemAvailableProcessors;
        }
        return (String)this.__IM.onGet((Object)this, "operatingSystemAvailableProcessors");
    }

    void __setoperatingSystemAvailableProcessors(String string) {
        if (!this.__FoperatingSystemAvailableProcessors) {
            this.operatingSystemAvailableProcessors = string;
            return;
        }
        this.__IM.onSet((Object)this, "operatingSystemAvailableProcessors", (Object)string);
    }

    String __getoperatingSystemName() {
        if (!this.__FoperatingSystemName) {
            return this.operatingSystemName;
        }
        return (String)this.__IM.onGet((Object)this, "operatingSystemName");
    }

    void __setoperatingSystemName(String string) {
        if (!this.__FoperatingSystemName) {
            this.operatingSystemName = string;
            return;
        }
        this.__IM.onSet((Object)this, "operatingSystemName", (Object)string);
    }

    String __getoperatingSystemVersion() {
        if (!this.__FoperatingSystemVersion) {
            return this.operatingSystemVersion;
        }
        return (String)this.__IM.onGet((Object)this, "operatingSystemVersion");
    }

    void __setoperatingSystemVersion(String string) {
        if (!this.__FoperatingSystemVersion) {
            this.operatingSystemVersion = string;
            return;
        }
        this.__IM.onSet((Object)this, "operatingSystemVersion", (Object)string);
    }

    String __getoperatingSystemArch() {
        if (!this.__FoperatingSystemArch) {
            return this.operatingSystemArch;
        }
        return (String)this.__IM.onGet((Object)this, "operatingSystemArch");
    }

    void __setoperatingSystemArch(String string) {
        if (!this.__FoperatingSystemArch) {
            this.operatingSystemArch = string;
            return;
        }
        this.__IM.onSet((Object)this, "operatingSystemArch", (Object)string);
    }

    Hashtable __getdynamicHostAttributes() {
        if (!this.__FdynamicHostAttributes) {
            return this.dynamicHostAttributes;
        }
        return (Hashtable)this.__IM.onGet((Object)this, "dynamicHostAttributes");
    }

    void __setdynamicHostAttributes(Hashtable hashtable) {
        if (!this.__FdynamicHostAttributes) {
            this.dynamicHostAttributes = hashtable;
            return;
        }
        this.__IM.onSet((Object)this, "dynamicHostAttributes", (Object)hashtable);
    }

    JgroupsDiscoveryServiceImpl __getdiscovery() {
        if (!this.__Fdiscovery) {
            return this.discovery;
        }
        return (JgroupsDiscoveryServiceImpl)this.__IM.onGet((Object)this, "discovery");
    }

    void __setdiscovery(JgroupsDiscoveryServiceImpl jgroupsDiscoveryServiceImpl) {
        if (!this.__Fdiscovery) {
            this.discovery = jgroupsDiscoveryServiceImpl;
            return;
        }
        this.__IM.onSet((Object)this, "discovery", (Object)jgroupsDiscoveryServiceImpl);
    }

    public ClusterDaemon() {
        this(null);
    }

    private ClusterDaemon(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setcsTraceFile(null);
        this.__setcarolFile(null);
        this.__setconfFile(null);
        this.__setuseMonitor(false);
        this.__setlogger(null);
        this.__setobjectName(null);
        this.__setname(null);
        this.__setprocessMap(new HashMap());
        this.__setisStarted(false);
        this.__setjmxUrl(null);
        this.__setrunTimeSpecVendor(null);
        this.__setrunTimeSpecVersion(null);
        this.__setrunTimeVmName(null);
        this.__setrunTimeVmVendor(null);
        this.__setrunTimeVmVersion(null);
        this.__setoperatingSystemAvailableProcessors(null);
        this.__setoperatingSystemName(null);
        this.__setoperatingSystemVersion(null);
        this.__setoperatingSystemArch(null);
        this.__setdynamicHostAttributes(null);
        this.__setdiscovery(null);
    }

    public Map getProcessMap() {
        Map map;
        if (!this.__MgetProcessMap) {
            return this.__M_getProcessMap();
        }
        try {
            this.__IM.onEntry((Object)this, "getProcessMap", new Object[0]);
            map = this.__M_getProcessMap();
            this.__IM.onExit((Object)this, "getProcessMap", (Object)map);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProcessMap", throwable);
            throw throwable;
        }
        return map;
    }

    private Map __M_getProcessMap() {
        return this.__getprocessMap();
    }

    private Process execJOnASCmd(Server server, String cmd, String keyCmd) throws Exception {
        Process process;
        if (!this.__MexecJOnASCmd$org_ow2_jonas_deployment_clusterd_xml_Server$java_lang_String$java_lang_String) {
            return this.__M_execJOnASCmd(server, cmd, keyCmd);
        }
        try {
            this.__IM.onEntry((Object)this, "execJOnASCmd$org_ow2_jonas_deployment_clusterd_xml_Server$java_lang_String$java_lang_String", new Object[]{server, cmd, keyCmd});
            process = this.__M_execJOnASCmd(server, cmd, keyCmd);
            this.__IM.onExit((Object)this, "execJOnASCmd$org_ow2_jonas_deployment_clusterd_xml_Server$java_lang_String$java_lang_String", (Object)process);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execJOnASCmd$org_ow2_jonas_deployment_clusterd_xml_Server$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return process;
    }

    private Process __M_execJOnASCmd(Server server, String cmd, String keyCmd) throws Exception {
        String jettyHome;
        if (server == null) {
            throw new ClusterDaemonException("server=null");
        }
        Process previousP = (Process)this.__getprocessMap().get(keyCmd);
        if (previousP != null) {
            try {
                this.__getlogger().log(BasicLevel.INFO, (Object)("Cmd =" + cmd + " Process=" + previousP.exitValue()));
            }
            catch (IllegalThreadStateException exc) {
                this.__getlogger().log(BasicLevel.INFO, (Object)("Cmd =" + cmd + " already running (pid=" + previousP.toString() + ")."));
                throw new IllegalStateException("Cmd =" + cmd + " already running (pid=" + previousP.toString() + ").");
            }
        }
        Vector<String> envv = new Vector<String>();
        envv.addElement("JAVA_HOME=" + server.getJavaHome());
        envv.addElement("JONAS_ROOT=" + server.getJonasRoot());
        envv.addElement("JONAS_BASE=" + server.getJonasBase());
        String catalinaHome = System.getProperty("catalina.home");
        if (catalinaHome != null) {
            envv.addElement("CATALINA_HOME=" + catalinaHome);
            envv.addElement("CATALINA_BASE=" + server.getJonasBase());
        }
        if ((jettyHome = System.getProperty("jetty.home")) != null) {
            envv.addElement("JETTY_HOME=" + jettyHome);
        }
        if (Env.isOsWindows()) {
            envv.addElement("SystemRoot=" + WinSysEnv.get((String)"SystemRoot"));
        }
        Object[] enva = new String[envv.size()];
        envv.copyInto(enva);
        String binDir = null;
        if (this.isDefinedUserJonasCmd(server)) {
            this.__getlogger().log(BasicLevel.INFO, (Object)"User cmd - don't add the jonas-root prefix dir");
            binDir = "";
        } else {
            this.__getlogger().log(BasicLevel.INFO, (Object)"Default cmd - add the jonas-root prefix dir");
            binDir = server.getJonasRoot();
            if (File.separatorChar == '/') {
                binDir = binDir + "/bin/";
            } else if (File.separatorChar == '\\') {
                binDir = binDir + "\\bin\\";
            }
        }
        String[] cmda = null;
        if (cmd != null) {
            cmda = (binDir + cmd).split("\\s+");
        }
        File workingDirectory = new File(".");
        this.__getlogger().log(BasicLevel.INFO, (Object)("Execute the command <" + binDir + cmd + "> with the env " + envv));
        Process p = Runtime.getRuntime().exec(cmda, (String[])enva, workingDirectory);
        this.__getprocessMap().put(keyCmd, p);
        Thread.sleep(2000L);
        InputStream cmdError = p.getErrorStream();
        InputStream cmdOut = p.getInputStream();
        Thread err = new Thread(new CmdReaderThread(this.__getlogger(), keyCmd, cmdError, true));
        Thread out = new Thread(new CmdReaderThread(this.__getlogger(), keyCmd, cmdOut, false));
        out.start();
        err.start();
        int action = 0;
        if (keyCmd.startsWith("start") && this.isTighlyCoupled()) {
            action = 1;
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownHookThread(server.getName(), keyCmd, action, this, this.__getlogger()));
        this.__getlogger().log(BasicLevel.INFO, (Object)("Command " + cmd + " with the env " + envv + " launched"));
        return p;
    }

    private boolean isDefinedUserJonasCmd(Server server) {
        boolean bl;
        if (!this.__MisDefinedUserJonasCmd$org_ow2_jonas_deployment_clusterd_xml_Server) {
            return this.__M_isDefinedUserJonasCmd(server);
        }
        try {
            this.__IM.onEntry((Object)this, "isDefinedUserJonasCmd$org_ow2_jonas_deployment_clusterd_xml_Server", new Object[]{server});
            bl = this.__M_isDefinedUserJonasCmd(server);
            this.__IM.onExit((Object)this, "isDefinedUserJonasCmd$org_ow2_jonas_deployment_clusterd_xml_Server", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isDefinedUserJonasCmd$org_ow2_jonas_deployment_clusterd_xml_Server", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isDefinedUserJonasCmd(Server server) {
        if (server.getJonasCmd() == null) {
            return false;
        }
        return !server.getJonasCmd().trim().equals("");
    }

    private String getJOnASCmdName(Server server) {
        String string;
        if (!this.__MgetJOnASCmdName$org_ow2_jonas_deployment_clusterd_xml_Server) {
            return this.__M_getJOnASCmdName(server);
        }
        try {
            this.__IM.onEntry((Object)this, "getJOnASCmdName$org_ow2_jonas_deployment_clusterd_xml_Server", new Object[]{server});
            string = this.__M_getJOnASCmdName(server);
            this.__IM.onExit((Object)this, "getJOnASCmdName$org_ow2_jonas_deployment_clusterd_xml_Server", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJOnASCmdName$org_ow2_jonas_deployment_clusterd_xml_Server", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getJOnASCmdName(Server server) {
        if (this.isDefinedUserJonasCmd(server)) {
            return server.getJonasCmd().trim();
        }
        if (Env.isOsWindows()) {
            return JONAS_CMD_NAME_WIN_DEF;
        }
        return JONAS_CMD_NAME_UNIX_DEF;
    }

    private void doStartJOnAS(String name, String prm, boolean sync) throws ClusterDaemonException {
        if (!this.__MdoStartJOnAS$java_lang_String$java_lang_String$boolean) {
            this.__M_doStartJOnAS(name, prm, sync);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStartJOnAS$java_lang_String$java_lang_String$boolean", new Object[]{name, prm, new Boolean(sync)});
            this.__M_doStartJOnAS(name, prm, sync);
            this.__IM.onExit((Object)this, "doStartJOnAS$java_lang_String$java_lang_String$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStartJOnAS$java_lang_String$java_lang_String$boolean", throwable);
            throw throwable;
        }
    }

    private void __M_doStartJOnAS(String name, String prm, boolean sync) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server == null) {
            throw new ClusterDaemonException("JOnAS server " + name + " is not known by the cluster daemon " + this.getName());
        }
        String xprm = null;
        xprm = prm == null ? "" : prm;
        if (server.getXprm() != null) {
            xprm = xprm + server.getXprm();
        }
        String d = this.getDomain4Server(name);
        String cmd = this.getJOnASCmdName(server) + " start -n " + name + " -Ddomain.name=" + d + " " + xprm;
        if (this.isTighlyCoupled()) {
            cmd = cmd + " -fg";
        }
        this.__getlogger().log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " is starting ..."));
        String keyCmd = "start/" + name;
        Process p = null;
        try {
            p = this.execJOnASCmd(server, cmd, keyCmd);
        }
        catch (Throwable t) {
            this.__getlogger().log(BasicLevel.ERROR, (Object)("Unable to start the JOnAS instance <" + name + ">, cmd=<" + cmd + ">"), t);
            throw new ClusterDaemonException("Unable to start the JOnAS instance <" + name + ">, cmd=<" + cmd + ">", t);
        }
        this.__getlogger().log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " launched"));
        if (sync) {
            if (this.isLooselyCoupled()) {
                int exitCode = this.waitEndProcess(p);
            } else if (this.doPingJOnAS(name, 120) == 1) {
                throw new ClusterDaemonException("Unable to start the JOnAS instance " + name + " - unreachable server");
            }
            this.__getlogger().log(BasicLevel.INFO, (Object)("JOnAS instance " + name + "  started"));
        }
    }

    public void doStopJOnAS(String name) throws ClusterDaemonException {
        if (!this.__MdoStopJOnAS$java_lang_String) {
            this.__M_doStopJOnAS(name);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStopJOnAS$java_lang_String", new Object[]{name});
            this.__M_doStopJOnAS(name);
            this.__IM.onExit((Object)this, "doStopJOnAS$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStopJOnAS$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_doStopJOnAS(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server == null) {
            throw new ClusterDaemonException("JOnAS instance " + name + " doesn't exist");
        }
        String cmd = this.getJOnASCmdName(server) + " stop -n " + server.getName();
        this.__getlogger().log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " is stopping ..."));
        String keyCmd = "stop/" + server.getName();
        Process p = null;
        try {
            p = this.execJOnASCmd(server, cmd, keyCmd);
        }
        catch (Throwable t) {
            this.__getlogger().log(BasicLevel.ERROR, (Object)("Unable to stop the JOnAS instance <" + name + ">, cmd=<" + cmd + ">"), t);
            throw new ClusterDaemonException("Unable to stop the JOnAS instance <" + name + ">, cmd=<" + cmd + ">", t);
        }
        int exitCode = this.waitEndProcess(p);
        this.__getlogger().log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " stopped"));
    }

    private void doHaltJOnAS(String name) throws ClusterDaemonException {
        if (!this.__MdoHaltJOnAS$java_lang_String) {
            this.__M_doHaltJOnAS(name);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doHaltJOnAS$java_lang_String", new Object[]{name});
            this.__M_doHaltJOnAS(name);
            this.__IM.onExit((Object)this, "doHaltJOnAS$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doHaltJOnAS$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_doHaltJOnAS(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server == null) {
            throw new ClusterDaemonException("JOnAS instance " + name + " doesn't exist");
        }
        String cmd = this.getJOnASCmdName(server) + " halt -n " + server.getName();
        this.__getlogger().log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " is halting ..."));
        String keyCmd = "halt/" + server.getName();
        Process p = null;
        try {
            p = this.execJOnASCmd(server, cmd, keyCmd);
        }
        catch (Throwable t) {
            this.__getlogger().log(BasicLevel.ERROR, (Object)("Unable to halt the JOnAS instance <" + name + ">, cmd=<" + cmd + ">"), t);
            throw new ClusterDaemonException("Unable to halt the JOnAS instance <" + name + ">, cmd=<" + cmd + ">", t);
        }
        int exitCode = this.waitEndProcess(p);
        this.__getlogger().log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " halted"));
    }

    private void doKillJOnAS(String name) throws ClusterDaemonException {
        if (!this.__MdoKillJOnAS$java_lang_String) {
            this.__M_doKillJOnAS(name);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doKillJOnAS$java_lang_String", new Object[]{name});
            this.__M_doKillJOnAS(name);
            this.__IM.onExit((Object)this, "doKillJOnAS$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doKillJOnAS$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_doKillJOnAS(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server == null) {
            throw new ClusterDaemonException("JOnAS instance " + name + " doesn't exist");
        }
        if (this.isLooselyCoupled()) {
            throw new ClusterDaemonException("Command not compatible with the loosely-coupled mode");
        }
        String keyCmd = "start/" + server.getName();
        Process p = (Process)this.__getprocessMap().get(keyCmd);
        boolean alive = false;
        try {
            this.__getlogger().log(BasicLevel.DEBUG, (Object)("Process=" + p.exitValue()));
            this.__getlogger().log(BasicLevel.DEBUG, (Object)("JOnAS instance " + name + " is already dead"));
        }
        catch (IllegalThreadStateException exc) {
            this.__getlogger().log(BasicLevel.DEBUG, (Object)("JOnAS instance " + server.getName() + " is going to be killed"));
            alive = true;
        }
        if (alive) {
            p.destroy();
            this.__getlogger().log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " killed"));
        } else {
            this.__getlogger().log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " already killed"));
        }
    }

    private int waitEndProcess(Process p) {
        int n;
        if (!this.__MwaitEndProcess$java_lang_Process) {
            return this.__M_waitEndProcess(p);
        }
        try {
            this.__IM.onEntry((Object)this, "waitEndProcess$java_lang_Process", new Object[]{p});
            n = this.__M_waitEndProcess(p);
            this.__IM.onExit((Object)this, "waitEndProcess$java_lang_Process", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "waitEndProcess$java_lang_Process", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_waitEndProcess(Process p) {
        if (p == null) {
            return -1;
        }
        boolean isRunning = true;
        int exitCode = -1;
        while (isRunning) {
            this.__getlogger().log(BasicLevel.DEBUG, (Object)("check if the process " + p + " is running"));
            try {
                exitCode = p.exitValue();
                this.__getlogger().log(BasicLevel.DEBUG, (Object)("cmd " + p + " is finished"));
                isRunning = false;
            }
            catch (IllegalThreadStateException exc) {
                this.__getlogger().log(BasicLevel.DEBUG, (Object)("cmd " + p + " is still running"));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.__getlogger().log(BasicLevel.DEBUG, (Object)e);
                }
            }
        }
        return exitCode;
    }

    private int doPingJOnAS(String name, int timeout) throws ClusterDaemonException {
        int n;
        if (!this.__MdoPingJOnAS$java_lang_String$int) {
            return this.__M_doPingJOnAS(name, timeout);
        }
        try {
            this.__IM.onEntry((Object)this, "doPingJOnAS$java_lang_String$int", new Object[]{name, new Integer(timeout)});
            n = this.__M_doPingJOnAS(name, timeout);
            this.__IM.onExit((Object)this, "doPingJOnAS$java_lang_String$int", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doPingJOnAS$java_lang_String$int", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_doPingJOnAS(String name, int timeout) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server == null) {
            throw new ClusterDaemonException("JOnAS instance " + name + " doesn't exist");
        }
        String jonasBase = this.getJonasBase4Server(name);
        String cmd = this.getJOnASCmdName(server) + " admin -n " + server.getName() + " -ping -timeout " + timeout;
        this.__getlogger().log(BasicLevel.INFO, (Object)("Ping JOnAS instance " + name + " ..."));
        String keyCmd = "ping/" + server.getName();
        try {
            this.execJOnASCmd(server, cmd, keyCmd);
        }
        catch (Throwable t) {
            this.__getlogger().log(BasicLevel.ERROR, (Object)("Unable to ping the JOnAS instance <" + name + ">, cmd=<" + cmd + ">"), t);
            throw new ClusterDaemonException("Unable to ping the JOnAS instance <" + name + ">, cmd=<" + cmd + ">", t);
        }
        Process p = (Process)this.__getprocessMap().get(keyCmd);
        int exitCode = this.waitEndProcess(p);
        this.__getlogger().log(BasicLevel.INFO, (Object)("Ping JOnAS instance " + name + " return " + exitCode));
        return exitCode;
    }

    private boolean doCheckState(String name) throws ClusterDaemonException {
        boolean bl;
        if (!this.__MdoCheckState$java_lang_String) {
            return this.__M_doCheckState(name);
        }
        try {
            this.__IM.onEntry((Object)this, "doCheckState$java_lang_String", new Object[]{name});
            bl = this.__M_doCheckState(name);
            this.__IM.onExit((Object)this, "doCheckState$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doCheckState$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_doCheckState(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server == null) {
            throw new ClusterDaemonException("JOnAS instance " + name + " doesn't exist");
        }
        if (this.isLooselyCoupled()) {
            throw new ClusterDaemonException("Command not compatible with the loosely-coupled mode");
        }
        String keyCmd = "start/" + server.getName();
        Process p = (Process)this.__getprocessMap().get(keyCmd);
        boolean alive = false;
        try {
            this.__getlogger().log(BasicLevel.DEBUG, (Object)("Process=" + p.exitValue()));
            this.__getlogger().log(BasicLevel.DEBUG, (Object)("JOnAS instance " + name + " is STOPPED"));
        }
        catch (IllegalThreadStateException exc) {
            this.__getlogger().log(BasicLevel.DEBUG, (Object)("JOnAS instance " + server.getName() + " is RUNNING"));
            alive = true;
        }
        return alive;
    }

    public boolean checkServerState(String srvName) throws ClusterDaemonException {
        boolean bl;
        if (!this.__McheckServerState$java_lang_String) {
            return this.__M_checkServerState(srvName);
        }
        try {
            this.__IM.onEntry((Object)this, "checkServerState$java_lang_String", new Object[]{srvName});
            bl = this.__M_checkServerState(srvName);
            this.__IM.onExit((Object)this, "checkServerState$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "checkServerState$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_checkServerState(String srvName) throws ClusterDaemonException {
        boolean running = false;
        try {
            running = this.doCheckState(srvName);
        }
        catch (ClusterDaemonException e) {
            this.__getlogger().log(BasicLevel.DEBUG, (Object)("Unabale to get Server State" + (Object)((Object)e)));
            throw e;
        }
        return running;
    }

    public boolean isServerRunning(String serverName) {
        boolean bl;
        if (!this.__MisServerRunning$java_lang_String) {
            return this.__M_isServerRunning(serverName);
        }
        try {
            this.__IM.onEntry((Object)this, "isServerRunning$java_lang_String", new Object[]{serverName});
            bl = this.__M_isServerRunning(serverName);
            this.__IM.onExit((Object)this, "isServerRunning$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isServerRunning$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isServerRunning(String serverName) {
        int exitCode = -1;
        try {
            exitCode = this.pingJOnAS(serverName);
        }
        catch (ClusterDaemonException e) {
            boolean bl = false;
        }
        boolean isServerRunning = exitCode == 0;
        return isServerRunning;
    }

    private void initLogger() throws ClusterDaemonException {
        if (!this.__MinitLogger) {
            this.__M_initLogger();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initLogger", new Object[0]);
            this.__M_initLogger();
            this.__IM.onExit((Object)this, "initLogger", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initLogger", throwable);
            throw throwable;
        }
    }

    private void __M_initLogger() throws ClusterDaemonException {
        if (this.__getcsTraceFile() != null) {
            File tClient = new File(this.__getcsTraceFile());
            if (!tClient.exists()) {
                throw new ClusterDaemonException("The file '" + this.__getcsTraceFile() + "' was not found.");
            }
            if (!tClient.isFile()) {
                throw new ClusterDaemonException("The file '" + this.__getcsTraceFile() + "' is not a valid file. Maybe a directory ?");
            }
            System.setProperty("jonas.client.trace.file", this.__getcsTraceFile());
            Log.reset();
        } else {
            this.__setcsTraceFile("trace");
        }
        try {
            System.setProperty("jonas.client.trace.file", this.__getcsTraceFile());
            Log.configure((String)this.__getcsTraceFile());
        }
        catch (NoClassDefFoundError ncdfe) {
            ncdfe.printStackTrace();
        }
        this.__setlogger(Log.getLogger((String)"org.ow2.jonas.cluster.daemon"));
    }

    private void startNameService() throws ClusterDaemonException {
        if (!this.__MstartNameService) {
            this.__M_startNameService();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startNameService", new Object[0]);
            this.__M_startNameService();
            this.__IM.onExit((Object)this, "startNameService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startNameService", throwable);
            throw throwable;
        }
    }

    private void __M_startNameService() throws ClusterDaemonException {
        NameServiceManager nameServiceManager = NameServiceManager.getNameServiceManager();
        if (!nameServiceManager.isStarted()) {
            this.__getlogger().log(BasicLevel.INFO, (Object)"Name service was not started, starting now.");
            try {
                nameServiceManager.startNS();
            }
            catch (NameServiceException e) {
                throw new ClusterDaemonException("Cannot start registry", (Throwable)e);
            }
        } else {
            this.__getlogger().log(BasicLevel.INFO, (Object)"Name service was already started, skipping.");
        }
    }

    private void initMBeans() throws ClusterDaemonException {
        if (!this.__MinitMBeans) {
            this.__M_initMBeans();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initMBeans", new Object[0]);
            this.__M_initMBeans();
            this.__IM.onExit((Object)this, "initMBeans", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initMBeans", throwable);
            throw throwable;
        }
    }

    private void __M_initMBeans() throws ClusterDaemonException {
        block22: {
            try {
                MBeanServerHelper.startMBeanServer(domainName);
            }
            catch (MBeanServerException e) {
                throw new ClusterDaemonException("Cannot start MBean server", (Throwable)e);
            }
            try {
                HashMap<String, String> props = null;
                this.__setname(ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getName());
                String url = ClusterDaemonTools.getJmxUrl(this.__getname());
                String objName = ClusterDaemonTools.getObjectName();
                boolean jmxSecured = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().isJmxSecured();
                MBeanServerForwarder forwarder = null;
                if (jmxSecured) {
                    props = new HashMap<String, String>();
                    String fileSeparator = System.getProperty("file.separator");
                    String loginModule = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getJmxAuthenticationMethod();
                    String loginParam = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getJmxAuthenticationParameter();
                    if (loginModule != null && loginParam != null) {
                        if ("jmx.remote.x.password.file".equals(loginModule)) {
                            props.put(loginModule, JProp.getJonasBase() + fileSeparator + loginParam);
                        } else {
                            props.put(loginModule, loginParam);
                        }
                    }
                    String authModule = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getJmxAuthorizationMethod();
                    String authParam = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getJmxAuthorizationParameter();
                    if (authModule != null && authParam != null) {
                        if (authModule.startsWith("jmx.remote.x.access.rolebased")) {
                            forwarder = RoleBasedAuthorizationModule.newProxyInstance((String)authModule.substring("jmx.remote.x.access.rolebased".length() + 1), (String)authParam);
                        } else if ("jmx.remote.x.access.file".equals(authModule)) {
                            props.put(authModule, JProp.getJonasBase() + fileSeparator + authParam);
                        } else {
                            props.put(authModule, authParam);
                        }
                    }
                }
                JMXConnectorServer connectorServer = JMXRemoteHelper.startConnector(url, objName, props);
                if (forwarder != null) {
                    connectorServer.setMBeanServerForwarder(forwarder);
                }
                this.__getlogger().log(BasicLevel.INFO, (Object)("JMX remote connector (" + url + ", " + objName + " started "));
                this.setJmxUrl(url);
                if (jmxSecured) {
                    try {
                        JMXConnectorFactory.connect(new JMXServiceURL(url)).close();
                        this.__getlogger().log(BasicLevel.WARN, (Object)"JMX security is enabled but anonymous logins are still accepted! Please check your JMX security configuration.");
                        break block22;
                    }
                    catch (SecurityException e) {
                        this.__getlogger().log(BasicLevel.INFO, (Object)"JMX security is enabled and active");
                        break block22;
                    }
                    catch (Exception e) {
                        throw new ClusterDaemonException("Cannot test JMX security", (Throwable)e);
                    }
                }
                this.__getlogger().log(BasicLevel.WARN, (Object)"JMX security is DISABLED");
            }
            catch (JMXRemoteException e) {
                throw new ClusterDaemonException("Cannot start JMX Remote connector", (Throwable)e);
            }
        }
        StringBuffer sb = new StringBuffer(domainName);
        sb.append(":type=ClusterDaemon");
        ObjectName on = null;
        try {
            on = new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new ClusterDaemonException("Cannot build ObjectName", (Throwable)e);
        }
        try {
            MBeanServerHelper.getMBeanServer().registerMBean(this, on);
            this.__getlogger().log(BasicLevel.DEBUG, (Object)("MBean (" + on + ") registered"));
        }
        catch (Exception e) {
            throw new ClusterDaemonException("Cannot register MBean '" + on + "' in MBeanServer", (Throwable)e);
        }
        this.setObjectName(on.toString());
        this.__getlogger().log(BasicLevel.INFO, (Object)"MBeans initialized");
    }

    public void buildRuntimeInfo() {
        if (!this.__MbuildRuntimeInfo) {
            this.__M_buildRuntimeInfo();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "buildRuntimeInfo", new Object[0]);
            this.__M_buildRuntimeInfo();
            this.__IM.onExit((Object)this, "buildRuntimeInfo", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "buildRuntimeInfo", throwable);
            throw throwable;
        }
    }

    private void __M_buildRuntimeInfo() {
        this.__getlogger().log(BasicLevel.INFO, (Object)"getting Runtime Mbean");
        RuntimeMXBean mxbean = ManagementFactory.getRuntimeMXBean();
        String vendor = mxbean.getVmVendor();
    }

    private boolean isLooselyCoupled() {
        boolean bl;
        if (!this.__MisLooselyCoupled) {
            return this.__M_isLooselyCoupled();
        }
        try {
            this.__IM.onEntry((Object)this, "isLooselyCoupled", new Object[0]);
            bl = this.__M_isLooselyCoupled();
            this.__IM.onExit((Object)this, "isLooselyCoupled", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isLooselyCoupled", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isLooselyCoupled() {
        String mode = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getJonasInteractionMode();
        return LOOSELY_COUPLED.equals(mode);
    }

    private boolean isTighlyCoupled() {
        boolean bl;
        if (!this.__MisTighlyCoupled) {
            return this.__M_isTighlyCoupled();
        }
        try {
            this.__IM.onEntry((Object)this, "isTighlyCoupled", new Object[0]);
            bl = this.__M_isTighlyCoupled();
            this.__IM.onExit((Object)this, "isTighlyCoupled", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isTighlyCoupled", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isTighlyCoupled() {
        String mode = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getJonasInteractionMode();
        return TIGHLY_COUPLED.equals(mode);
    }

    private Server getServer(String name) throws ClusterDaemonException {
        Server server;
        if (!this.__MgetServer$java_lang_String) {
            return this.__M_getServer(name);
        }
        try {
            this.__IM.onEntry((Object)this, "getServer$java_lang_String", new Object[]{name});
            server = this.__M_getServer(name);
            this.__IM.onExit((Object)this, "getServer$java_lang_String", (Object)server);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServer$java_lang_String", throwable);
            throw throwable;
        }
        return server;
    }

    private Server __M_getServer(String name) throws ClusterDaemonException {
        try {
            JLinkedList servers = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList();
            if (servers != null) {
                for (int i = 0; i < servers.size(); ++i) {
                    Server serverElement = (Server)servers.get(i);
                    if (!serverElement.getName().equals(name)) continue;
                    return serverElement;
                }
            }
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
        return null;
    }

    private String doStartAllJOnAS(String domainName, String prm, boolean force, boolean sync) throws ClusterDaemonException {
        String string;
        if (!this.__MdoStartAllJOnAS$java_lang_String$java_lang_String$boolean$boolean) {
            return this.__M_doStartAllJOnAS(domainName, prm, force, sync);
        }
        try {
            this.__IM.onEntry((Object)this, "doStartAllJOnAS$java_lang_String$java_lang_String$boolean$boolean", new Object[]{domainName, prm, new Boolean(force), new Boolean(sync)});
            string = this.__M_doStartAllJOnAS(domainName, prm, force, sync);
            this.__IM.onExit((Object)this, "doStartAllJOnAS$java_lang_String$java_lang_String$boolean$boolean", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStartAllJOnAS$java_lang_String$java_lang_String$boolean$boolean", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_doStartAllJOnAS(String domainName, String prm, boolean force, boolean sync) throws ClusterDaemonException {
        try {
            if (!force) {
                if (this.isLooselyCoupled()) {
                    String result = "JOnAS interaction mode is set to loosely-coupled => don't start the JOnAS instances";
                    this.__getlogger().log(BasicLevel.INFO, (Object)result);
                    return result;
                }
                this.__getlogger().log(BasicLevel.INFO, (Object)"JOnAS interaction mode is set to tighly-coupled => start the JOnAS instances");
            }
            int nbInst = 0;
            int nbInstStarted = 0;
            String instStarted = "";
            int nbInstStartingError = 0;
            String instStartingError = "";
            JLinkedList servers = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList();
            if (servers != null) {
                for (int i = 0; i < servers.size(); ++i) {
                    ++nbInst;
                    Server serverElement = (Server)servers.get(i);
                    if (!serverElement.isAutoBoot() && !force) continue;
                    try {
                        this.doStartJOnAS(serverElement.getName(), prm, sync);
                        ++nbInstStarted;
                        instStarted = instStarted + serverElement.getName() + " ";
                        continue;
                    }
                    catch (ClusterDaemonException e) {
                        this.__getlogger().log(BasicLevel.ERROR, (Object)("Error during the launching of JOnAS instance " + serverElement.getName()), (Throwable)e);
                        ++nbInstStartingError;
                        instStartingError = instStartingError + serverElement.getName() + " ex=" + (Object)((Object)e) + " ";
                    }
                }
            }
            String result = "Instances started (" + nbInstStarted + "/" + nbInst + ", " + instStarted + ")";
            result = result + " Instances starting failed (" + nbInstStartingError + "/" + nbInst + ", " + instStartingError + ")";
            this.__getlogger().log(BasicLevel.INFO, (Object)result);
            return result;
        }
        catch (Exception e) {
            if (e instanceof ClusterDaemonException) {
                throw (ClusterDaemonException)((Object)e);
            }
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    private String doStopAllJOnAS() {
        String string;
        if (!this.__MdoStopAllJOnAS) {
            return this.__M_doStopAllJOnAS();
        }
        try {
            this.__IM.onEntry((Object)this, "doStopAllJOnAS", new Object[0]);
            string = this.__M_doStopAllJOnAS();
            this.__IM.onExit((Object)this, "doStopAllJOnAS", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStopAllJOnAS", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_doStopAllJOnAS() {
        int nbInst = 0;
        int nbInstStopped = 0;
        String instStopped = "";
        int nbInstStoppingError = 0;
        String instStoppingError = "";
        JLinkedList servers = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList();
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Server serverElement = (Server)servers.get(i);
                try {
                    this.doStopJOnAS(serverElement.getName());
                    ++nbInstStopped;
                    instStopped = instStopped + serverElement.getName() + " ";
                    continue;
                }
                catch (ClusterDaemonException e) {
                    this.__getlogger().log(BasicLevel.ERROR, (Object)("Error during the stopping of JOnAS instance " + serverElement.getName()), (Throwable)e);
                    ++nbInstStoppingError;
                    instStoppingError = instStoppingError + serverElement.getName() + " ex=" + (Object)((Object)e) + " ";
                }
            }
        }
        String result = "Instances stopped (" + nbInstStopped + "/" + nbInst + ", " + instStopped + ")";
        result = result + " Instances stopping failed (" + nbInstStoppingError + "/" + nbInst + ", " + instStoppingError + ")";
        this.__getlogger().log(BasicLevel.INFO, (Object)result);
        return result;
    }

    private String doKillAllJOnAS() {
        String string;
        if (!this.__MdoKillAllJOnAS) {
            return this.__M_doKillAllJOnAS();
        }
        try {
            this.__IM.onEntry((Object)this, "doKillAllJOnAS", new Object[0]);
            string = this.__M_doKillAllJOnAS();
            this.__IM.onExit((Object)this, "doKillAllJOnAS", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doKillAllJOnAS", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_doKillAllJOnAS() {
        int nbInst = 0;
        int nbInstKilled = 0;
        String instKilled = "";
        int nbInstKillingError = 0;
        String instKillingError = "";
        JLinkedList servers = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList();
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Server serverElement = (Server)servers.get(i);
                try {
                    this.doKillJOnAS(serverElement.getName());
                    ++nbInstKilled;
                    instKilled = instKilled + serverElement.getName() + " ";
                    continue;
                }
                catch (ClusterDaemonException e) {
                    this.__getlogger().log(BasicLevel.ERROR, (Object)("Error during the killing of JOnAS instance " + serverElement.getName()), (Throwable)e);
                    ++nbInstKillingError;
                    instKillingError = instKillingError + serverElement.getName() + " ex=" + (Object)((Object)e) + " ";
                }
            }
        }
        String result = "Instances killed (" + nbInstKilled + "/" + nbInst + ", " + instKilled + ")";
        result = result + " Instances killing failed (" + nbInstKillingError + "/" + nbInst + ", " + instKillingError + ")";
        this.__getlogger().log(BasicLevel.INFO, (Object)result);
        return result;
    }

    public void start() throws ClusterDaemonException {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() throws ClusterDaemonException {
        this.initLogger();
        this.__getlogger().log(BasicLevel.INFO, (Object)"Starting Cluster Daemon...");
        ClusterDaemonTools.loadClusterDaemonConfiguration(this.__getconfFile());
        this.buildControlledServersNames();
        this.initHostInfos();
        domainName = System.getProperty("domain.name", JONAS_CMD_NAME_UNIX_DEF);
        String confDomainName = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getDomainName();
        if (domainName.equals(JONAS_CMD_NAME_UNIX_DEF)) {
            if (confDomainName == null) {
                this.__getlogger().log(BasicLevel.INFO, (Object)("Domain set with default value : " + domainName));
            } else {
                domainName = confDomainName;
                this.__getlogger().log(BasicLevel.INFO, (Object)("Domain set with the value defined in the clusterd.xml : " + domainName));
            }
        } else if (domainName.equals(confDomainName)) {
            this.__getlogger().log(BasicLevel.INFO, (Object)("Domain set with the value defined in the clusterd.xml : " + domainName));
        } else {
            throw new ClusterDaemonException("Incorrect domain name set in clusterd.xml file and in the property " + confDomainName + "/" + domainName);
        }
        ClusterDaemonTools.initCarol();
        this.startNameService();
        this.__getlogger().log(BasicLevel.INFO, (Object)"Carol initialized!");
        this.initMBeans();
        this.__getlogger().log(BasicLevel.INFO, (Object)"JOnAS Cluster Daemon Started!");
        if (this.__getuseMonitor()) {
            new MonitorThread(this.__getlogger()).start();
        }
        this.doStartAllJOnAS(domainName, null, false, false);
        this.getDynamicHostAttributes();
        if (ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getDiscovery().getStartDiscovery()) {
            this.startDiscovery();
        }
        this.__setisStarted(true);
        this.__getlogger().log(BasicLevel.INFO, (Object)"ClusterDaemon started.");
    }

    private void startDiscovery() {
        if (!this.__MstartDiscovery) {
            this.__M_startDiscovery();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startDiscovery", new Object[0]);
            this.__M_startDiscovery();
            this.__IM.onExit((Object)this, "startDiscovery", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startDiscovery", throwable);
            throw throwable;
        }
    }

    private void __M_startDiscovery() {
        this.__setdiscovery(new JgroupsDiscoveryServiceImpl());
        HashMap<String, Object> discoveryEnv = new HashMap<String, Object>();
        discoveryEnv.put("group.name", ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getDiscovery().getDiscoveryGroupName());
        discoveryEnv.put("jgroups.conf", ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getDiscovery().getDiscoveryStackFile());
        discoveryEnv.put("host.name", ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getName());
        discoveryEnv.put("domain.name", domainName);
        try {
            String[] urls = new String[]{ClusterDaemonTools.getJmxUrl(this.__getname())};
            discoveryEnv.put("connector.urls", urls);
            this.__getdiscovery().start(discoveryEnv, MBeanServerHelper.getMBeanServer(), "CLUSTERD");
        }
        catch (Exception e) {
            this.__getlogger().log(BasicLevel.DEBUG, (Object)"Cluster daemon was unable to start JGroups discovery \n", (Throwable)e);
        }
        this.__getlogger().log(BasicLevel.INFO, (Object)"JGroups discovery started \n");
    }

    private static void usage() {
        System.out.println("Usage : jclusterd [-DdomainName=<name>] [-useMonitor] [-confFile my_clusterd.xml] [-carolFile=<my_carol.properties>]");
    }

    public void displayDynamicAttributes() {
        if (!this.__MdisplayDynamicAttributes) {
            this.__M_displayDynamicAttributes();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "displayDynamicAttributes", new Object[0]);
            this.__M_displayDynamicAttributes();
            this.__IM.onExit((Object)this, "displayDynamicAttributes", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "displayDynamicAttributes", throwable);
            throw throwable;
        }
    }

    private void __M_displayDynamicAttributes() {
        Hashtable myhash = this.__getdynamicHostAttributes();
        for (String str : myhash.keySet()) {
            String val = (String)myhash.get(str);
            this.__getlogger().log(BasicLevel.DEBUG, (Object)("Key : " + str + " Value " + val));
        }
    }

    public static void main(String[] args) {
        ClusterDaemon cs = new ClusterDaemon();
        try {
            for (int argn = 0; argn < args.length; ++argn) {
                String arg = args[argn];
                try {
                    if (arg.equals("-useMonitor")) {
                        cs.useMonitor = true;
                        continue;
                    }
                    if (arg.equals("-traceFile")) {
                        cs.csTraceFile = args[++argn];
                        continue;
                    }
                    if (arg.equals("-carolFile")) {
                        cs.carolFile = args[++argn];
                        continue;
                    }
                    if (arg.equals("-confFile")) {
                        cs.confFile = args[++argn];
                        continue;
                    }
                    if (!arg.equals("--help") && !arg.equals("-help") && !arg.equals("-h") && !arg.equals("-?")) continue;
                    ClusterDaemon.usage();
                    System.exit(1);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    throw new ClusterDaemonException("A required parameter was missing after the argument" + arg);
                }
            }
            cs.start();
        }
        catch (Exception e) {
            System.err.println("There was the following exception : " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public String getObjectName() {
        String string;
        if (!this.__MgetObjectName) {
            return this.__M_getObjectName();
        }
        try {
            this.__IM.onEntry((Object)this, "getObjectName", new Object[0]);
            string = this.__M_getObjectName();
            this.__IM.onExit((Object)this, "getObjectName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getObjectName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getObjectName() {
        return this.__getobjectName();
    }

    public void setObjectName(String name) {
        if (!this.__MsetObjectName$java_lang_String) {
            this.__M_setObjectName(name);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setObjectName$java_lang_String", new Object[]{name});
            this.__M_setObjectName(name);
            this.__IM.onExit((Object)this, "setObjectName$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setObjectName$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setObjectName(String name) {
        this.__setobjectName(name);
    }

    public boolean iseventProvider() {
        boolean bl;
        if (!this.__MiseventProvider) {
            return this.__M_iseventProvider();
        }
        try {
            this.__IM.onEntry((Object)this, "iseventProvider", new Object[0]);
            bl = this.__M_iseventProvider();
            this.__IM.onExit((Object)this, "iseventProvider", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "iseventProvider", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_iseventProvider() {
        return false;
    }

    public boolean isstateManageable() {
        boolean bl;
        if (!this.__MisstateManageable) {
            return this.__M_isstateManageable();
        }
        try {
            this.__IM.onEntry((Object)this, "isstateManageable", new Object[0]);
            bl = this.__M_isstateManageable();
            this.__IM.onExit((Object)this, "isstateManageable", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isstateManageable", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isstateManageable() {
        return false;
    }

    public boolean isstatisticsProvider() {
        boolean bl;
        if (!this.__MisstatisticsProvider) {
            return this.__M_isstatisticsProvider();
        }
        try {
            this.__IM.onEntry((Object)this, "isstatisticsProvider", new Object[0]);
            bl = this.__M_isstatisticsProvider();
            this.__IM.onExit((Object)this, "isstatisticsProvider", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isstatisticsProvider", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isstatisticsProvider() {
        return false;
    }

    public String getJavaHome4Server(String name) throws ClusterDaemonException {
        String string;
        if (!this.__MgetJavaHome4Server$java_lang_String) {
            return this.__M_getJavaHome4Server(name);
        }
        try {
            this.__IM.onEntry((Object)this, "getJavaHome4Server$java_lang_String", new Object[]{name});
            string = this.__M_getJavaHome4Server(name);
            this.__IM.onExit((Object)this, "getJavaHome4Server$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJavaHome4Server$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getJavaHome4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return server.getJavaHome();
        }
        return null;
    }

    public String getJonasBase4Server(String name) throws ClusterDaemonException {
        String string;
        if (!this.__MgetJonasBase4Server$java_lang_String) {
            return this.__M_getJonasBase4Server(name);
        }
        try {
            this.__IM.onEntry((Object)this, "getJonasBase4Server$java_lang_String", new Object[]{name});
            string = this.__M_getJonasBase4Server(name);
            this.__IM.onExit((Object)this, "getJonasBase4Server$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJonasBase4Server$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getJonasBase4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return server.getJonasBase();
        }
        return null;
    }

    public String getJonasRoot4Server(String name) throws ClusterDaemonException {
        String string;
        if (!this.__MgetJonasRoot4Server$java_lang_String) {
            return this.__M_getJonasRoot4Server(name);
        }
        try {
            this.__IM.onEntry((Object)this, "getJonasRoot4Server$java_lang_String", new Object[]{name});
            string = this.__M_getJonasRoot4Server(name);
            this.__IM.onExit((Object)this, "getJonasRoot4Server$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJonasRoot4Server$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getJonasRoot4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return server.getJonasRoot();
        }
        return null;
    }

    public String getJonasCmd4Server(String name) throws ClusterDaemonException {
        String string;
        if (!this.__MgetJonasCmd4Server$java_lang_String) {
            return this.__M_getJonasCmd4Server(name);
        }
        try {
            this.__IM.onEntry((Object)this, "getJonasCmd4Server$java_lang_String", new Object[]{name});
            string = this.__M_getJonasCmd4Server(name);
            this.__IM.onExit((Object)this, "getJonasCmd4Server$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJonasCmd4Server$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getJonasCmd4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return server.getJonasCmd();
        }
        return null;
    }

    public String getXprm4Server(String name) throws ClusterDaemonException {
        String string;
        if (!this.__MgetXprm4Server$java_lang_String) {
            return this.__M_getXprm4Server(name);
        }
        try {
            this.__IM.onEntry((Object)this, "getXprm4Server$java_lang_String", new Object[]{name});
            string = this.__M_getXprm4Server(name);
            this.__IM.onExit((Object)this, "getXprm4Server$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getXprm4Server$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getXprm4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return server.getXprm();
        }
        return null;
    }

    public String getAutoBoot4Server(String name) throws ClusterDaemonException {
        String string;
        if (!this.__MgetAutoBoot4Server$java_lang_String) {
            return this.__M_getAutoBoot4Server(name);
        }
        try {
            this.__IM.onEntry((Object)this, "getAutoBoot4Server$java_lang_String", new Object[]{name});
            string = this.__M_getAutoBoot4Server(name);
            this.__IM.onExit((Object)this, "getAutoBoot4Server$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAutoBoot4Server$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getAutoBoot4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return server.getAutoBoot();
        }
        return null;
    }

    public String getJmxPort4Server(String name) throws ClusterDaemonException {
        String string;
        if (!this.__MgetJmxPort4Server$java_lang_String) {
            return this.__M_getJmxPort4Server(name);
        }
        try {
            this.__IM.onEntry((Object)this, "getJmxPort4Server$java_lang_String", new Object[]{name});
            string = this.__M_getJmxPort4Server(name);
            this.__IM.onExit((Object)this, "getJmxPort4Server$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJmxPort4Server$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getJmxPort4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return this.getJmxPort(server.getJonasBase());
        }
        return null;
    }

    public String getDomain4Server(String name) throws ClusterDaemonException {
        String string;
        if (!this.__MgetDomain4Server$java_lang_String) {
            return this.__M_getDomain4Server(name);
        }
        try {
            this.__IM.onEntry((Object)this, "getDomain4Server$java_lang_String", new Object[]{name});
            string = this.__M_getDomain4Server(name);
            this.__IM.onExit((Object)this, "getDomain4Server$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDomain4Server$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getDomain4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return server.getDomain();
        }
        return null;
    }

    public String getJmxUrl4Server(String name) throws ClusterDaemonException {
        String string;
        if (!this.__MgetJmxUrl4Server$java_lang_String) {
            return this.__M_getJmxUrl4Server(name);
        }
        try {
            this.__IM.onEntry((Object)this, "getJmxUrl4Server$java_lang_String", new Object[]{name});
            string = this.__M_getJmxUrl4Server(name);
            this.__IM.onExit((Object)this, "getJmxUrl4Server$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJmxUrl4Server$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getJmxUrl4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            String port = this.getJmxPort(server.getJonasBase());
            return "service:jmx:rmi://localhost/jndi/rmi://localhost:" + port + "/jrmpconnector_" + name;
        }
        return null;
    }

    private void buildControlledServersNames() throws ClusterDaemonException {
        if (!this.__MbuildControlledServersNames) {
            this.__M_buildControlledServersNames();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "buildControlledServersNames", new Object[0]);
            this.__M_buildControlledServersNames();
            this.__IM.onExit((Object)this, "buildControlledServersNames", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "buildControlledServersNames", throwable);
            throw throwable;
        }
    }

    private void __M_buildControlledServersNames() throws ClusterDaemonException {
        try {
            JLinkedList servers = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList();
            if (this.__getcontrolledServersNames() == null) {
                this.__setcontrolledServersNames(new ArrayList());
            }
            if (servers != null) {
                for (int i = 0; i < servers.size(); ++i) {
                    Server serverElement = (Server)servers.get(i);
                    this.__getcontrolledServersNames().add(serverElement.getName());
                }
            }
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    private void flushConfiguration() throws ClusterDaemonException {
        if (!this.__MflushConfiguration) {
            this.__M_flushConfiguration();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "flushConfiguration", new Object[0]);
            this.__M_flushConfiguration();
            this.__IM.onExit((Object)this, "flushConfiguration", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "flushConfiguration", throwable);
            throw throwable;
        }
    }

    private void __M_flushConfiguration() throws ClusterDaemonException {
        String buf = ClusterDaemonTools.getCurrentConfiguration().toXML();
        if (this.__getconfFile() == null) {
            this.__setconfFile(ClusterDaemonTools.getCurrentConfigurationFileName());
        }
        try {
            FileWriter fw = new FileWriter(this.__getconfFile());
            fw.write(buf);
            fw.close();
        }
        catch (IOException e) {
            throw new ClusterDaemonException((Throwable)e);
        }
        this.__getlogger().log(BasicLevel.DEBUG, (Object)("Configuration flushed in the file " + this.__getconfFile() + "\n" + buf));
    }

    public void removeServer(String serverName) throws ClusterDaemonException {
        if (!this.__MremoveServer$java_lang_String) {
            this.__M_removeServer(serverName);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeServer$java_lang_String", new Object[]{serverName});
            this.__M_removeServer(serverName);
            this.__IM.onExit((Object)this, "removeServer$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeServer$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_removeServer(String serverName) throws ClusterDaemonException {
        if (this.pingJOnAS(serverName) == 0) {
            throw new ClusterDaemonException("Could not delete a running server");
        }
        Server server = this.getServer(serverName);
        if (server == null) {
            this.__getlogger().log(BasicLevel.INFO, (Object)("Server named " + serverName + " can't be removed from cluster daemon " + this.__getname() + "  control as unknown"));
            return;
        }
        String jonasBase = this.getJonasBase4Server(serverName);
        ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList().remove((Object)server);
        this.__getcontrolledServersNames().remove(serverName);
        if (jonasBase == null) {
            return;
        }
        File jonasBaseFolder = new File(jonasBase);
        if (jonasBaseFolder.exists()) {
            try {
                this.delete(jonasBaseFolder);
            }
            catch (IOException e) {
                throw new ClusterDaemonException("JOnAS Base could not be deleted for server '" + serverName + "'", (Throwable)e);
            }
        }
    }

    void delete(File f) throws IOException {
        if (!this.__Mdelete$java_io_File) {
            this.__M_delete(f);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "delete$java_io_File", new Object[]{f});
            this.__M_delete(f);
            this.__IM.onExit((Object)this, "delete$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "delete$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_delete(File f) throws IOException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                this.delete(c);
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    public void modifyServer(String name, String domain, String description, String javaHome, String jonasRoot, String jonasBase, String xprm, String autoBoot, String jonasCmd) throws ClusterDaemonException {
        if (!this.__MmodifyServer$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__M_modifyServer(name, domain, description, javaHome, jonasRoot, jonasBase, xprm, autoBoot, jonasCmd);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "modifyServer$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{name, domain, description, javaHome, jonasRoot, jonasBase, xprm, autoBoot, jonasCmd});
            this.__M_modifyServer(name, domain, description, javaHome, jonasRoot, jonasBase, xprm, autoBoot, jonasCmd);
            this.__IM.onExit((Object)this, "modifyServer$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "modifyServer$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_modifyServer(String name, String domain, String description, String javaHome, String jonasRoot, String jonasBase, String xprm, String autoBoot, String jonasCmd) throws ClusterDaemonException {
        Server myServer = this.getServer(name);
        if (myServer == null) {
            throw new ClusterDaemonException("JOnAS instance " + name + " doesn't exist");
        }
        myServer.setDomain(domain);
        myServer.setDescription(description);
        myServer.setJavaHome(javaHome);
        myServer.setJonasBase(jonasBase);
        myServer.setJonasRoot(jonasRoot);
        myServer.setXprm(xprm);
        myServer.setAutoBoot(autoBoot);
        myServer.setJonasCmd(jonasCmd);
        this.flushConfiguration();
        this.__getlogger().log(BasicLevel.DEBUG, (Object)("Server " + name + " updated"));
    }

    public void reloadConfiguration() throws ClusterDaemonException {
        if (!this.__MreloadConfiguration) {
            this.__M_reloadConfiguration();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "reloadConfiguration", new Object[0]);
            this.__M_reloadConfiguration();
            this.__IM.onExit((Object)this, "reloadConfiguration", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "reloadConfiguration", throwable);
            throw throwable;
        }
    }

    private void __M_reloadConfiguration() throws ClusterDaemonException {
        ClusterDaemonTools.loadClusterDaemonConfiguration(this.__getconfFile());
    }

    public void startJOnAS(String name, String prm) throws ClusterDaemonException {
        if (!this.__MstartJOnAS$java_lang_String$java_lang_String) {
            this.__M_startJOnAS(name, prm);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startJOnAS$java_lang_String$java_lang_String", new Object[]{name, prm});
            this.__M_startJOnAS(name, prm);
            this.__IM.onExit((Object)this, "startJOnAS$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startJOnAS$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_startJOnAS(String name, String prm) throws ClusterDaemonException {
        this.doStartJOnAS(name, prm, true);
    }

    public void stopJOnAS(String name) throws ClusterDaemonException {
        if (!this.__MstopJOnAS$java_lang_String) {
            this.__M_stopJOnAS(name);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopJOnAS$java_lang_String", new Object[]{name});
            this.__M_stopJOnAS(name);
            this.__IM.onExit((Object)this, "stopJOnAS$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopJOnAS$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_stopJOnAS(String name) throws ClusterDaemonException {
        this.doStopJOnAS(name);
    }

    public void haltJOnAS(String name) throws ClusterDaemonException {
        if (!this.__MhaltJOnAS$java_lang_String) {
            this.__M_haltJOnAS(name);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "haltJOnAS$java_lang_String", new Object[]{name});
            this.__M_haltJOnAS(name);
            this.__IM.onExit((Object)this, "haltJOnAS$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "haltJOnAS$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_haltJOnAS(String name) throws ClusterDaemonException {
        this.doHaltJOnAS(name);
    }

    public int pingJOnAS(String name) throws ClusterDaemonException {
        int n;
        if (!this.__MpingJOnAS$java_lang_String) {
            return this.__M_pingJOnAS(name);
        }
        try {
            this.__IM.onEntry((Object)this, "pingJOnAS$java_lang_String", new Object[]{name});
            n = this.__M_pingJOnAS(name);
            this.__IM.onExit((Object)this, "pingJOnAS$java_lang_String", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "pingJOnAS$java_lang_String", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_pingJOnAS(String name) throws ClusterDaemonException {
        return this.doPingJOnAS(name, 2000);
    }

    public String startAllJOnAS(String domainName, String prm) throws ClusterDaemonException {
        String string;
        if (!this.__MstartAllJOnAS$java_lang_String$java_lang_String) {
            return this.__M_startAllJOnAS(domainName, prm);
        }
        try {
            this.__IM.onEntry((Object)this, "startAllJOnAS$java_lang_String$java_lang_String", new Object[]{domainName, prm});
            string = this.__M_startAllJOnAS(domainName, prm);
            this.__IM.onExit((Object)this, "startAllJOnAS$java_lang_String$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startAllJOnAS$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_startAllJOnAS(String domainName, String prm) throws ClusterDaemonException {
        return this.doStartAllJOnAS(domainName, prm, true, true);
    }

    public String stopAllJOnAS() {
        String string;
        if (!this.__MstopAllJOnAS) {
            return this.__M_stopAllJOnAS();
        }
        try {
            this.__IM.onEntry((Object)this, "stopAllJOnAS", new Object[0]);
            string = this.__M_stopAllJOnAS();
            this.__IM.onExit((Object)this, "stopAllJOnAS", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopAllJOnAS", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_stopAllJOnAS() {
        return this.doStopAllJOnAS();
    }

    public void stopClusterDaemon() {
        if (!this.__MstopClusterDaemon) {
            this.__M_stopClusterDaemon();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopClusterDaemon", new Object[0]);
            this.__M_stopClusterDaemon();
            this.__IM.onExit((Object)this, "stopClusterDaemon", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopClusterDaemon", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stopClusterDaemon() {
        if (this.__getisStarted()) {
            this.__getlogger().log(BasicLevel.DEBUG, (Object)"Server not started");
        }
        if (this.__getdiscovery() != null) {
            this.__getdiscovery().stop();
        }
        this.__setisStarted(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    throw new IllegalStateException("Cannot wait: " + ie.getMessage());
                }
                System.exit(0);
            }
        }).start();
        this.__getlogger().log(BasicLevel.INFO, (Object)"Server stopped");
    }

    public String getName() {
        String string;
        if (!this.__MgetName) {
            return this.__M_getName();
        }
        try {
            this.__IM.onEntry((Object)this, "getName", new Object[0]);
            string = this.__M_getName();
            this.__IM.onExit((Object)this, "getName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getName() {
        return this.__getname();
    }

    public ArrayList getControlledServersNames() throws ClusterDaemonException {
        ArrayList arrayList;
        if (!this.__MgetControlledServersNames) {
            return this.__M_getControlledServersNames();
        }
        try {
            this.__IM.onEntry((Object)this, "getControlledServersNames", new Object[0]);
            arrayList = this.__M_getControlledServersNames();
            this.__IM.onExit((Object)this, "getControlledServersNames", (Object)arrayList);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getControlledServersNames", throwable);
            throw throwable;
        }
        return arrayList;
    }

    private ArrayList __M_getControlledServersNames() throws ClusterDaemonException {
        if (this.__getcontrolledServersNames() == null) {
            this.buildControlledServersNames();
        }
        return this.__getcontrolledServersNames();
    }

    public boolean isServerManaged(String serverName) throws ClusterDaemonException {
        boolean bl;
        if (!this.__MisServerManaged$java_lang_String) {
            return this.__M_isServerManaged(serverName);
        }
        try {
            this.__IM.onEntry((Object)this, "isServerManaged$java_lang_String", new Object[]{serverName});
            bl = this.__M_isServerManaged(serverName);
            this.__IM.onExit((Object)this, "isServerManaged$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isServerManaged$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isServerManaged(String serverName) throws ClusterDaemonException {
        ArrayList managedServers = this.getControlledServersNames();
        if (managedServers == null) {
            throw new ClusterDaemonException("Cannot get the list of managed servers");
        }
        return managedServers.contains(serverName);
    }

    public ArrayList serversNames() throws ClusterDaemonException {
        ArrayList arrayList;
        if (!this.__MserversNames) {
            return this.__M_serversNames();
        }
        try {
            this.__IM.onEntry((Object)this, "serversNames", new Object[0]);
            arrayList = this.__M_serversNames();
            this.__IM.onExit((Object)this, "serversNames", (Object)arrayList);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "serversNames", throwable);
            throw throwable;
        }
        return arrayList;
    }

    private ArrayList __M_serversNames() throws ClusterDaemonException {
        return this.getControlledServersNames();
    }

    public String getJmxUrl() {
        String string;
        if (!this.__MgetJmxUrl) {
            return this.__M_getJmxUrl();
        }
        try {
            this.__IM.onEntry((Object)this, "getJmxUrl", new Object[0]);
            string = this.__M_getJmxUrl();
            this.__IM.onExit((Object)this, "getJmxUrl", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJmxUrl", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getJmxUrl() {
        return this.__getjmxUrl();
    }

    public void setJmxUrl(String url) {
        if (!this.__MsetJmxUrl$java_lang_String) {
            this.__M_setJmxUrl(url);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJmxUrl$java_lang_String", new Object[]{url});
            this.__M_setJmxUrl(url);
            this.__IM.onExit((Object)this, "setJmxUrl$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJmxUrl$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setJmxUrl(String url) {
        this.__setjmxUrl(url);
    }

    public String getOperatingSystemAvailableProcessors() {
        String string;
        if (!this.__MgetOperatingSystemAvailableProcessors) {
            return this.__M_getOperatingSystemAvailableProcessors();
        }
        try {
            this.__IM.onEntry((Object)this, "getOperatingSystemAvailableProcessors", new Object[0]);
            string = this.__M_getOperatingSystemAvailableProcessors();
            this.__IM.onExit((Object)this, "getOperatingSystemAvailableProcessors", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOperatingSystemAvailableProcessors", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getOperatingSystemAvailableProcessors() {
        return this.__getoperatingSystemAvailableProcessors();
    }

    public void setOperatingSystemAvailableProcessors(String operatingSystemAvailableProcessors) {
        if (!this.__MsetOperatingSystemAvailableProcessors$java_lang_String) {
            this.__M_setOperatingSystemAvailableProcessors(operatingSystemAvailableProcessors);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setOperatingSystemAvailableProcessors$java_lang_String", new Object[]{operatingSystemAvailableProcessors});
            this.__M_setOperatingSystemAvailableProcessors(operatingSystemAvailableProcessors);
            this.__IM.onExit((Object)this, "setOperatingSystemAvailableProcessors$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setOperatingSystemAvailableProcessors$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setOperatingSystemAvailableProcessors(String operatingSystemAvailableProcessors) {
        this.__setoperatingSystemAvailableProcessors(operatingSystemAvailableProcessors);
    }

    public String getOperatingSystemName() {
        String string;
        if (!this.__MgetOperatingSystemName) {
            return this.__M_getOperatingSystemName();
        }
        try {
            this.__IM.onEntry((Object)this, "getOperatingSystemName", new Object[0]);
            string = this.__M_getOperatingSystemName();
            this.__IM.onExit((Object)this, "getOperatingSystemName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOperatingSystemName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getOperatingSystemName() {
        return this.__getoperatingSystemName();
    }

    public void setOperatingSystemName(String operatingSystemName) {
        if (!this.__MsetOperatingSystemName$java_lang_String) {
            this.__M_setOperatingSystemName(operatingSystemName);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setOperatingSystemName$java_lang_String", new Object[]{operatingSystemName});
            this.__M_setOperatingSystemName(operatingSystemName);
            this.__IM.onExit((Object)this, "setOperatingSystemName$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setOperatingSystemName$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setOperatingSystemName(String operatingSystemName) {
        this.__setoperatingSystemName(operatingSystemName);
    }

    public String getOperatingSystemVersion() {
        String string;
        if (!this.__MgetOperatingSystemVersion) {
            return this.__M_getOperatingSystemVersion();
        }
        try {
            this.__IM.onEntry((Object)this, "getOperatingSystemVersion", new Object[0]);
            string = this.__M_getOperatingSystemVersion();
            this.__IM.onExit((Object)this, "getOperatingSystemVersion", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOperatingSystemVersion", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getOperatingSystemVersion() {
        return this.__getoperatingSystemVersion();
    }

    public void setOperatingSystemVersion(String operatingSystemVersion) {
        if (!this.__MsetOperatingSystemVersion$java_lang_String) {
            this.__M_setOperatingSystemVersion(operatingSystemVersion);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setOperatingSystemVersion$java_lang_String", new Object[]{operatingSystemVersion});
            this.__M_setOperatingSystemVersion(operatingSystemVersion);
            this.__IM.onExit((Object)this, "setOperatingSystemVersion$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setOperatingSystemVersion$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setOperatingSystemVersion(String operatingSystemVersion) {
        this.__setoperatingSystemVersion(operatingSystemVersion);
    }

    public String getRunTimeSpecVendor() {
        String string;
        if (!this.__MgetRunTimeSpecVendor) {
            return this.__M_getRunTimeSpecVendor();
        }
        try {
            this.__IM.onEntry((Object)this, "getRunTimeSpecVendor", new Object[0]);
            string = this.__M_getRunTimeSpecVendor();
            this.__IM.onExit((Object)this, "getRunTimeSpecVendor", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRunTimeSpecVendor", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getRunTimeSpecVendor() {
        return this.__getrunTimeSpecVendor();
    }

    public void setRunTimeSpecVendor(String runTimeSpecVendor) {
        if (!this.__MsetRunTimeSpecVendor$java_lang_String) {
            this.__M_setRunTimeSpecVendor(runTimeSpecVendor);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRunTimeSpecVendor$java_lang_String", new Object[]{runTimeSpecVendor});
            this.__M_setRunTimeSpecVendor(runTimeSpecVendor);
            this.__IM.onExit((Object)this, "setRunTimeSpecVendor$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRunTimeSpecVendor$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setRunTimeSpecVendor(String runTimeSpecVendor) {
        this.__setrunTimeSpecVendor(runTimeSpecVendor);
    }

    public String getRunTimeSpecVersion() {
        String string;
        if (!this.__MgetRunTimeSpecVersion) {
            return this.__M_getRunTimeSpecVersion();
        }
        try {
            this.__IM.onEntry((Object)this, "getRunTimeSpecVersion", new Object[0]);
            string = this.__M_getRunTimeSpecVersion();
            this.__IM.onExit((Object)this, "getRunTimeSpecVersion", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRunTimeSpecVersion", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getRunTimeSpecVersion() {
        return this.__getrunTimeSpecVersion();
    }

    public void setRunTimeSpecVersion(String runTimeSpecVersion) {
        if (!this.__MsetRunTimeSpecVersion$java_lang_String) {
            this.__M_setRunTimeSpecVersion(runTimeSpecVersion);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRunTimeSpecVersion$java_lang_String", new Object[]{runTimeSpecVersion});
            this.__M_setRunTimeSpecVersion(runTimeSpecVersion);
            this.__IM.onExit((Object)this, "setRunTimeSpecVersion$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRunTimeSpecVersion$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setRunTimeSpecVersion(String runTimeSpecVersion) {
        this.__setrunTimeSpecVersion(runTimeSpecVersion);
    }

    public String getRunTimeVmName() {
        String string;
        if (!this.__MgetRunTimeVmName) {
            return this.__M_getRunTimeVmName();
        }
        try {
            this.__IM.onEntry((Object)this, "getRunTimeVmName", new Object[0]);
            string = this.__M_getRunTimeVmName();
            this.__IM.onExit((Object)this, "getRunTimeVmName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRunTimeVmName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getRunTimeVmName() {
        return this.__getrunTimeVmName();
    }

    public void setRunTimeVmName(String runTimeVmName) {
        if (!this.__MsetRunTimeVmName$java_lang_String) {
            this.__M_setRunTimeVmName(runTimeVmName);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRunTimeVmName$java_lang_String", new Object[]{runTimeVmName});
            this.__M_setRunTimeVmName(runTimeVmName);
            this.__IM.onExit((Object)this, "setRunTimeVmName$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRunTimeVmName$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setRunTimeVmName(String runTimeVmName) {
        this.__setrunTimeVmName(runTimeVmName);
    }

    public String getRunTimeVmVendor() {
        String string;
        if (!this.__MgetRunTimeVmVendor) {
            return this.__M_getRunTimeVmVendor();
        }
        try {
            this.__IM.onEntry((Object)this, "getRunTimeVmVendor", new Object[0]);
            string = this.__M_getRunTimeVmVendor();
            this.__IM.onExit((Object)this, "getRunTimeVmVendor", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRunTimeVmVendor", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getRunTimeVmVendor() {
        return this.__getrunTimeVmVendor();
    }

    public void setRunTimeVmVendor(String runTimeVmVendor) {
        if (!this.__MsetRunTimeVmVendor$java_lang_String) {
            this.__M_setRunTimeVmVendor(runTimeVmVendor);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRunTimeVmVendor$java_lang_String", new Object[]{runTimeVmVendor});
            this.__M_setRunTimeVmVendor(runTimeVmVendor);
            this.__IM.onExit((Object)this, "setRunTimeVmVendor$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRunTimeVmVendor$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setRunTimeVmVendor(String runTimeVmVendor) {
        this.__setrunTimeVmVendor(runTimeVmVendor);
    }

    public String getRunTimeVmVersion() {
        String string;
        if (!this.__MgetRunTimeVmVersion) {
            return this.__M_getRunTimeVmVersion();
        }
        try {
            this.__IM.onEntry((Object)this, "getRunTimeVmVersion", new Object[0]);
            string = this.__M_getRunTimeVmVersion();
            this.__IM.onExit((Object)this, "getRunTimeVmVersion", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRunTimeVmVersion", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getRunTimeVmVersion() {
        return this.__getrunTimeVmVersion();
    }

    public void setRunTimeVmVersion(String runTimeVmVersion) {
        if (!this.__MsetRunTimeVmVersion$java_lang_String) {
            this.__M_setRunTimeVmVersion(runTimeVmVersion);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRunTimeVmVersion$java_lang_String", new Object[]{runTimeVmVersion});
            this.__M_setRunTimeVmVersion(runTimeVmVersion);
            this.__IM.onExit((Object)this, "setRunTimeVmVersion$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRunTimeVmVersion$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setRunTimeVmVersion(String runTimeVmVersion) {
        this.__setrunTimeVmVersion(runTimeVmVersion);
    }

    public Hashtable<String, String> getDynamicHostAttributes() throws ClusterDaemonException {
        Hashtable<String, String> hashtable;
        if (!this.__MgetDynamicHostAttributes) {
            return this.__M_getDynamicHostAttributes();
        }
        try {
            this.__IM.onEntry((Object)this, "getDynamicHostAttributes", new Object[0]);
            hashtable = this.__M_getDynamicHostAttributes();
            this.__IM.onExit((Object)this, "getDynamicHostAttributes", hashtable);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDynamicHostAttributes", throwable);
            throw throwable;
        }
        return hashtable;
    }

    private Hashtable<String, String> __M_getDynamicHostAttributes() throws ClusterDaemonException {
        if (this.__getdynamicHostAttributes() == null) {
            this.__setdynamicHostAttributes(new Hashtable());
        }
        this.__getlogger().log(BasicLevel.DEBUG, (Object)"retrieving cluster daemon's host dynamic information");
        try {
            this.__getdynamicHostAttributes().put("loadedClassCount", new Integer(classLoadingMxBean.getLoadedClassCount()).toString());
            this.__getdynamicHostAttributes().put("unloadedClassCount", new Long(classLoadingMxBean.getUnloadedClassCount()).toString());
            this.__getdynamicHostAttributes().put("threadCount", new Integer(threadMxBean.getThreadCount()).toString());
            this.__getdynamicHostAttributes().put("totalStartedThreadCount", new Long(threadMxBean.getTotalStartedThreadCount()).toString());
            this.__getdynamicHostAttributes().put("initHeapMemoryVm", new Long(memoryMXBean.getHeapMemoryUsage().getInit()).toString());
            this.__getdynamicHostAttributes().put("usedHeapMemoryVm", new Long(memoryMXBean.getHeapMemoryUsage().getUsed()).toString());
            this.__getdynamicHostAttributes().put("maxHeapMemoryVm", new Long(memoryMXBean.getHeapMemoryUsage().getMax()).toString());
            this.__getdynamicHostAttributes().put("heapCommittedMemoryVm", new Long(memoryMXBean.getHeapMemoryUsage().getCommitted()).toString());
            this.__getdynamicHostAttributes().put("initNonHeapMemoryVm", new Long(memoryMXBean.getNonHeapMemoryUsage().getInit()).toString());
            this.__getdynamicHostAttributes().put("usedNonHeapMemoryVm", new Long(memoryMXBean.getNonHeapMemoryUsage().getUsed()).toString());
            this.__getdynamicHostAttributes().put("maxNonHeapMemoryVm", new Long(memoryMXBean.getNonHeapMemoryUsage().getMax()).toString());
            this.__getdynamicHostAttributes().put("CommittedNonHeapMemoryVm", new Long(memoryMXBean.getNonHeapMemoryUsage().getCommitted()).toString());
            this.buildOperatingSystemdynInfo();
            this.displayDynamicAttributes();
        }
        catch (Exception e) {
            this.__getlogger().log(BasicLevel.DEBUG, (Object)("Cannot retrieve cluster daemon's host dynamic information: " + e));
            throw new ClusterDaemonException((Throwable)e);
        }
        finally {
            return this.__getdynamicHostAttributes();
        }
    }

    private void buildOperatingSystemdynInfo() throws ClusterDaemonException {
        if (!this.__MbuildOperatingSystemdynInfo) {
            this.__M_buildOperatingSystemdynInfo();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "buildOperatingSystemdynInfo", new Object[0]);
            this.__M_buildOperatingSystemdynInfo();
            this.__IM.onExit((Object)this, "buildOperatingSystemdynInfo", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "buildOperatingSystemdynInfo", throwable);
            throw throwable;
        }
    }

    private void __M_buildOperatingSystemdynInfo() throws ClusterDaemonException {
        try {
            ObjectName osOn = new ObjectName("java.lang:type=OperatingSystem");
            if (platFormMbeanServer != null && platFormMbeanServer.isRegistered(osOn)) {
                MBeanInfo mbeaInfo = platFormMbeanServer.getMBeanInfo(osOn);
                MBeanAttributeInfo[] atts = mbeaInfo.getAttributes();
                String attrName = null;
                String attrType = null;
                for (int i = 0; i < atts.length; ++i) {
                    attrName = atts[i].getName();
                    attrType = atts[i].getType();
                    if (!attrType.equals(LONG_TYPE_DYN_INFO)) continue;
                    this.__getlogger().log(BasicLevel.DEBUG, (Object)"**** Attribute Info ****");
                    this.__getlogger().log(BasicLevel.DEBUG, (Object)("Name " + atts[i].getName()));
                    this.__getlogger().log(BasicLevel.DEBUG, (Object)("Type " + atts[i].getType()));
                    this.__getlogger().log(BasicLevel.DEBUG, (Object)("isIs " + atts[i].isIs()));
                    this.__getlogger().log(BasicLevel.DEBUG, (Object)("isReadable " + atts[i].isReadable()));
                    this.__getlogger().log(BasicLevel.DEBUG, (Object)("isWritable " + atts[i].isWritable()));
                    Long attrValue = (Long)platFormMbeanServer.getAttribute(osOn, atts[i].getName());
                    this.__getlogger().log(BasicLevel.DEBUG, (Object)("value " + attrValue));
                    this.__getdynamicHostAttributes().put(attrName, attrValue.toString());
                }
            }
        }
        catch (Exception e) {
            this.__getlogger().log(BasicLevel.DEBUG, (Object)("Unable to get dynamic dynamic infos for the Operating System " + e));
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    public void initHostInfos() throws ClusterDaemonException {
        if (!this.__MinitHostInfos) {
            this.__M_initHostInfos();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initHostInfos", new Object[0]);
            this.__M_initHostInfos();
            this.__IM.onExit((Object)this, "initHostInfos", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initHostInfos", throwable);
            throw throwable;
        }
    }

    private void __M_initHostInfos() throws ClusterDaemonException {
        this.__getlogger().log(BasicLevel.INFO, (Object)"Initializing Host monitoring informations");
        try {
            runtimeMxbean = ManagementFactory.getRuntimeMXBean();
            classLoadingMxBean = ManagementFactory.getClassLoadingMXBean();
            threadMxBean = ManagementFactory.getThreadMXBean();
            compilationMxBean = ManagementFactory.getCompilationMXBean();
            garbageCollectorMXBean = ManagementFactory.getGarbageCollectorMXBeans();
            memoryManagerMXBean = ManagementFactory.getMemoryManagerMXBeans();
            memoryMXBean = ManagementFactory.getMemoryMXBean();
            memoryPoolMXBean = ManagementFactory.getMemoryPoolMXBeans();
            platFormMbeanServer = ManagementFactory.getPlatformMBeanServer();
            this.__setrunTimeVmVendor(runtimeMxbean.getVmVendor());
            this.__setrunTimeSpecVendor(runtimeMxbean.getSpecVendor());
            this.__setrunTimeSpecVersion(runtimeMxbean.getSpecName());
            this.__setrunTimeVmName(runtimeMxbean.getVmName());
            this.__setrunTimeVmVersion(runtimeMxbean.getVmVersion());
            operatingSystemMxBean = ManagementFactory.getOperatingSystemMXBean();
            this.__setoperatingSystemAvailableProcessors(new Integer(operatingSystemMxBean.getAvailableProcessors()).toString());
            this.__setoperatingSystemName(operatingSystemMxBean.getName());
            this.__setoperatingSystemVersion(operatingSystemMxBean.getVersion());
            this.__setoperatingSystemArch(operatingSystemMxBean.getArch());
            this.__setdynamicHostAttributes(new Hashtable());
        }
        catch (Exception e) {
            this.__getlogger().log(BasicLevel.DEBUG, (Object)("cannot get host monitoring informations : " + e));
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    public String getOperatingSystemArch() {
        String string;
        if (!this.__MgetOperatingSystemArch) {
            return this.__M_getOperatingSystemArch();
        }
        try {
            this.__IM.onEntry((Object)this, "getOperatingSystemArch", new Object[0]);
            string = this.__M_getOperatingSystemArch();
            this.__IM.onExit((Object)this, "getOperatingSystemArch", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOperatingSystemArch", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getOperatingSystemArch() {
        return this.__getoperatingSystemArch();
    }

    public void setOperatingSystemArch(String operatingSystemArch) {
        if (!this.__MsetOperatingSystemArch$java_lang_String) {
            this.__M_setOperatingSystemArch(operatingSystemArch);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setOperatingSystemArch$java_lang_String", new Object[]{operatingSystemArch});
            this.__M_setOperatingSystemArch(operatingSystemArch);
            this.__IM.onExit((Object)this, "setOperatingSystemArch$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setOperatingSystemArch$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setOperatingSystemArch(String operatingSystemArch) {
        this.__setoperatingSystemArch(operatingSystemArch);
    }

    public String getVmCurrentUsedNonHeapMemory() throws ClusterDaemonException {
        String string;
        if (!this.__MgetVmCurrentUsedNonHeapMemory) {
            return this.__M_getVmCurrentUsedNonHeapMemory();
        }
        try {
            this.__IM.onEntry((Object)this, "getVmCurrentUsedNonHeapMemory", new Object[0]);
            string = this.__M_getVmCurrentUsedNonHeapMemory();
            this.__IM.onExit((Object)this, "getVmCurrentUsedNonHeapMemory", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getVmCurrentUsedNonHeapMemory", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getVmCurrentUsedNonHeapMemory() throws ClusterDaemonException {
        try {
            long nonheap = memoryMXBean.getNonHeapMemoryUsage().getUsed();
            return new Long(nonheap).toString();
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    public String getOsCurrentUsedSpace() throws ClusterDaemonException {
        String string;
        if (!this.__MgetOsCurrentUsedSpace) {
            return this.__M_getOsCurrentUsedSpace();
        }
        try {
            this.__IM.onEntry((Object)this, "getOsCurrentUsedSpace", new Object[0]);
            string = this.__M_getOsCurrentUsedSpace();
            this.__IM.onExit((Object)this, "getOsCurrentUsedSpace", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOsCurrentUsedSpace", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getOsCurrentUsedSpace() throws ClusterDaemonException {
        try {
            long totalPhys = this.getOsAtributeValue("TotalPhysical");
            long totalFree = this.getOsAtributeValue("FreePhysical");
            return new Long(totalPhys - totalFree).toString();
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    public String getOsTotalSpace() throws ClusterDaemonException {
        String string;
        if (!this.__MgetOsTotalSpace) {
            return this.__M_getOsTotalSpace();
        }
        try {
            this.__IM.onEntry((Object)this, "getOsTotalSpace", new Object[0]);
            string = this.__M_getOsTotalSpace();
            this.__IM.onExit((Object)this, "getOsTotalSpace", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOsTotalSpace", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getOsTotalSpace() throws ClusterDaemonException {
        try {
            return this.getOsAtributeValue("TotalPhysical").toString();
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    private String getJmxPort(String jonasBasePath) throws ClusterDaemonException {
        String string;
        if (!this.__MgetJmxPort$java_lang_String) {
            return this.__M_getJmxPort(jonasBasePath);
        }
        try {
            this.__IM.onEntry((Object)this, "getJmxPort$java_lang_String", new Object[]{jonasBasePath});
            string = this.__M_getJmxPort(jonasBasePath);
            this.__IM.onExit((Object)this, "getJmxPort$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJmxPort$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getJmxPort(String jonasBasePath) throws ClusterDaemonException {
        File jonasBase = new File(jonasBasePath);
        if (!jonasBase.exists()) {
            throw new ClusterDaemonException("The JONAS_BASE of the server " + this.__getname() + " doesn't exist.");
        }
        File carolProperties = new File(new File(jonasBase, "conf"), "carol.properties");
        if (!carolProperties.exists()) {
            throw new ClusterDaemonException(carolProperties.getAbsolutePath() + " doesn't exist");
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(carolProperties));
        }
        catch (IOException e) {
            throw new ClusterDaemonException("Cannot load properties of " + carolProperties.getAbsolutePath() + " file", (Throwable)e);
        }
        String protocol = properties.getProperty("carol.protocols");
        return this.getJmxPort(properties, protocol);
    }

    private String getJmxPort(Properties carolProperties, String protocol) throws ClusterDaemonException {
        String string;
        if (!this.__MgetJmxPort$java_util_Properties$java_lang_String) {
            return this.__M_getJmxPort(carolProperties, protocol);
        }
        try {
            this.__IM.onEntry((Object)this, "getJmxPort$java_util_Properties$java_lang_String", new Object[]{carolProperties, protocol});
            string = this.__M_getJmxPort(carolProperties, protocol);
            this.__IM.onExit((Object)this, "getJmxPort$java_util_Properties$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJmxPort$java_util_Properties$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getJmxPort(Properties carolProperties, String protocol) throws ClusterDaemonException {
        String jmxPort = null;
        String token = "carol." + protocol + ".url";
        String url = carolProperties.getProperty(token);
        StringTokenizer stringTokenizer = new StringTokenizer(url, ":");
        if (stringTokenizer.hasMoreElements()) {
            stringTokenizer.nextElement();
            if (stringTokenizer.hasMoreElements()) {
                stringTokenizer.nextElement();
                if (stringTokenizer.hasMoreElements()) {
                    jmxPort = stringTokenizer.nextToken();
                }
            }
        }
        if (jmxPort == null) {
            throw new ClusterDaemonException("The JMX url is invalid: " + url);
        }
        return jmxPort;
    }

    public String generateReport(String name) throws ClusterDaemonException {
        String string;
        if (!this.__MgenerateReport$java_lang_String) {
            return this.__M_generateReport(name);
        }
        try {
            this.__IM.onEntry((Object)this, "generateReport$java_lang_String", new Object[]{name});
            string = this.__M_generateReport(name);
            this.__IM.onExit((Object)this, "generateReport$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateReport$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_generateReport(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server == null) {
            throw new ClusterDaemonException("Server " + name + " cannot be found.");
        }
        File jonasBase = new File(server.getJonasBase());
        if (!jonasBase.exists()) {
            throw new ClusterDaemonException("The JONAS_BASE of the server " + name + " doesn't exist.");
        }
        File carolProperties = new File(new File(jonasBase, "conf"), "carol.properties");
        if (!carolProperties.exists()) {
            throw new ClusterDaemonException(carolProperties.getAbsolutePath() + " doesn't exist");
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(carolProperties));
        }
        catch (IOException e) {
            throw new ClusterDaemonException("Cannot load properties of " + carolProperties.getAbsolutePath() + " file", (Throwable)e);
        }
        String host = "localhost";
        String protocol = properties.getProperty("carol.protocols");
        String jmxPort = this.getJmxPort(properties, protocol);
        String jmxUrl = ClusterDaemonTools.getJmxUrl(host, jmxPort, server.getName(), protocol);
        MBeanServerConnection mBeanServerConnection = null;
        try {
            mBeanServerConnection = JMXRemoteHelper.connect(jmxUrl);
        }
        catch (JMXRemoteException e) {
            throw new ClusterDaemonException("Cannot connect to JMX URL " + jmxUrl, (Throwable)e);
        }
        String pattern = "*:type=service,name=report";
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("*:type=service,name=report");
        }
        catch (MalformedObjectNameException e) {
            throw new ClusterDaemonException("Canno't instanciate ObjectName");
        }
        Set<ObjectName> objectNameSet = null;
        try {
            objectNameSet = mBeanServerConnection.queryNames(objectName, null);
        }
        catch (IOException e) {
            throw new ClusterDaemonException("Could not find a valid ObjectName with the pattern *:type=service,name=report", (Throwable)e);
        }
        Iterator<ObjectName> iterator = objectNameSet.iterator();
        if (!iterator.hasNext()) {
            throw new ClusterDaemonException("Could not find a valid ObjectName with the pattern *:type=service,name=report");
        }
        try {
            return (String)mBeanServerConnection.invoke(iterator.next(), "generateReport", null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new ClusterDaemonException("Could not get back data of the 'generateReport' method of the objectName" + objectName, (Throwable)e);
        }
        catch (MBeanException e) {
            throw new ClusterDaemonException("Could not get back data of the 'generateReport' method of the objectName" + objectName, (Throwable)e);
        }
        catch (ReflectionException e) {
            throw new ClusterDaemonException("Could not get back data of the 'generateReport' method of the objectName" + objectName, (Throwable)e);
        }
        catch (IOException e) {
            throw new ClusterDaemonException("Could not get back data of the 'generateReport' method of the objectName" + objectName, (Throwable)e);
        }
    }

    public String getVmCurrentUsedHeapMemory() throws ClusterDaemonException {
        String string;
        if (!this.__MgetVmCurrentUsedHeapMemory) {
            return this.__M_getVmCurrentUsedHeapMemory();
        }
        try {
            this.__IM.onEntry((Object)this, "getVmCurrentUsedHeapMemory", new Object[0]);
            string = this.__M_getVmCurrentUsedHeapMemory();
            this.__IM.onExit((Object)this, "getVmCurrentUsedHeapMemory", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getVmCurrentUsedHeapMemory", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getVmCurrentUsedHeapMemory() throws ClusterDaemonException {
        try {
            long memusage = memoryMXBean.getHeapMemoryUsage().getUsed();
            return new Long(memusage).toString();
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    public String getVmCurrentUsedMemory() throws ClusterDaemonException {
        String string;
        if (!this.__MgetVmCurrentUsedMemory) {
            return this.__M_getVmCurrentUsedMemory();
        }
        try {
            this.__IM.onEntry((Object)this, "getVmCurrentUsedMemory", new Object[0]);
            string = this.__M_getVmCurrentUsedMemory();
            this.__IM.onExit((Object)this, "getVmCurrentUsedMemory", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getVmCurrentUsedMemory", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getVmCurrentUsedMemory() throws ClusterDaemonException {
        try {
            long heapmem = memoryMXBean.getHeapMemoryUsage().getUsed();
            long nonHeapmem = memoryMXBean.getNonHeapMemoryUsage().getUsed();
            return new Long(heapmem + nonHeapmem).toString();
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    public String getVmTotalMemory() throws ClusterDaemonException {
        String string;
        if (!this.__MgetVmTotalMemory) {
            return this.__M_getVmTotalMemory();
        }
        try {
            this.__IM.onEntry((Object)this, "getVmTotalMemory", new Object[0]);
            string = this.__M_getVmTotalMemory();
            this.__IM.onExit((Object)this, "getVmTotalMemory", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getVmTotalMemory", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getVmTotalMemory() throws ClusterDaemonException {
        try {
            long committed = memoryMXBean.getHeapMemoryUsage().getCommitted();
            long usage = memoryMXBean.getNonHeapMemoryUsage().getCommitted();
            return new Long(committed + usage).toString();
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    private Long getOsAtributeValue(String key) throws ClusterDaemonException {
        Long l;
        if (!this.__MgetOsAtributeValue$java_lang_String) {
            return this.__M_getOsAtributeValue(key);
        }
        try {
            this.__IM.onEntry((Object)this, "getOsAtributeValue$java_lang_String", new Object[]{key});
            l = this.__M_getOsAtributeValue(key);
            this.__IM.onExit((Object)this, "getOsAtributeValue$java_lang_String", (Object)l);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOsAtributeValue$java_lang_String", throwable);
            throw throwable;
        }
        return l;
    }

    private Long __M_getOsAtributeValue(String key) throws ClusterDaemonException {
        try {
            ObjectName osOn = new ObjectName("java.lang:type=OperatingSystem");
            if (platFormMbeanServer != null && platFormMbeanServer.isRegistered(osOn)) {
                int i;
                MBeanInfo mbeaInfo = platFormMbeanServer.getMBeanInfo(osOn);
                MBeanAttributeInfo[] atts = mbeaInfo.getAttributes();
                Object attrName = null;
                for (i = 0; !atts[i].getName().contains(key) && i < atts.length; ++i) {
                }
                if (i < atts.length) {
                    return (Long)platFormMbeanServer.getAttribute(osOn, atts[i].getName());
                }
                throw new ClusterDaemonException("Key {0} in Operating System mbean" + key);
            }
        }
        catch (Exception e) {
            this.__getlogger().log(BasicLevel.DEBUG, (Object)("Unable to get dynamic dynamic infos for the Operating System " + e));
            throw new ClusterDaemonException((Throwable)e);
        }
        return null;
    }

    public void addServer(String name, String domain, String description, String jonasRoot, String jonasBase, String javaHome, String xprem, String autoBoot, String jonasCmd, String saveIt) throws ClusterDaemonException {
        if (!this.__MaddServer$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__M_addServer(name, domain, description, jonasRoot, jonasBase, javaHome, xprem, autoBoot, jonasCmd, saveIt);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addServer$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{name, domain, description, jonasRoot, jonasBase, javaHome, xprem, autoBoot, jonasCmd, saveIt});
            this.__M_addServer(name, domain, description, jonasRoot, jonasBase, javaHome, xprem, autoBoot, jonasCmd, saveIt);
            this.__IM.onExit((Object)this, "addServer$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addServer$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_addServer(String name, String domain, String description, String jonasRoot, String jonasBase, String javaHome, String xprem, String autoBoot, String jonasCmd, String saveIt) throws ClusterDaemonException {
        try {
            JLinkedList servers = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList();
            if (servers != null) {
                ListIterator itr = servers.listIterator();
                while (itr.hasNext()) {
                    Server serverElement = (Server)itr.next();
                    if (!serverElement.getName().equals(name) || !serverElement.getDomain().equals(domain)) continue;
                    throw new ClusterDaemonException("Cannot add the server named " + name + ", a server with the same name is already present in the domain " + domain);
                }
            }
            Server srv = new Server();
            srv.setName(name);
            srv.setDomain(domain);
            srv.setJonasRoot(jonasRoot);
            srv.setJonasBase(jonasBase);
            srv.setJavaHome(javaHome);
            srv.setXprm(xprem);
            srv.setAutoBoot(autoBoot);
            srv.setJonasCmd(jonasCmd);
            servers.add((Object)srv);
            if (saveIt.equals("true")) {
                try {
                    this.flushConfiguration();
                }
                catch (Exception e) {
                    this.__getlogger().log(BasicLevel.DEBUG, (Object)("Cannot flush configuration for cluster daemon named" + this.__getname()));
                    return;
                }
            }
            this.__getcontrolledServersNames().add(srv.getName());
            this.__getlogger().log(BasicLevel.DEBUG, (Object)("Server named " + name + " successfully added to cluster daemon " + this.__getname() + "control"));
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    public void removeServer(String serverName, String saveIt) throws ClusterDaemonException {
        if (!this.__MremoveServer$java_lang_String$java_lang_String) {
            this.__M_removeServer(serverName, saveIt);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeServer$java_lang_String$java_lang_String", new Object[]{serverName, saveIt});
            this.__M_removeServer(serverName, saveIt);
            this.__IM.onExit((Object)this, "removeServer$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeServer$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_removeServer(String serverName, String saveIt) throws ClusterDaemonException {
        if (this.pingJOnAS(serverName) == 0) {
            throw new ClusterDaemonException("Could not delete a running server");
        }
        Server server = this.getServer(serverName);
        if (server != null) {
            try {
                ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList().remove((Object)server);
                if (saveIt.equals("true")) {
                    this.flushConfiguration();
                }
            }
            catch (ClusterDaemonException e) {
                this.__getlogger().log(BasicLevel.DEBUG, (Object)("Cannot flush configuration for cluster daemon named" + this.__getname()));
                return;
            }
            String jonasBase = server.getJonasBase();
            this.__getcontrolledServersNames().remove(serverName);
            if (jonasBase == null) {
                return;
            }
            File jonasBaseFolder = new File(jonasBase);
            if (jonasBaseFolder.exists()) {
                try {
                    this.delete(jonasBaseFolder);
                }
                catch (IOException e) {
                    throw new ClusterDaemonException("JOnAS Base could not be deleted for server '" + serverName + "'", (Throwable)e);
                }
            }
            this.__getlogger().log(BasicLevel.INFO, (Object)("Server named " + serverName + " successfully removed from cluster daemon " + this.__getname() + "  control"));
        } else {
            this.__getlogger().log(BasicLevel.INFO, (Object)("Server named " + serverName + " can't be removed from cluster daemon " + this.__getname() + "  control as not known"));
        }
    }

    public void saveConfiguration() throws ClusterDaemonException {
        if (!this.__MsaveConfiguration) {
            this.__M_saveConfiguration();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "saveConfiguration", new Object[0]);
            this.__M_saveConfiguration();
            this.__IM.onExit((Object)this, "saveConfiguration", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "saveConfiguration", throwable);
            throw throwable;
        }
    }

    private void __M_saveConfiguration() throws ClusterDaemonException {
        this.flushConfiguration();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("carolFile")) {
                this.__FcarolFile = true;
            }
            if (set.contains("confFile")) {
                this.__FconfFile = true;
            }
            if (set.contains("controlledServersNames")) {
                this.__FcontrolledServersNames = true;
            }
            if (set.contains("csTraceFile")) {
                this.__FcsTraceFile = true;
            }
            if (set.contains("discovery")) {
                this.__Fdiscovery = true;
            }
            if (set.contains("dynamicHostAttributes")) {
                this.__FdynamicHostAttributes = true;
            }
            if (set.contains("isStarted")) {
                this.__FisStarted = true;
            }
            if (set.contains("jmxUrl")) {
                this.__FjmxUrl = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("name")) {
                this.__Fname = true;
            }
            if (set.contains("objectName")) {
                this.__FobjectName = true;
            }
            if (set.contains("operatingSystemArch")) {
                this.__FoperatingSystemArch = true;
            }
            if (set.contains("operatingSystemAvailableProcessors")) {
                this.__FoperatingSystemAvailableProcessors = true;
            }
            if (set.contains("operatingSystemName")) {
                this.__FoperatingSystemName = true;
            }
            if (set.contains("operatingSystemVersion")) {
                this.__FoperatingSystemVersion = true;
            }
            if (set.contains("processMap")) {
                this.__FprocessMap = true;
            }
            if (set.contains("runTimeSpecVendor")) {
                this.__FrunTimeSpecVendor = true;
            }
            if (set.contains("runTimeSpecVersion")) {
                this.__FrunTimeSpecVersion = true;
            }
            if (set.contains("runTimeVmName")) {
                this.__FrunTimeVmName = true;
            }
            if (set.contains("runTimeVmVendor")) {
                this.__FrunTimeVmVendor = true;
            }
            if (set.contains("runTimeVmVersion")) {
                this.__FrunTimeVmVersion = true;
            }
            if (set.contains("useMonitor")) {
                this.__FuseMonitor = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getProcessMap")) {
                this.__MgetProcessMap = true;
            }
            if (set.contains("execJOnASCmd$org_ow2_jonas_deployment_clusterd_xml_Server$java_lang_String$java_lang_String")) {
                this.__MexecJOnASCmd$org_ow2_jonas_deployment_clusterd_xml_Server$java_lang_String$java_lang_String = true;
            }
            if (set.contains("isDefinedUserJonasCmd$org_ow2_jonas_deployment_clusterd_xml_Server")) {
                this.__MisDefinedUserJonasCmd$org_ow2_jonas_deployment_clusterd_xml_Server = true;
            }
            if (set.contains("getJOnASCmdName$org_ow2_jonas_deployment_clusterd_xml_Server")) {
                this.__MgetJOnASCmdName$org_ow2_jonas_deployment_clusterd_xml_Server = true;
            }
            if (set.contains("doStartJOnAS$java_lang_String$java_lang_String$boolean")) {
                this.__MdoStartJOnAS$java_lang_String$java_lang_String$boolean = true;
            }
            if (set.contains("doStopJOnAS$java_lang_String")) {
                this.__MdoStopJOnAS$java_lang_String = true;
            }
            if (set.contains("doHaltJOnAS$java_lang_String")) {
                this.__MdoHaltJOnAS$java_lang_String = true;
            }
            if (set.contains("doKillJOnAS$java_lang_String")) {
                this.__MdoKillJOnAS$java_lang_String = true;
            }
            if (set.contains("waitEndProcess$java_lang_Process")) {
                this.__MwaitEndProcess$java_lang_Process = true;
            }
            if (set.contains("doPingJOnAS$java_lang_String$int")) {
                this.__MdoPingJOnAS$java_lang_String$int = true;
            }
            if (set.contains("doCheckState$java_lang_String")) {
                this.__MdoCheckState$java_lang_String = true;
            }
            if (set.contains("checkServerState$java_lang_String")) {
                this.__McheckServerState$java_lang_String = true;
            }
            if (set.contains("isServerRunning$java_lang_String")) {
                this.__MisServerRunning$java_lang_String = true;
            }
            if (set.contains("initLogger")) {
                this.__MinitLogger = true;
            }
            if (set.contains("startNameService")) {
                this.__MstartNameService = true;
            }
            if (set.contains("initMBeans")) {
                this.__MinitMBeans = true;
            }
            if (set.contains("buildRuntimeInfo")) {
                this.__MbuildRuntimeInfo = true;
            }
            if (set.contains("isLooselyCoupled")) {
                this.__MisLooselyCoupled = true;
            }
            if (set.contains("isTighlyCoupled")) {
                this.__MisTighlyCoupled = true;
            }
            if (set.contains("getServer$java_lang_String")) {
                this.__MgetServer$java_lang_String = true;
            }
            if (set.contains("doStartAllJOnAS$java_lang_String$java_lang_String$boolean$boolean")) {
                this.__MdoStartAllJOnAS$java_lang_String$java_lang_String$boolean$boolean = true;
            }
            if (set.contains("doStopAllJOnAS")) {
                this.__MdoStopAllJOnAS = true;
            }
            if (set.contains("doKillAllJOnAS")) {
                this.__MdoKillAllJOnAS = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("startDiscovery")) {
                this.__MstartDiscovery = true;
            }
            if (set.contains("displayDynamicAttributes")) {
                this.__MdisplayDynamicAttributes = true;
            }
            if (set.contains("getObjectName")) {
                this.__MgetObjectName = true;
            }
            if (set.contains("setObjectName$java_lang_String")) {
                this.__MsetObjectName$java_lang_String = true;
            }
            if (set.contains("iseventProvider")) {
                this.__MiseventProvider = true;
            }
            if (set.contains("isstateManageable")) {
                this.__MisstateManageable = true;
            }
            if (set.contains("isstatisticsProvider")) {
                this.__MisstatisticsProvider = true;
            }
            if (set.contains("getJavaHome4Server$java_lang_String")) {
                this.__MgetJavaHome4Server$java_lang_String = true;
            }
            if (set.contains("getJonasBase4Server$java_lang_String")) {
                this.__MgetJonasBase4Server$java_lang_String = true;
            }
            if (set.contains("getJonasRoot4Server$java_lang_String")) {
                this.__MgetJonasRoot4Server$java_lang_String = true;
            }
            if (set.contains("getJonasCmd4Server$java_lang_String")) {
                this.__MgetJonasCmd4Server$java_lang_String = true;
            }
            if (set.contains("getXprm4Server$java_lang_String")) {
                this.__MgetXprm4Server$java_lang_String = true;
            }
            if (set.contains("getAutoBoot4Server$java_lang_String")) {
                this.__MgetAutoBoot4Server$java_lang_String = true;
            }
            if (set.contains("getJmxPort4Server$java_lang_String")) {
                this.__MgetJmxPort4Server$java_lang_String = true;
            }
            if (set.contains("getDomain4Server$java_lang_String")) {
                this.__MgetDomain4Server$java_lang_String = true;
            }
            if (set.contains("getJmxUrl4Server$java_lang_String")) {
                this.__MgetJmxUrl4Server$java_lang_String = true;
            }
            if (set.contains("buildControlledServersNames")) {
                this.__MbuildControlledServersNames = true;
            }
            if (set.contains("flushConfiguration")) {
                this.__MflushConfiguration = true;
            }
            if (set.contains("removeServer$java_lang_String")) {
                this.__MremoveServer$java_lang_String = true;
            }
            if (set.contains("delete$java_io_File")) {
                this.__Mdelete$java_io_File = true;
            }
            if (set.contains("modifyServer$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MmodifyServer$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("reloadConfiguration")) {
                this.__MreloadConfiguration = true;
            }
            if (set.contains("startJOnAS$java_lang_String$java_lang_String")) {
                this.__MstartJOnAS$java_lang_String$java_lang_String = true;
            }
            if (set.contains("stopJOnAS$java_lang_String")) {
                this.__MstopJOnAS$java_lang_String = true;
            }
            if (set.contains("haltJOnAS$java_lang_String")) {
                this.__MhaltJOnAS$java_lang_String = true;
            }
            if (set.contains("pingJOnAS$java_lang_String")) {
                this.__MpingJOnAS$java_lang_String = true;
            }
            if (set.contains("startAllJOnAS$java_lang_String$java_lang_String")) {
                this.__MstartAllJOnAS$java_lang_String$java_lang_String = true;
            }
            if (set.contains("stopAllJOnAS")) {
                this.__MstopAllJOnAS = true;
            }
            if (set.contains("stopClusterDaemon")) {
                this.__MstopClusterDaemon = true;
            }
            if (set.contains("getName")) {
                this.__MgetName = true;
            }
            if (set.contains("getControlledServersNames")) {
                this.__MgetControlledServersNames = true;
            }
            if (set.contains("isServerManaged$java_lang_String")) {
                this.__MisServerManaged$java_lang_String = true;
            }
            if (set.contains("serversNames")) {
                this.__MserversNames = true;
            }
            if (set.contains("getJmxUrl")) {
                this.__MgetJmxUrl = true;
            }
            if (set.contains("setJmxUrl$java_lang_String")) {
                this.__MsetJmxUrl$java_lang_String = true;
            }
            if (set.contains("getOperatingSystemAvailableProcessors")) {
                this.__MgetOperatingSystemAvailableProcessors = true;
            }
            if (set.contains("setOperatingSystemAvailableProcessors$java_lang_String")) {
                this.__MsetOperatingSystemAvailableProcessors$java_lang_String = true;
            }
            if (set.contains("getOperatingSystemName")) {
                this.__MgetOperatingSystemName = true;
            }
            if (set.contains("setOperatingSystemName$java_lang_String")) {
                this.__MsetOperatingSystemName$java_lang_String = true;
            }
            if (set.contains("getOperatingSystemVersion")) {
                this.__MgetOperatingSystemVersion = true;
            }
            if (set.contains("setOperatingSystemVersion$java_lang_String")) {
                this.__MsetOperatingSystemVersion$java_lang_String = true;
            }
            if (set.contains("getRunTimeSpecVendor")) {
                this.__MgetRunTimeSpecVendor = true;
            }
            if (set.contains("setRunTimeSpecVendor$java_lang_String")) {
                this.__MsetRunTimeSpecVendor$java_lang_String = true;
            }
            if (set.contains("getRunTimeSpecVersion")) {
                this.__MgetRunTimeSpecVersion = true;
            }
            if (set.contains("setRunTimeSpecVersion$java_lang_String")) {
                this.__MsetRunTimeSpecVersion$java_lang_String = true;
            }
            if (set.contains("getRunTimeVmName")) {
                this.__MgetRunTimeVmName = true;
            }
            if (set.contains("setRunTimeVmName$java_lang_String")) {
                this.__MsetRunTimeVmName$java_lang_String = true;
            }
            if (set.contains("getRunTimeVmVendor")) {
                this.__MgetRunTimeVmVendor = true;
            }
            if (set.contains("setRunTimeVmVendor$java_lang_String")) {
                this.__MsetRunTimeVmVendor$java_lang_String = true;
            }
            if (set.contains("getRunTimeVmVersion")) {
                this.__MgetRunTimeVmVersion = true;
            }
            if (set.contains("setRunTimeVmVersion$java_lang_String")) {
                this.__MsetRunTimeVmVersion$java_lang_String = true;
            }
            if (set.contains("getDynamicHostAttributes")) {
                this.__MgetDynamicHostAttributes = true;
            }
            if (set.contains("buildOperatingSystemdynInfo")) {
                this.__MbuildOperatingSystemdynInfo = true;
            }
            if (set.contains("initHostInfos")) {
                this.__MinitHostInfos = true;
            }
            if (set.contains("getOperatingSystemArch")) {
                this.__MgetOperatingSystemArch = true;
            }
            if (set.contains("setOperatingSystemArch$java_lang_String")) {
                this.__MsetOperatingSystemArch$java_lang_String = true;
            }
            if (set.contains("getVmCurrentUsedNonHeapMemory")) {
                this.__MgetVmCurrentUsedNonHeapMemory = true;
            }
            if (set.contains("getOsCurrentUsedSpace")) {
                this.__MgetOsCurrentUsedSpace = true;
            }
            if (set.contains("getOsTotalSpace")) {
                this.__MgetOsTotalSpace = true;
            }
            if (set.contains("getJmxPort$java_lang_String")) {
                this.__MgetJmxPort$java_lang_String = true;
            }
            if (set.contains("getJmxPort$java_util_Properties$java_lang_String")) {
                this.__MgetJmxPort$java_util_Properties$java_lang_String = true;
            }
            if (set.contains("generateReport$java_lang_String")) {
                this.__MgenerateReport$java_lang_String = true;
            }
            if (set.contains("getVmCurrentUsedHeapMemory")) {
                this.__MgetVmCurrentUsedHeapMemory = true;
            }
            if (set.contains("getVmCurrentUsedMemory")) {
                this.__MgetVmCurrentUsedMemory = true;
            }
            if (set.contains("getVmTotalMemory")) {
                this.__MgetVmTotalMemory = true;
            }
            if (set.contains("getOsAtributeValue$java_lang_String")) {
                this.__MgetOsAtributeValue$java_lang_String = true;
            }
            if (set.contains("addServer$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddServer$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("removeServer$java_lang_String$java_lang_String")) {
                this.__MremoveServer$java_lang_String$java_lang_String = true;
            }
            if (set.contains("saveConfiguration")) {
                this.__MsaveConfiguration = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

