/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.db.base;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.db.base.User;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;

public abstract class AbsDBServiceImpl
extends AbsServiceImpl {
    private static final String DEFAULT_DATABASE_NAME = "db_jonas";
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.db");
    private List<User> users = new ArrayList<User>();
    private String port = null;
    private String dbName = "db_jonas";
    protected JmxService jmxService;
    protected ObjectName objectName;
    protected String portNumber = null;

    public void setUsers(String users) {
        List configuredUsers = AbsDBServiceImpl.convertToList((String)users);
        for (String user : configuredUsers) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Adding user/password '" + user + "'."));
            }
            StringTokenizer st = new StringTokenizer(user, ":");
            String name = st.nextToken();
            String pass = "";
            if (st.hasMoreTokens()) {
                pass = st.nextToken();
            }
            this.users.add(new User(name, pass));
        }
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setDbname(String db) {
        this.dbName = db;
    }

    protected abstract void initServer(List<User> var1, String var2, String var3) throws ServiceException;

    protected void doStart() throws ServiceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        this.initServer(this.users, this.dbName, this.port);
        this.initObjectName();
        this.registerMBean();
    }

    protected void doStop() throws ServiceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public void bindJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void unbindJmxService(JmxService jmxService) {
        this.jmxService = null;
    }

    private void initObjectName() {
        String pattern = this.jmxService.getDomainName() + ":type=service,name=db";
        try {
            this.objectName = new ObjectName(pattern);
        }
        catch (MalformedObjectNameException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot instanciate ObjectName with pattern '" + pattern), (Throwable)e);
        }
    }

    protected void registerMBean() {
        if (this.objectName != null) {
            try {
                this.jmxService.getJmxServer().registerMBean((Object)this, this.objectName);
            }
            catch (InstanceAlreadyExistsException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot register MBean with ObjectName " + this.objectName), (Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot register MBean with ObjectName " + this.objectName), (Throwable)e);
            }
            catch (NotCompliantMBeanException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot register MBean with ObjectName " + this.objectName), (Throwable)e);
            }
        }
    }

    public String getPortNumber() {
        return this.portNumber;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDbUsers() {
        StringBuilder stringBuilder = new StringBuilder();
        for (User user : this.users) {
            stringBuilder.append(user.getUserName() + ":" + user.getPassword() + ",");
        }
        String users = stringBuilder.toString();
        if (users.length() > 0) {
            return users.substring(0, users.length() - 1);
        }
        return null;
    }
}

