/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cdi.weld.internal.services;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.ejb.EJB;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.weld.injection.spi.EjbInjectionServices;

public class JOnASEjbInjectionServices
implements EjbInjectionServices {
    private static final String JAVA_COMP_ENV = "java:comp/env";
    private Context context;

    public JOnASEjbInjectionServices(Context context) {
        this.context = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object resolveEjb(InjectionPoint injectionPoint) {
        String lookupName;
        EJB ejb = (EJB)injectionPoint.getAnnotated().getAnnotation(EJB.class);
        if (ejb == null) {
            throw new IllegalStateException("Unable to resolve EJB reference as injection point is not annotated with @EJB");
        }
        String mappedName = ejb.mappedName();
        String name = ejb.name();
        if (!mappedName.equals("")) {
            lookupName = mappedName;
        } else if (!name.equals("")) {
            lookupName = "java:comp/env/" + name;
        } else {
            String propertyName;
            if (injectionPoint.getMember() instanceof Field) {
                propertyName = injectionPoint.getMember().getName();
            } else {
                if (!(injectionPoint.getMember() instanceof Method)) throw new IllegalArgumentException("Unable to inject into " + injectionPoint + " which is neither a field nor a method");
                propertyName = injectionPoint.getMember().getName();
                if (propertyName.startsWith("get")) {
                    propertyName = Introspector.decapitalize(propertyName.substring(3));
                } else {
                    if (!propertyName.startsWith("is")) throw new IllegalArgumentException("Unable to inject into " + injectionPoint + " as this method doesn't follow JavaBeans naming convention.");
                    propertyName = Introspector.decapitalize(propertyName.substring(2));
                }
            }
            String className = injectionPoint.getMember().getDeclaringClass().getName();
            lookupName = "java:comp/env/" + className + "/" + propertyName;
        }
        try {
            return this.context.lookup(lookupName);
        }
        catch (NamingException e) {
            throw new RuntimeException("Error looking up " + lookupName + " in JNDI", e);
        }
    }

    public void cleanup() {
    }
}

