/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jndi.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.ow2.jonas.configadmin.AdapterException;
import org.ow2.jonas.configadmin.ConfigurationInfo;
import org.ow2.jonas.configadmin.XmlConfigurationAdapter;
import org.ow2.jonas.jndi.JndiService;
import org.ow2.jonas.jndi.internal.JndiEntriesService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JndiAdapter
implements XmlConfigurationAdapter {
    public static final String JNDI_SERVICE_PID = JndiEntriesService.class.getName();
    public static final String ENTRY = "entry";
    public static final String ENTRY_NAME = "name";
    public static final String ENTRY_TYPE = "type";
    public static final String ENTRY_VALUE = "value";
    public static final String POLICY = "policy";
    public static final String XSD_RESOURCE = "/META-INF/configadmin-jndi-1.0.xsd";
    private JndiService jndiService;
    private static final Log logger = LogFactory.getLog(JndiAdapter.class);

    public JndiAdapter(JndiService jndiService) {
        this.jndiService = jndiService;
    }

    public Set<ConfigurationInfo> convert(Element node) throws AdapterException {
        try {
            if (!this.validate(node)) {
                throw new AdapterException("Cannot validate the XML Node " + node.getNodeName());
            }
        }
        catch (AdapterException e) {
            throw new AdapterException("Cannot validate the XML Node " + node.getNodeName(), (Throwable)e);
        }
        ConfigurationInfo info = new ConfigurationInfo(JNDI_SERVICE_PID, true);
        Map props = info.getProperties();
        Vector<String> names = new Vector<String>();
        Vector<String> values = new Vector<String>();
        Vector<String> types = new Vector<String>();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            if (POLICY.equals(child.getNodeName())) {
                props.put(POLICY, child.getFirstChild().getNodeValue());
                continue;
            }
            if (!ENTRY.equals(child.getNodeName())) continue;
            for (Node n = child.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1) continue;
                Node valueNode = n.getFirstChild();
                String key = n.getNodeName();
                String val = new String();
                if (valueNode != null) {
                    val = valueNode.getNodeValue();
                }
                if (ENTRY_NAME.equals(key)) {
                    names.add(val);
                    continue;
                }
                if (ENTRY_TYPE.equals(key)) {
                    types.add(val);
                    continue;
                }
                if (!ENTRY_VALUE.equals(key)) continue;
                values.add(val);
            }
        }
        if (props.get(POLICY) == null) {
            props.put(POLICY, this.jndiService.getDefaultPolicy());
        }
        props.put(ENTRY_NAME, names);
        props.put(ENTRY_VALUE, values);
        props.put(ENTRY_TYPE, types);
        return Collections.singleton(info);
    }

    private boolean validate(Node node) throws AdapterException {
        InputStream xsdInputStream = this.getClass().getResourceAsStream(XSD_RESOURCE);
        if (xsdInputStream != null) {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = null;
            try {
                schema = factory.newSchema(new StreamSource(xsdInputStream));
            }
            catch (SAXException e) {
                throw new AdapterException("Cannot create a new Schema from the resource /META-INF/configadmin-jndi-1.0.xsd", (Throwable)e);
            }
            Validator validator = schema.newValidator();
            try {
                validator.validate(new DOMSource(node));
                return true;
            }
            catch (SAXException e) {
                logger.error((Object)("Cannot validate the Node " + node.getNodeName() + " from the XSD " + "resource " + XSD_RESOURCE), new Object[]{e});
                return false;
            }
            catch (IOException e) {
                logger.error((Object)("Cannot validate the Node " + node.getNodeName() + " from the XSD " + "resource " + XSD_RESOURCE), new Object[]{e});
                return false;
            }
        }
        throw new AdapterException("Cannot get the inputstream of the resource configadmin-jndi-1.0.xsd");
    }
}

