/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat7.tx;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class TransactionValve
extends ValveBase {
    private Log logger = LogFactory.getLog(TransactionValve.class);
    private TransactionManager transactionmanager = null;

    public TransactionValve(TransactionManager transactionManager) {
        super(true);
        this.transactionmanager = transactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Transaction existingTransaction = null;
        try {
            existingTransaction = this.transactionmanager.getTransaction();
        }
        catch (SystemException e) {
            throw new IllegalStateException("Unable to check if there is a transaction", e);
        }
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            if (existingTransaction == null) {
                Transaction txAfterMethod = null;
                try {
                    txAfterMethod = this.transactionmanager.getTransaction();
                }
                catch (SystemException e) {
                    throw new IllegalStateException("Unable to check if there is a transaction", e);
                }
                if (txAfterMethod != null) {
                    int transactionStatus = 0;
                    try {
                        transactionStatus = txAfterMethod.getStatus();
                        if (transactionStatus != 3) {
                            String errMsg = "Transaction started in the servlet '" + request.getServletPath() + "' but not committed. Rolling back...";
                            this.logger.error((Object)errMsg, new Object[0]);
                            txAfterMethod.rollback();
                        }
                    }
                    catch (SystemException e) {
                        throw new IllegalStateException("Cannot rollback transaction", e);
                    }
                }
            }
        }
    }
}

