/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.multitenant.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.multitenant.MultitenantService;
import org.ow2.jonas.multitenant.internal.MultitenantVirtualJNDIBindingMBean;
import org.ow2.jonas.registry.RegistryService;

public class MultitenantVirtualJNDIBinding
implements MultitenantVirtualJNDIBindingMBean {
    private static Log logger = LogFactory.getLog(MultitenantVirtualJNDIBinding.class);
    private static JmxService jmxService = null;
    private static RegistryService registryService = null;
    private static MultitenantService multitenantService = null;
    private static List<MultitenantVirtualJNDIBinding> bindings = new ArrayList<MultitenantVirtualJNDIBinding>();
    private String applicationName = null;
    private String mBeanName;
    private Map<String, String> policies = new HashMap<String, String>();
    private Map<String, List<String>> beans = new HashMap<String, List<String>>();

    public static void initialize(JmxService jmx, RegistryService registry, MultitenantService multitenant) {
        jmxService = jmx;
        registryService = registry;
        multitenantService = multitenant;
    }

    public static void createJNDIBindingMBeans(String appName, String prefix) {
        if (jmxService == null || multitenantService == null || registryService == null) {
            throw new IllegalStateException("Services not set: call VirtualJNDIBinding.initialize");
        }
        for (MultitenantVirtualJNDIBinding binding : bindings) {
            if (!binding.applicationName.equals(appName)) continue;
            binding.addContext(prefix, multitenantService.getDefaultDeploymentPolicy());
            return;
        }
        new MultitenantVirtualJNDIBinding(appName, prefix);
    }

    protected MultitenantVirtualJNDIBinding(String appName, String prefix) {
        if (appName == null) {
            appName = "none";
        }
        this.applicationName = appName;
        this.mBeanName = jmxService.getDomainName() + ":j2eeType=EJBModule,J2EEServer=" + jmxService.getJonasServerName() + ",J2EEApplication=none,name=MultitenantVirtualContainer-" + appName + ",virtualContext=true";
        logger.debug((Object)("New MultitenantVirtualJNDIBinding: registering MBean with name : " + this.mBeanName));
        jmxService.registerMBean((Object)this, this.mBeanName);
        this.addContext(prefix, "Default");
        bindings.add(this);
    }

    public void addContext(String prefix, String policy) throws IllegalArgumentException {
        if (!("Default".equals(policy) || "Disabled".equals(policy) || "Reserved".equals(policy) || "Private".equals(policy))) {
            throw new IllegalArgumentException("Invalid policy : " + policy);
        }
        if (this.hasContext(prefix)) {
            throw new IllegalArgumentException("JNDI prefix " + prefix + " already bound!");
        }
        ArrayList<String> beans = new ArrayList<String>();
        try {
            InitialContext jndi = registryService.getRegistryContext();
            NamingEnumeration<NameClassPair> elements = jndi.list("");
            while (elements.hasMoreElements()) {
                String name;
                NameClassPair current = (NameClassPair)elements.nextElement();
                try {
                    name = current.getNameInNamespace();
                }
                catch (Exception e) {
                    name = current.getName();
                }
                if (prefix.length() <= 0 || !name.contains(prefix)) continue;
                name = name.replace(prefix, "");
                beans.add(name);
            }
        }
        catch (NamingException e) {
            throw new IllegalStateException("Failed creating JNDI binding MBeans", e);
        }
        this.beans.put(prefix, beans);
        this.rebindContext(prefix, policy);
    }

    public boolean hasContext(String prefix) {
        return this.policies.containsKey(prefix) && this.beans.containsKey(prefix);
    }

    public boolean rebindContext(String prefix, String policy) throws IllegalArgumentException {
        if (!("Default".equals(policy) || "Disabled".equals(policy) || "Reserved".equals(policy) || "Private".equals(policy))) {
            throw new IllegalArgumentException("Invalid policy : " + policy);
        }
        List<String> beanNames = this.beans.get(prefix);
        if (beanNames == null) {
            return false;
        }
        String oldDefault = null;
        String oldPolicy = this.policies.get(prefix);
        if ("Default".equals(oldPolicy)) {
            oldDefault = prefix;
        } else if ("Default".equals(policy)) {
            for (Map.Entry entry : this.policies.entrySet()) {
                if (!((String)entry.getValue()).equals("Default")) continue;
                oldDefault = (String)entry.getKey();
                break;
            }
        }
        if (oldDefault != null) {
            for (String string : this.beans.get(oldDefault)) {
                try {
                    InitialContext jndi = registryService.getRegistryContext();
                    jndi.unbind(string);
                }
                catch (NamingException ignored) {}
            }
            this.policies.put(oldDefault, "Disabled");
        }
        this.policies.put(prefix, policy);
        this.checkJNDIBindings();
        return true;
    }

    public void checkJNDIBindings() {
        if (jmxService == null || multitenantService == null || registryService == null) {
            throw new IllegalStateException("Services not set: call MultitenantVirtualJNDIBinding.initialize");
        }
        try {
            for (Map.Entry<String, String> entry : this.policies.entrySet()) {
                if (!entry.getValue().equals("Default")) continue;
                InitialContext jndi = registryService.getRegistryContext();
                Object newBeanName = null;
                for (String beanName : this.beans.get(entry.getKey())) {
                    jndi.rebind(beanName, jndi.lookupLink(entry.getKey() + beanName));
                }
                return;
            }
            logger.warn((Object)("No Default JNDI binding present for application '" + this.applicationName + "'. You need to set a version as default or expect lookup and unbind failures."));
        }
        catch (NamingException e) {
            throw new IllegalStateException("Failed checking default JNDI bindings", e);
        }
    }

    public static void garbageCollectJNDIBindingMBeans() {
        if (jmxService == null || multitenantService == null || registryService == null) {
            throw new IllegalStateException("Services not set: call MultitenantVirtualJNDIBinding.initialize");
        }
        ArrayList<String> beansOnJNDI = new ArrayList<String>();
        try {
            InitialContext jndi = registryService.getRegistryContext();
            NamingEnumeration<NameClassPair> elements = jndi.list("");
            while (elements.hasMoreElements()) {
                NameClassPair current = (NameClassPair)elements.nextElement();
                beansOnJNDI.add(current.getName());
            }
        }
        catch (NamingException e) {
            throw new IllegalStateException("Failed garbage collecting JNDI binding MBeans", e);
        }
        for (MultitenantVirtualJNDIBinding binding : bindings.toArray(new MultitenantVirtualJNDIBinding[bindings.size()])) {
            MultitenantVirtualJNDIBinding.gcJNDIBinding(binding, beansOnJNDI);
        }
    }

    private static void gcJNDIBinding(MultitenantVirtualJNDIBinding binding, List<String> beansOnJNDI) {
        for (Map.Entry<String, List<String>> beanList : binding.beans.entrySet()) {
            for (String beanName : beanList.getValue()) {
                if (beansOnJNDI.contains(beanList.getKey() + beanName)) continue;
                binding.removePrefix(beanList.getKey());
                binding.checkJNDIBindings();
                return;
            }
        }
    }

    public boolean removePrefix(String prefix) {
        this.rebindContext(prefix, "Disabled");
        this.policies.remove(prefix);
        this.beans.remove(prefix);
        if (this.beans.size() == 0 || this.policies.size() == 0) {
            return this.removeVirtualContext();
        }
        return true;
    }

    public boolean removeVirtualContext() {
        ArrayList<Map.Entry<String, String>> prefixes = new ArrayList<Map.Entry<String, String>>(this.getContexts().entrySet());
        for (Map.Entry entry : prefixes) {
            this.rebindContext((String)entry.getKey(), "Disabled");
            this.policies.remove(entry);
            this.beans.remove(entry);
        }
        try {
            jmxService.unregisterMBean(ObjectName.getInstance(this.mBeanName));
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)("Error unbinding Virtual JNDI Binding Manager " + this.mBeanName), (Throwable)e);
            return false;
        }
        bindings.remove(this);
        return true;
    }

    public Map<String, String> getContexts() {
        HashMap<String, String> result = new HashMap<String, String>(this.policies.size());
        result.putAll(this.policies);
        return result;
    }

    @Override
    public Map<String, List<String>> getNames() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(this.beans.size());
        for (Map.Entry<String, List<String>> bean : this.beans.entrySet()) {
            ArrayList<String> beanNames = new ArrayList<String>(bean.getValue().size());
            for (String beanName : bean.getValue()) {
                beanNames.add(beanName);
            }
            result.put(bean.getKey(), beanNames);
        }
        return result;
    }

    @Override
    public URL geturl() {
        try {
            return new URL("file:///dev/null/MultitenantVirtualEJBContainer-" + this.applicationName);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot create URL", e);
        }
    }

    @Override
    public String[] getejbs() {
        return new String[0];
    }
}

